<!DOCTYPE html>
<html lang="es">
<style>
/* Full-width input fields */
input[type=text], input[type=password] {
    width: 100%;
    padding: 12px 20px;
    margin: 8px 0;
    display: inline-block;
    border: 1px solid #ccc;
    box-sizing: border-box;
}

/* Set a style for all buttons */
button {
    background-color: #4CAF50;
    color: white;
    padding: 14px 20px;
    margin: 8px 0;
    border: none;
    cursor: pointer;
    width: 100%;
}

button:hover {
    opacity: 0.8;
}

/* Extra styles for the cancel button */
.cancelbtn {
    width: auto;
    padding: 10px 18px;
    background-color: #f44336;
}

/* Center the image and position the close button */
.imgcontainer {
    text-align: center;
    margin: 24px 0 12px 0;
    position: relative;
}

img.avatar {
    width: 40%;
    border-radius: 50%;
}

.container {
    padding: 16px;
}

span.psw {
    float: right;
    padding-top: 16px;
}

/* The Modal (background) */
.modal {
    display: none; /* Hidden by default */
    position: fixed; /* Stay in place */
    z-index: 1; /* Sit on top */
    left: 0;
    top: 0;
    width: 100%; /* Full width */
    height: 100%; /* Full height */
    overflow: auto; /* Enable scroll if needed */
    background-color: rgb(0,0,0); /* Fallback color */
    background-color: rgba(0,0,0,0.4); /* Black w/ opacity */
    padding-top: 60px;
}

/* Modal Content/Box */
.modal-content {
    background-color: #fefefe;
    margin: 5% auto 15% auto; /* 5% from the top, 15% from the bottom and centered */
    border: 1px solid #888;
    width: 80%; /* Could be more or less, depending on screen size */
}

/* The Close Button (x) */
.close {
    position: absolute;
    right: 25px;
    top: 0;
    color: #000;
    font-size: 35px;
    font-weight: bold;
}

.close:hover,
.close:focus {
    color: red;
    cursor: pointer;
}

/* Add Zoom Animation */
.animate {
    -webkit-animation: animatezoom 0.6s;
    animation: animatezoom 0.6s
}

@-webkit-keyframes animatezoom {
    from {-webkit-transform: scale(0)} 
    to {-webkit-transform: scale(1)}
}
    
@keyframes animatezoom {
    from {transform: scale(0)} 
    to {transform: scale(1)}
}

/* Change styles for span and cancel button on extra small screens */
@media screen and (max-width: 300px) {
    span.psw {
       display: block;
       float: none;
    }
    .cancelbtn {
       width: 100%;
    }
}
</style>
<head>
	<meta name="viewport" content="initial-scale=1.0, user-scalable=no">
	<meta charset="UTF-8">
	<title>Regislog WEB</title>
	<link rel="stylesheet"  type="text/css" href="css/index-css.css?v=<?=time();?>">
	<link rel="icon" href="img/microchip.ico">
    <script type="text/javascript" src="js/jquery-1.11.2.min.js"></script>
	
	 <style>
      /* Always set the map height explicitly to define the size of the div
       * element that contains the map. */
      #map {
        height: 50%;
        width: 50%;
      }
    </style>
</head>
<body>
	<header id="cabecera" class="menuCabecera">
		<h1>Regislog WEB</h1>
		<a id="idHref" href="#">
			<div> <img src="img/microchip.svg" alt="Regislog WEB" height="80px" width="80px" id="cuadros"></div>
		</a>
        <div id="modulosRegisbus">
        </div> 
		<div id="id01" class="modal">
  
		  <form class="modal-content animate" action="/action_page.php">
		    <div class="imgcontainer">
		      <span onclick="document.getElementById('id01').style.display='none'" class="close" title="Close Modal">&times;</span>
		      <!-- <img src="img_avatar2.png" alt="Avatar" class="avatar"> -->
               
		    </div>

		    <div class="container">
		      <label><b>Username</b></label>
		      <input id="user" type="text" placeholder="Enter Username" name="uname" required>

		      <label><b>Password</b></label>
		      <input id="pass" type="password" placeholder="Enter Password" name="psw" required>
		        
		      <button type="submit" id="login">Login</button>
		      
		    </div>

		    <div class="container" style="background-color:#f1f1f1">
		      <button type="button" onclick="document.getElementById('id01').style.display='none'" class="cancelbtn">Cancel</button>
		      
		    </div>
		  </form>
		</div>

	</header>
<script>

//Constantes
var READY_STATE_COMPLETE = 4;
var STATUS_OK = 200;
//Variables
var ajax = null;
var firmware = null;
var user = null;
var placa = null;
var numero_comando = 0;
function alCargarDocumento(){
    numero_comando = 1;
    var datos = "transaccion=getHardware&";
    ejecutarAJAX(datos);
    document.querySelector("#login").addEventListener("click",hacerLogin);

}

function ejecutarAJAX(datos){
    ajax = objetoAJAX();
    ajax.onreadystatechange=enviarDatos; //Detecta los cambios de estado, existen varios
    ajax.open("POST","controlador_p.php");
    ajax.setRequestHeader("Content-Type","application/x-www-form-urlencoded");
    ajax.send(datos);
}

function enviarDatos(){
    if(ajax.readyState == READY_STATE_COMPLETE){
        if(ajax.status == STATUS_OK){ // Respuesta para peticiones correctas   
            if(numero_comando == 1){
                var res = ajax.responseText.split("&");
                //console.log(res);
                var res1 = res[0].split(",");
                firmware = res1[0];
                placa = res[1];
                if(ajax.responseText.indexOf("F2") >-1){ //Detecta si es regiscenter include
                    document.querySelector("#modulosRegisbus").innerHTML = "";
                }else{

                    var modulosregis = '<h1>Modulo Conductor</h1>';
                    modulosregis += '<a href="/Conductor/conductor.php">';
                    modulosregis += '<div> <img src="img/driver.svg" alt="Modulo Conductor" height="80px" width="80px" id="cuadros"></div>';
                    modulosregis += '</a>';
                    modulosregis += '<h1>Modulo Validador</h1>';
                    modulosregis += '<a href="/UsuarioRfid/usuario_rfid.php">';
                    modulosregis += '<div> <img src="img/wallet.svg" alt="Modulo Validador" height="80px" width="80px" id="cuadros"></div>';
                    modulosregis += '</a>';
                    document.querySelector("#modulosRegisbus").innerHTML = modulosregis;
                    cargarPermisos();
                }
            }
            if(numero_comando == 2){
                var data = ajax.responseText; 
                var partes = data.split(",");
                partes[1] = partes[1].replace(/[|&;$%@"<>()+,]/g, "");
                
                partes[2] = partes[2].replace(/[|&;$%@"<>()+,]/g, "");
                
                partes[3] = partes[3].replace(/[|&;$%@"<>()+,]/g, "");

                partes[4] = partes[4].replace(/[|&;$%@"<>()+,]/g, "");
                
                partes[5] = partes[5].replace(/[|&;$%@"<>()+,]/g, "");
                
                partes[6] = partes[6].replace(/[|&;$%@"<>()+,]/g, "");
                
                var user = "cliente"
                var referencia = "/RegislogWeb/regislog.php?firmware="+firmware+"&user="+user+"&placa="+placa+"&permisos="+partes[1];
                document.getElementById("idHref").href=referencia;
                //window.location.href = "/RegislogWeb/regislog.php?firmware="+firmware+"&user="+user+"&placa="+placa+"&permisos="+partes[1];
            }
        }
    }
}

function cargarPermisos(){
    numero_comando = 2;
     var datos = "transaccion=permisosUsuario";
    ejecutarAJAX(datos);
}

function objetoAJAX(){ // Obtiene el objeto AJAX del navegador
    if(window.XMLHttpRequest){ // Si es Chrome
        return new XMLHttpRequest();
    }else if(window.ActiveXObject){ // Si es IE
        return new ActiveXObject("Microsoft.XMLHTTP");
    }
}

window.addEventListener("load",alCargarDocumento);

</script>	

</body>
</html>