//Constantes
var READY_STATE_COMPLETE = 4;
var STATUS_OK = 200;
//Variables
var ajax = null;
//var btnInsertar = document.querySelector("#insertar");
var precarga = document.querySelector("#precarga");
var respuesta = document.querySelector("#htmlTabla");

var btnCargarHistorico = document.querySelector("#boton_historico");
var btnCargarAlarmas = document.querySelector("#boton_alarmas");
var btnCargarContadores = document.querySelector("#boton_contadores");
var btnCargarGps = document.querySelector("#boton_gps");
var btnCargarWifi = document.querySelector("#boton_wifi");
var btnConfig = document.querySelector("#boton_config");
var btnInfoSys = document.querySelector("#boton_infoSistema");
var btnValidaciones = document.querySelector("#boton_validaciones");
var btnLogSistema = document.querySelector("#boton_logs");
var btnHerramientas = document.querySelector("#boton_herramientas");
var btnUsuario = document.querySelector("#boton_usuario");
var btnAudios = document.querySelector("#boton_audios");
var btnVideos = document.querySelector("#boton_videos");
var btnSalir = document.querySelector("#boton_salir");
var btnAyuda = document.querySelector("#boton_ayuda");
var mapa = document.querySelector("#mapa");
var reinicio = 0;
var tipoTabla = "";
var timer = null;
var timerSistema = null;
var timerGps = null;
var latitud;
var longitud;
var clickContador = 0;
var clickSistema = 0;
var clickGps = 0;
var retardoReinicio = 800;
var retardoApagado = 100;
var retardoAplicacion = 500;
var so_board;
var cambios_wifi = false;
var fechaInicialAlarma = "0";
var fechaFinalAlarma = "0";
var tipoAlarma = "0";
var matrizDatosConteo = [];
var filtroSeleccionado;  
var matrizVideos = [];
var clickPagina = false;
var firmwareJava = "";
var adjHora = 0;  
var v_recuperacion = -1;  
var titulo = "Regislog V2.32";
var FirmwareCambios = "<div>V2.22 Liberación de la aplicación</div>";
FirmwareCambios += "<div>V2.23 Ajuste en upload.php, corrige error cuando se actualiza el jar para equipos RV5</div>";
FirmwareCambios += "<div>V2.24 Ajuste en vistas.php, corrige error que no deja modificar el volumen en equipos Regiscenter control</div>";
FirmwareCambios += "<div>V2.25 Nueva función que permite actualizar HTML online</div>";
FirmwareCambios += "<div>V2.26 Se añaden videos de ayuda</div>";
FirmwareCambios += "<div>V2.27 Se eliminan funciones de mapas con google</div>";
FirmwareCambios += "<div>V2.28 Nueva función para recuperar información de la MMC. Otras mejoras</div>";
FirmwareCambios += "<div>V2.29 Mejoras módulo conductor. Mejoras módulo validador. Se añade función de limpieza Html</div>";
FirmwareCambios += "<div>V2.30 Mejoras función de limpieza. Correción de errores en video</div>";
FirmwareCambios += "<div>V2.31 Se muestra la MAC de las interfaces</div>";
FirmwareCambios += "<div>V2.32 Muestra al usuario si el sistema esta bloqueado</div>";
FirmwareCambios += "<div></div>";
//Funciones  
//Función que asigna los eventos al cargar el documento principal
function alCargarDocumento(){
	//btnInsertar.addEventListener("click",altaHistorico);
	btnCargarHistorico.addEventListener("click",cargarHistorico);
	btnCargarAlarmas.addEventListener("click",cargarAlarmas);
	btnCargarContadores.addEventListener("click",cargarContadores);
	btnCargarGps.addEventListener("click",cargarGps);
	btnCargarWifi.addEventListener("click",cargarWifi);
	btnConfig.addEventListener("click",cargarConfiguracion);
	btnInfoSys.addEventListener("click",CargarInfoSistema);
	btnValidaciones.addEventListener("click",CargarValidaciones);
	btnLogSistema.addEventListener("click",CargarLogSistema);
	btnHerramientas.addEventListener("click",CargarHerramientas);
	btnUsuario.addEventListener("click",CargarUsuario);
	btnAudios.addEventListener("click",CargarAudios);
        btnVideos.addEventListener("click",CargarVideos);
	btnSalir.addEventListener("click",Salir);
	btnAyuda.addEventListener("click",Ayuda);
	console.log("firmware: "+firmware);
	console.log("Cliente: "+user);
	console.log("Placa: "+placa);
    console.log("Bloqueo: "+bloqueo);
	v_recuperacion = firmware.localeCompare("F80008");
	console.log("v_recuperacion:"+v_recuperacion);
	
	var textoTitulo = "";
	var toogle = 0;

	if(firmware.includes("F8")) textoTitulo = "<span>"+titulo+" - Regisbus Premiun - "+placa+"</span>";
	else if(firmware.includes("F5")) textoTitulo = "<span>"+titulo+" - Regisbus Gold - "+placa+"</span>";
    else if(firmware.includes("F2")) textoTitulo = "<span>"+titulo+" - Regiscenter estadístico - "+placa+"</span>";
    else if(firmware.includes("F4")) textoTitulo = "<span>"+titulo+" - Regiscenter control - "+placa+"</span>";
    else textoTitulo = "<span>"+titulo+" - REVISAR HARDWARE - "+placa+"</span>"

    if(bloqueo == 0){
    	setInterval(function(){
    		if(toogle == 0){
    			textoTitulo = '<br><div style="color:red;font-weight:bold; background-color: white;">SISTEMA BLOQUEADO  '+placa+'</div><br>';
    			toogle = 1;
    		}else{
    			toogle = 0;
    			textoTitulo = '<br><div style="color:white;font-weight:bold; background-color: red;">SISTEMA BLOQUEADO  '+placa+'</div><br>';
    		}
    		$("#titulo").html(textoTitulo);
    	}, 1500);
    }	

	$("#titulo").html(textoTitulo);

    

	validarHardware();
	if(firmware.includes("F2")){ // Evalua si es regiscenter include
		$("#boton_gps").hide();
		$("#boton_validaciones").hide();
		$("#boton_audios").hide();
		
	}else { // Es un equipo Regisbus

	}
	if(user.includes("cliente")){

            permisos = permisos.replace(/[|&;$%@"<>()+,]/g, "");
            console.log("Permisos: "+permisos);
            if((permisos&1) == 0) $("#boton_validaciones").hide();
            if((permisos&2) == 0) $("#boton_gps").hide();
            if((permisos&4) == 0) $("#boton_wifi").hide();
            if((permisos&8) == 0) $("#boton_config").hide();
            if((permisos&16) == 0) $("#boton_infoSistema").hide();
            if((permisos&32) == 0) $("#boton_logs").hide();
            if((permisos&64) == 0) $("#boton_herramientas").hide();
            if((permisos&128) == 0) $("#boton_videos").hide();
		//$("#boton_logs").hide();
		//$("#boton_herramientas").hide();
	}

	//Almacena la variable de la versión del HTML en un archivo de texto
	$.ajax({
	    url: "controlador.php",
	    type: 'POST',
	    data: {transaccion:"guardarVersion", version:titulo},
	    datatype: "JSON",
	    success: function(data) {
	    	precarga.innerHTML = null;
		}
	});

	$.ajax({
	    url: "controlador.php",
	    type: 'POST',
	    data: {transaccion:"limpiarHtml"},	    
	    success: function(data) {
	        console.log(data);
	   	}
	});
	
    cargarContadores(null);
}
//Función que escanea la redes disponibles
function AddScanned(network) {
	console.log("Red a conectar:"+network);
	$("#ssid").val(network);
	document.getElementById("ip_config_form").scrollIntoView();
}
//Función que ingresa un historico
function altaHistorico(evento){
	evento.preventDefault();
	alert("funciona");
	var datos = "transaccion=alta";
	ejecutarAJAX(datos);
}
//Funcio que apaga el sistema
function apagarSistema(evento){
	evento.preventDefault();
	var datos = "transaccion=apagar";
	reinicio = 2;
	console.log(datos);
	ejecutarAJAX(datos);
}
//Función que aplica los cambios en la red Wifi
function aplicarCambiosWifi(evento){
	evento.preventDefault();
	cambios_wifi = false;
	var datos = "transaccion=aplicarCambiosWifi";
	ejecutarAJAX(datos);
}

function aplicarCambiosAudiosFun(evento){
	if(evento != null) evento.preventDefault();
	precarga.style.display = "block";
	precarga.innerHTML = "<img src='img/loader.gif' />";
	$.ajax({
	    url: "controlador.php",
	    type: 'POST',
	    data: {transaccion:"aplicarCambiosAudios"},
	    datatype: "JSON",
	    success: function(data) {
	    precarga.innerHTML = null;
	    if((data.includes("OK")) == true) {
	     		alert("Cambios realizados con exito");
	        	updateAudios();
	        }
	        else{ 
	        	alert("Error al aplicar los cambios de la programación de audios");	        	
	    	}
	   	}
	});
}
//Función que asigna los eventos de la tabla desplegada programaciion de audios
function asignarEventosAudio(){
	//Eventos enlaces eliminar
	var btnsEliminar = document.getElementsByClassName("eliminar");
	for(var i=0; i<btnsEliminar.length;i++){
		btnsEliminar[i].addEventListener('click', eliminarAudio);
	}
	//Eventos enlaces editar
	var btnsEditar = document.getElementsByClassName("editar");
	for(var i=0; i<btnsEditar.length;i++){
		btnsEditar[i].addEventListener('click', editarAudio);
	}
        
        //Eventos enlaces escuchar
	var btnsEscuchar = document.getElementsByClassName("escuchar");
	for(var i=0; i<btnsEscuchar.length;i++){
            btnsEscuchar[i].addEventListener('click', escucharAudio);
	}
        
	var aplicarCambiosAudios = document.querySelector("#aplicarCambiosAudios");
	aplicarCambiosAudios.addEventListener('click',aplicarCambiosAudiosFun);

	var borrarProgramacionAudios = document.querySelector("#borrarProgramacionAudios");
	borrarProgramacionAudios.addEventListener('click',borrarProgramacionAudiosFun);
	//console.log(aplicarCambiosAudios);
	precarga.innerHTML = null;
}


function asignarEventosContadores(){
	var editarContadoresVar = document.querySelector("#insertarcontadores-btn");
	editarContadoresVar.addEventListener('click',editarContadoresForm);
}

//Función que asigna los eventos en la vista de los logs
function asignarEventosLogs(){
	var borrarLogs = document.querySelector("#borrarLogs");
	if(borrarLogs != null ) borrarLogs.addEventListener('click',borrarAllLogs);
	precarga.innerHTML = null;
}

//Función que asigna los eventos a la vista de los videos
function asignarEventosVideos(){
        precarga.innerHTML = null;
         //Menu para filtrar los videos
        matrizVideos = null;
        matrizVideos = [];
        $(".rutaVideo").each(function( index ) {
        	matrizVideos[index] = $( this ).text();
				
		});
        var menuFiltro = "<h2><label for='sentido'>Seleccione una fecha para filtrar</label></h2>"
        menuFiltro += "<select name='filtro_tx' type='text' id='idOpcionesFiltro' >";
        var fecha, fecha1;
        var clasesTabla = [];
		var tablaElementos = [];
		var elementosFiltro = [];
        menuFiltro += "<option value='todos'>TODOS</option>";
		for(var i = 0; i< matrizVideos.length;i++){
			tablaElementos[i] = matrizVideos[i].split(" ");
			clasesTabla[i] = tablaElementos[i][0];		
		}
		var j = 0;
        for(var i = 0; i< clasesTabla.length;i++){
			for(j = i+1; j< clasesTabla.length;j++){
				if(clasesTabla[i] == clasesTabla[j]){
					clasesTabla.splice(j,1);
					j--;	
				}
			}
		}
		console.log(clasesTabla);
		clasesTabla.forEach(function(element){
			menuFiltro += "<option value="+i+">"+element+"</option>";
		});
        menuFiltro += "</select>";
        menuFiltro += "<input type='button' id='idBotonFiltrar' name='botonFiltrar' value='Filtrar resultados'>";
		$("#idFiltro").html(menuFiltro);

		$( "#idBotonFiltrar" ).click(function() {
			var filtro = $("#idOpcionesFiltro option:selected").text().replace(/([^a-z0-9]+)/gi, '');
			if(!filtro.includes("TODOS")){
				$('.'+filtro).show();
				var str = "";
			    $("#idOpcionesFiltro option:not(:selected)").each(function() {
			      str = $( this ).text().replace(/([^a-z0-9]+)/gi, '');
			      if(!str.includes(filtro)) $('.'+str).hide();
				  
			    });
			}
			else{
				$("#idOpcionesFiltro option:not(:selected)").each(function() {
			      str = $( this ).text().replace(/([^a-z0-9]+)/gi, '');
			      $('.'+str).show();
			    });
			} 
			
		});
		//console.log(matrizVideos);
}

//Función que asigna los eventos de la tabla desplegada
function asignarEventosTabla(){

	if(clickPagina) document.getElementById("tituloTabla").scrollIntoView();
	clickPagina = false;
	//Eventos enlaces eliminar
	var btnsEliminar = document.getElementsByClassName("eliminar");
	for(var i=0; i<btnsEliminar.length;i++){
		if(tipoTabla.indexOf("Historico")>-1)btnsEliminar[i].addEventListener('click', eliminarHistorico);
		if(tipoTabla.indexOf("Alarmas")>-1)btnsEliminar[i].addEventListener('click', eliminarAlarma);
	}
	//Evento enlace avanzar
	var avanza = document.querySelector("#avanza");
	if(avanza != null) avanza.addEventListener('click',avanzar);
	//Evento enlace retroceder
	var retrocede = document.querySelector("#retrocede");
	if(retrocede != null ) retrocede.addEventListener('click',retroceder);
	//Evento de numero de pagina
	var numeroPagina = document.getElementsByClassName("paginaActual");
	for(i=0;i<numeroPagina.length;i++){
		numeroPagina[i].addEventListener('click',paginaActual);
	}

	var consultarAlarmaTabla =	document.querySelector("#idEnviarConsultaAlarma");
	if(consultarAlarmaTabla != null) consultarAlarmaTabla.addEventListener('click',consultarAlarmas);

	var consultarAlarmaTabla =	document.querySelector("#idDescargarConsultaAlarma");
	if(consultarAlarmaTabla != null) consultarAlarmaTabla.addEventListener('click',descargarAlarmas);

	var mostrarGrafico = document.querySelector("#idMostrarGrafico");
	if(mostrarGrafico != null) mostrarGrafico.addEventListener('click',mostrarGraficoBarras);

	var detalleConteo = document.querySelector("#idEnviarConsultaHistorico");
	if(detalleConteo != null) detalleConteo.addEventListener('click',mostrarDetalleConteo);

	var btnDescargarConteoConteo = document.querySelector("#idDescargarConteos");
	if(btnDescargarConteoConteo != null) btnDescargarConteoConteo.addEventListener('click',descargarConteos);

	var btnDescargarHistoricos = document.querySelector("#idDescargarHistoricos");
	if(btnDescargarHistoricos != null) btnDescargarHistoricos.addEventListener('click',descargarHistoricos);

	precarga.innerHTML = null;
}

//Función que muestra el detalle del conteo
function mostrarDetalleConteo(evento){
	evento.preventDefault();
	if(evento != null) evento.preventDefault();
	borrarContenedores();
	document.getElementById("precarga").scrollIntoView();
	precarga.style.display = "block";
	precarga.innerHTML = "<img src='img/loader.gif' />";
	
	var fecha_inicial = $("#idFechaInicial").val();
	var hora_inicial = $("#idHoraInicial").val();
	var fecha_final = $("#idFechaFinal").val();
	var hora_final = $("#idHoraFinal").val();
	$.ajax({
	    url: "controlador.php",
	    type: 'POST',
	    data: {transaccion:"generarDetalleConteos", fechaInicial:fecha_inicial, horaInicial:hora_inicial, fechaFinal:fecha_final, horaFinal:hora_final},
	    datatype: "JSON",
	    success: function(data) {
	    	precarga.innerHTML = null;
	    	$("#htmlTabla").html(data);
		}
	});
}

//Función que muestra grafico de barras
function mostrarGraficoBarras(evento){
	
	evento.preventDefault();	
	// Cuadro para mostrar graficos
	var salida  =	"<div id='id01' class='modal'>";
  	salida += 			'<form class="modal-content animate" action="/action_page.php">';
	salida +=			'<div class="imgcontainer">';
	salida +=			  '<span id="idX" class="close" title="Cerrar ventana">&times;</span>'; 
	salida +=			'</div>';
	salida +=			'<div class="container">';
	salida +=			  '<div id="idMostrarGraficos"></div>';
	salida +=			'</div>';
	salida +=			'<div class="container" style="background-color:#f1f1f1">'
	salida +=			 '<button type="button" id="btnOkGrafico">OK</button>';
	salida +=			'</div>';
	salida +=			'</form>';
	salida +=		'</div>';

	jQuery("#graficos").html(salida);

	salida  = 	"<div style = 'display:inline-block;'>";
	salida += 			"<div class='chartH'>";
	salida +=				"<canvas id='chart'>";
	salida +=				"</canvas>";
	salida +=			"</div>";
	salida +=		"</div>";

	document.getElementById('id01').style.display='block';

	$("#idX").click(function() {
  		document.getElementById("id01").style.display="none";
	});
	$("#btnOkGrafico").click(function() {
  		document.getElementById("id01").style.display="none";
	});
	jQuery("#idMostrarGraficos").html(salida); 
	var ctx = document.getElementById("chart");


	var ejey=[], ejex=[], color=[];
	for(var i=0; i<8; i++){
		if(document.getElementById("idFecha_"+i) == null) break;
		ejey[i] = $("#idFecha_"+i).text();
		ejex[i] = $("#idTotalDia_"+i).text();
		if(i%2 == 0) color[i] = "#3e95cd";
		else color[i] = "#8e5ea2";
	} 
	//console.log(ejey);
	//console.log(ejex);
	var myBarChart = new Chart(ctx, {
	    type: 'horizontalBar',
	    data: {
	      labels: ejey,
	      datasets: [
	        {
	          label: "Conteo de personas",
	          backgroundColor: color,
	          data: ejex
	        }
	      ]
	    },
	    options: {
	      legend: { display: false },
	      title: {
	        display: true,
	        text: 'Número de personas contabilizadas',
	        FontFamily : 'Arial',
	        fontSize : 15
	      }
	    },
	   
	});
	$("#idMostrarGraficos").html(ctx);
}

// Función que asigna los eventos del HTML desplegado
function asignarEventosWifi(){
	precarga.innerHTML = null;
	precarga.style.display = "none";
	respuesta.style.display = "block";

	//Evento boton Escanear redes
	var btnScanWifi = document.querySelector('#scanWifi');
	btnScanWifi.addEventListener('click',scanWifi);
	//Evento boton Guardar configuración ip
	
	var btnGuardarConfiguracionIp = document.querySelector('#ipconfig-btn');
	btnGuardarConfiguracionIp.addEventListener('click',guardarConfigIp);
	//Evento cambio en la selección
	var cambioSeleccionIp = document.querySelector('#ip_config');
	cambioSeleccionIp.addEventListener('change',cambioConfigIp);
	if(cambioSeleccionIp.value == "DINAMICA"){
		jQuery("#idIpEstatica").hide();
	}else{
		jQuery("#idIpEstatica").show();
	}
	var btnsEliminar = document.getElementsByClassName("eliminar");
	for(var i=0; i<btnsEliminar.length;i++){
		btnsEliminar[i].addEventListener('click', eliminarRedWifi);
	}
	var btnsConectar = document.getElementsByClassName("conectar");
	for(var i=0; i<btnsConectar.length;i++){
		btnsConectar[i].addEventListener('click', conectarRedWifi);
	}
	var aplicarCambios = document.querySelector('#aplicarCambios-btn');
	aplicarCambios.addEventListener('click',aplicarCambiosWifi);
	if(cambios_wifi == true){
		aplicarCambios.style.backgroundColor = "red";
	}
	precarga.innerHTML = null;
}
//Función que asigna los eventos a la pagina de configuración
function asignarEventosConfiguracion(){
	//Asigna evento al boton reiniciar
	var btnReiniciarSistema = document.querySelector("#boton_reinicio");
	btnReiniciarSistema.addEventListener("click",reiniciarSistema);
	//Asigna evento al boton apagar
	var btnApagarSistema = document.querySelector("#boton_apagar");
	btnApagarSistema.addEventListener("click",apagarSistema);
	//Asigna evento al botón enviar
	document.querySelector("#insertar-btn").addEventListener("click",insertarConfiguracion);
	//Asigna evento al boton que inicia la aplicación en java
	var iniJava = document.querySelector("#StartaplicacionJava");
	if(iniJava != null)	iniJava.addEventListener("click",iniciarAplicacionJava);
	var stopJava = document.querySelector("#StopaplicacionJava");
	if(stopJava != null)	stopJava.addEventListener("click",stopAplicacionJava);
	document.querySelector("#borrarTablaAlarmas").addEventListener("click",borrarAlarmas);
	document.querySelector("#borrarTablaHistoricos").addEventListener("click",borrarHistoricos);
	precarga.innerHTML = null;
}


function borrarProgramacionAudiosFun(evento){
	evento.preventDefault();

	$.ajax({
	    url: "controlador.php",
	    type: 'POST',
	    data: {transaccion:"borrarProgramacionAudios"},
	    datatype: "JSON",
	    success: function(data) {
	    //console.log(data);
	    if((data.includes("OK")) == true) {
	     		alert("Cambios realizados con exito");
	        	aplicarCambiosAudiosFun(null);
	        	updateAudios();
	        }
	        else{ 
	        	alert("Error al aplicar los cambios de la programación de audios");	        	
	    	}
	   	}
	});
}

function borrarAlarmas(evento){
	evento.preventDefault();
	scroll(0,0);
	var datos = "transaccion=borrarAlarmas";
	ejecutarAJAX(datos);
}

function borrarAllLogs(evento){
	evento.preventDefault();
	$.ajax({
	    url: "controlador.php",
	    type: 'POST',
	    data: {transaccion:"borrarLogs"},
	    datatype: "JSON",
	    success: function(data) {
	     if((data.includes("OK")) == true) {
	        	//console.log("Se borraron los logs..");
	        	updateLogSistema();
	        }
	        else{ 
	        	alert("Error al borrar los logs");	        	
	    	}
	   	}
	});
}

function borrarHistoricos(evento){
	evento.preventDefault();
	scroll(0,0);
	var datos = "transaccion=borrarHistoricos";
	ejecutarAJAX(datos);
}

function borrarContenedores(){

	jQuery("#mapa").html(""); // Borra el mapa
	jQuery("#scanwifi").html(""); // Borra el resultado 
	jQuery("#sistema").html(""); // Borra el resultado 
	jQuery("#sensores").html(""); // Borra el resultado 
	jQuery("#graficos").html(""); // Borra el resultado
}

function borrarTimers(){
	clickContador = 0;
	if(timer != null){
            clearTimeout(timer);
            clearInterval(timer);
        }
	clickSistema = 0;
	if(timerSistema != null){
            clearTimeout(timerSistema);
            clearInterval(timerSistema);
        }
	clickGps = 0;
	if(timerGps != null){
            clearTimeout(timerGps);
            clearInterval(timerGps);
        }
}

//Función que avanza en la tabla
function avanzar(evento){
	evento.preventDefault();
	clickPagina = true;
	var idPagina = Number(evento.target.dataset.id_pagina) + 1;
	jQuery("#idResultadoTabla").load("vistas.php?func=mostrar"+tipoTabla+"&pageAct="+idPagina, asignarEventosTabla);
}
//Función que se ejecuta la detectar un cambio en la configuración IP
function cambioConfigIp(evento){
	var resultado = document.querySelector('#ip_config').value;
	if(resultado == "ESTATICA"){
		jQuery("#idIpEstatica").show();
	}else{
		jQuery("#idIpEstatica").hide();
	}
	//alert("Cambio en la configuración IP: "+resultado);
}

//Función que se ejecuta al dar click en Historicos
function cargarHistorico(evento){
	evento.preventDefault();
	fechaInicialAlarma ="0";
	fechaFinalAlarma ="0";
	functionMenu();
	borrarContenedores();
	borrarTimers();
	jQuery("#htmlTabla").html("");
	var form = '<div class="form-style-10">';
	form += '<h1>Consulta personalizada<span>Seleccione el rango de fechas!</span></h1>';
	form +="<form id='idFormHistorico'>";
	form += '<div class="inner-wrap">';
			form += "<label for='fecha'>Fecha inicial:  <input type='date' id='idFechaInicial' required /><input type='time' value='00:00' id='idHoraInicial'></label>";
			form += "<label for='fecha'>  Fecha final:  <input type='date' id='idFechaFinal' required /><input type='time' value='23:59' id='idHoraFinal'></label>";
				form += "<input type='submit' id='idEnviarConsultaHistorico' value='Consultar conteos' />";
				form += "<input type='submit' id='idDescargarConteos' value='Descargar conteos' />";
				form += "<input type='submit' id='idDescargarHistoricos' value='Descargar historicos' />";
		form += "</div>";
	form += "</form>";
	form += "</div>";
	form += "<div id='idResultadoTabla'></div>";
	jQuery("#htmlTabla").html(form);
	jQuery("#idResultadoTabla").html("<img src='img/loader.gif'/>");
	updateHistorico();
}

//Funcion que se ejecuta al dar clici en audios
function CargarAudios(evento){
	var resultado = "";
	evento.preventDefault();
	borrarTimers();
	functionMenu();
	borrarContenedores();
	jQuery("#htmlTabla").html("");
	
	//Formulario para subir archivos de audio
	resultado += '<div class="form-style-10">';
	resultado += '<h1>Cargar Audio<span>Seleccione y suba el archivo deseado!</span></h1>';
	resultado +="<form id='datosArchivoAudio' method='post' enctype='multipart/form-data'>";
		resultado += '<div class="inner-wrap">';
			resultado += '<input type="file" name="fileToUpload" id="fileToUploadAudio" style="width:250px">';
		    resultado += "<input type='submit' value='Subir Audio' name='submit' id='btnSubirAudio'>";
		    resultado += "<div id='resultadoSubirAudio'></div>";
		    resultado += "<input type='submit' value='Programar audios' name='submit' id='programarAudios'>";	
		    resultado += '</div>';    
	resultado += "</form>";
	resultado += '</div>';

	respuesta.innerHTML = resultado;

	document.querySelector("#programarAudios").addEventListener("click",programarAudios);
	/*
	$("#btnSubirAudio" ).click(function(event) {
		event.preventDefault();
	  	if($("#fileToUploadAudio").val().includes("mp3") || $("#fileToUploadAudio").val().includes("zip")){
		    var formData = new FormData(this);
		    console.log($("#fileToUploadAudio").val());
		    $.ajax({
		        url: "upload.php",
		        type: 'POST',
		        data: formData,
		        contentType: false,
	    		processData: false,
		        success: function (data) {
		        	console.log(data);
		            var partes = data.split(",");
		            resul = partes[0];
		            $("#resultadoSubirAudio").text(partes[0]);
		            
		        },
		    });
		}else{
			alert("El archivo no se puede subir...Seleccione otro.");
		}
	});

*/
	$("form#datosArchivoAudio").submit(function(e) {    
	    e.preventDefault(); 
	    $("#resultadoSubirAudio").html("<img src='img/loader.gif' />");
	    if($("#fileToUploadAudio").val().includes("mp3") || $("#fileToUploadAudio").val().includes("wav")){
		    var formData = new FormData(this);
		    //console.log($("#fileToUploadAudio").val());
		    $.ajax({
		        url: "upload.php",
		        type: 'POST',
		        data: formData,
		        contentType: false,
	    		processData: false,
		        success: function (data) {
		            var partes = data.split(",");
		            resul = partes[0];
		            $("#resultadoSubirAudio").text(partes[0]);
		            
		        },
		    });
		}else{
			alert("El archivo no se puede subir...Seleccione otro.");
		}
	});

}

//Funcion que se ejecuta al dar click en usuario
function CargarUsuario(evento){
	var resultado = "";
	evento.preventDefault();
	functionMenu();
	borrarContenedores();
	jQuery("#htmlTabla").html("");
	borrarTimers();
	//Formulario para actualizar el usuario cliente
	resultado += '<div class="form-style-10">';
	resultado +="<form id='datosUsuarioCliente'>";
	resultado += '<h1>Administración de usuario<span>Asigne el nombre y la clave del usuario!</span></h1>';
		resultado += '<div class="inner-wrap">';
			resultado += "<label for='idNombreUsuario'>Nombre de usuario: <input type='text' id='idNombreUsuario' name='NombreUsuario_tx' required /></label>";
		    resultado += "<label for='idClaveUsuario'>Clave del usuario: <input type='text' id='idClaveUsuario' name='ClaveUsuario_tx' required /></label>";
		    resultado += "<input type='submit' value='Actulizar usuario' name='submit' id='btnDatosUsuario'>";
		    resultado += "<div id='resultadoDatosUsuario'></div>";
	    resultado +="</div>";
	resultado += "</form>";
	resultado +="</div>";
	respuesta.innerHTML = resultado;

	precarga.style.display = "block";
	precarga.innerHTML = "<img src='img/loader.gif' />";
	$.ajax({
        url: "controlador.php",
        type: 'POST',
	    data: {transaccion:"datosUsuario"},
	    datatype: "JSON",
	    success: function(data) {
	    	precarga.innerHTML =null;
	     	if(data.includes("OK")){
	     		var partes = data.split(",");
	     		partes[1] = partes[1].replace(/[|&;$%@"<>()+,]/g, "");
	     		console.log(partes[1]);
	     		$("#idNombreUsuario").val(partes[1]);
	     		$("#idClaveUsuario").val(partes[2]);
	     	} 
	     	else alert("Lo siento hay un error con la base de datos");
	   	}
	});

	$("form#datosUsuarioCliente").submit(function(e) {    
	    e.preventDefault();    
	    
		$.ajax({
		    url: "controlador.php",
		    type: 'POST',
		    data: {transaccion:"editarDatosUsuario",usuario:$("#idNombreUsuario").val(), clave:$("#idClaveUsuario").val()},
		    datatype: "JSON",
		    success: function(data) {
		     	if(data.includes("OK")){
		     		$("#resultadoDatosUsuario").text("Cambio realizado con exito");
		     	} 
		     	else $("#resultadoDatosUsuario").text("Error en el proceso");
		   	}
		});
			
	});
}

//Función que se ejecuta al dar click en herramientas
function CargarHerramientas(evento){
	evento.preventDefault();
	functionMenu();
	borrarContenedores();
	jQuery("#htmlTabla").html("");
	borrarTimers();
	var resultado = "";

	//Formulario para editar los permisos del cliente
	//Para agregar mas permisos hay que insertar los nuevos debajo de la ultima input
	resultado += '<div class="form-style-10">';
	resultado += '<h1>Permisos del usuario<span>Administración de los permisos del usuario!</span></h1>';
	resultado +="<form id='idPermisosUsuario'>";
		resultado +='<div class="inner-wrap">';
				resultado +="<label for='idPermisoValidaciones'>Validaciones <input type='checkbox' id='idPermisoValidaciones' name='Validaciones'></label>";
				resultado +="<label for='idPermisoGps'>GPS <input type='checkbox' id='idPermisoGps' name='Gps'></label>";
				resultado +="<label for='idPermisoWifi'>Wifi <input type='checkbox' id='idPermisoWifi' name='Wifi'></label>";
				resultado +="<label for='idPermisoConfiguracion'>Configuración <input type='checkbox' id='idPermisoConfiguracion' name='Configuracion'></label>";
				resultado +="<label for='idPermisoInfo'>Info <input type='checkbox' id='idPermisoInfo' name='Info'></label>";
				resultado +="<label for='idPermisoLog'>Logs <input type='checkbox' id='idPermisoLog' name='Log'></label>";
				resultado +="<label for='idPermisoHerramientas'>Herramientas <input type='checkbox' id='idPermisoHerramientas' name='Herramientas'></label>";
                                resultado +="<label for='idPermisoVideos'>Videos <input type='checkbox' id='idPermisoVideos' name='Videos'></label>";
                        resultado +='<input type="submit" value="Aplicar" id="btnEditarPermisosUsuario">';	
			resultado +="<div id='resultadoPermisosUsuario'></div>";
		resultado +="</div>";
	resultado +="</form>";
	resultado +="</div>";
	
	
	//Formulario para generar tramas para regisdata
	resultado += '<div class="form-style-10">';
	resultado += '<h1>Generación de tramas<span>Ingrese las fechas!</span></h1>';
	resultado +="<form id='idPermisosUsuario'>";
		resultado +='<div class="inner-wrap">';
			resultado +="<label for='fecha_inicial'>Fecha inicial: <input type='date' id='fecha_inicial'><input type='time' value='00:00:00' id='hora_inicial'></label>";	
			resultado +="<label for='fecha_final'>Fecha final: <input type='date' id='fecha_final'><input type='time' value='23:59:00' id='hora_final'></label>";
			resultado +='<input type="submit" value="Generar" id="btnGenerarTrama">';	
		resultado +="</div>";
	resultado +="</form>";
	resultado +="</div>";
	resultado +="<div id='tablaLogGps'></div>";

	//Formulario para actualizar la aplicación Java
	resultado +="<form id='datosArchivo' class='formulario' enctype='multipart/form-data'>";
		resultado +="<fieldset>";
		resultado +="<legend>Actualizar apliación JAVA</legend>";
		    resultado += "<input type='file' name='fileToUpload' id='fileToUpload'>";
		    resultado += "<input type='submit' value='Actulizar Java' name='submit' id='btnSubirJar'>";
		    resultado += "<div id='resultadoSubirJar'></div>";
	    resultado +="</fieldset>";
	resultado += "</form>";
   
	//Formulario para actualizar frontend de la pagina
	resultado +="<form id='datosArchivoFE' class='formulario' enctype='multipart/form-data'>";
		resultado +="<fieldset>";
		resultado +="<legend>Actualizar FrontEnd</legend>";
		    resultado += "<input type='file' name='fileToUpload' id='fileToUploadFE'>";
		    resultado += "<input type='submit' value='Actulizar FE' name='submit' id='btnSubirFE'>";
		    resultado += "<div id='resultadoSubirFE'></div>";
	    resultado +="</fieldset>";


	    //Otras operaciones
	    resultado +="<br><br>";
		resultado +="<fieldset  class='formulario'>";
			resultado +="<legend>Otras operaciones</legend>";
			resultado += '<button type="button" id="editarContadores">Editar contadores</button>';
			resultado += '<button type="button" id="verCambios">Ver cambios JAVA</button>';
			resultado += '<button type="button" id="verCambiosFE">Ver cambios FrontEnd</button>';
			resultado += '<button type="button" id="idReinicioFabrica">Restablecer contador</button>';
			resultado += '<button type="button" id="idGrabarRecorrido">Grabar Recorrido</button>';
			resultado += '<button type="button" id="idEjecutarSimulacion">Simulación</button>';
			if(v_recuperacion > -1) resultado += '<button type="button" id="idEjecutarRecuperacion">Recuperar BD de MMC</button>';
		resultado +="</fieldset>";

	resultado += "</form>";
	
	respuesta.innerHTML = resultado;
	
	document.querySelector("#btnGenerarTrama").addEventListener("click",GenerarTrama);
	
	document.querySelector("#verCambios").addEventListener("click",verCambios);

	document.querySelector("#verCambiosFE").addEventListener("click",verCambiosFE);

	document.querySelector("#editarContadores").addEventListener("click",editarContadoresFun);

	document.querySelector("#idGrabarRecorrido").addEventListener("click",grabarRecorrido);

	document.querySelector("#idEjecutarSimulacion").addEventListener("click",ejecutarSimulacion);
	
	if(v_recuperacion > -1) document.querySelector("#idEjecutarRecuperacion").addEventListener("click",ejecutarRecuperacion);

	precarga.style.display = "block";
	precarga.innerHTML = "<img src='img/loader.gif' />";
	$.ajax({
        url: "controlador.php",
        type: 'POST',
	    data: {transaccion:"permisosUsuario"},
	    datatype: "JSON",
	    success: function(data) {
	    	precarga.innerHTML = null;
                //console.log(data);
	     	if(data.includes("OK")){
	     		var partes = data.split(",");
	     		partes[1] = partes[1].replace(/[|&;$%@"<>()+,]/g, "");
	     		//console.log(partes[1]);
	     		if((partes[1]&1) == 1) $("#idPermisoValidaciones").prop('checked', true);
	     		if((partes[1]&2) == 2) $("#idPermisoGps").prop('checked', true);
	     		if((partes[1]&4) == 4) $("#idPermisoWifi").prop('checked', true);
	     		if((partes[1]&8) == 8) $("#idPermisoConfiguracion").prop('checked', true);
	     		if((partes[1]&16) == 16) $("#idPermisoInfo").prop('checked', true);
	     		if((partes[1]&32) == 32) $("#idPermisoLog").prop('checked', true);
	     		if((partes[1]&64) == 64) $("#idPermisoHerramientas").prop('checked', true);
                        if((partes[1]&128) == 128) $("#idPermisoVideos").prop('checked', true);
	     	}       
	     	else $("#resultadoPermisosUsuario").text(data);
	   	}
	});
        
    $.ajax({
        url: "controlador.php",
        type: 'POST',
	    data: {transaccion:"firmwareJava"},
	    success: function(data) {
	    	precarga.innerHTML = null;
            console.log(data);
	     	if(data.includes("OK")){
	     		var partes = data.split(",");
	     		partes[1] = partes[1].replace(/[|&;$%@"<>()+,]/g, "");
	     		firmwareJava = partes[1];
	     	}       
	     	else $("#resultadoSubirJar").text("ERROR, No se puede consultar la base de datos:Configuración");
	   	}
	});

	$("form#idPermisosUsuario").submit(function(e) {
	    e.preventDefault(); 
	    $("#resultadoPermisosUsuario").text("");
	    var valor_permisos = 0;
	    if($("#idPermisoValidaciones").is(':checked')) valor_permisos |= 1;
	    if($("#idPermisoGps").is(':checked')) valor_permisos |= 2; 
	    if($("#idPermisoWifi").is(':checked')) valor_permisos |= 4; 
	    if($("#idPermisoConfiguracion").is(':checked')) valor_permisos |= 8;
	    if($("#idPermisoInfo").is(':checked')) valor_permisos |= 16; 
	    if($("#idPermisoLog").is(':checked')) valor_permisos |= 32;
	    if($("#idPermisoHerramientas").is(':checked')) valor_permisos |= 64;
	    if($("#idPermisoVideos").is(':checked')) valor_permisos |= 128;
	    $.ajax({
	        url: "controlador.php",
	        type: 'POST',
                data: {transaccion:"editarPermisosUsuario", permisos:valor_permisos},
                datatype: "JSON",
                success: function(data) {
                    if(data.includes("OK")){
                            $("#resultadoPermisosUsuario").text("Proceso realizado con exito");
                            /*
                            setTimeout(function(){
                                    window.location.reload(1);
                                    }, 5000);*/
                    } 
                    else $("#resultadoPermisosUsuario").text("Hubo un error con el proceso");
                    }
		}); 
            });
	
	$("form#datosArchivo").submit(function(e) {
	    e.preventDefault(); 
	    // Get your file input (by it's id)
        $("#resultadoSubirJar").html("<img src='img/loader.gif' />");
        var fileInput = document.getElementById('fileToUpload');
        // Use a regular expression to pull the file name only
        console.log(fileInput);
        var fileName = fileInput.value.split(/(\\|\/)/g).pop();
	    console.log(fileName);
	    console.log(firmware.substring(0,2));  
	    if($("#fileToUpload").val().includes(firmwareJava.substring(0,2))){
		    var formData = new FormData(this);
		    $.ajax({
		        url: "upload.php",
		        type: 'POST',
		        data: formData,
		        contentType: false,
	    		processData: false,
		        success: function (data) {
		            var partes = data.split(",");
		            resul = partes[0];
		            $("#resultadoSubirJar").text(partes[0]);
		            if(partes[0].includes("El archivo ha sido cargado")){
		            	descomprimirZip(partes[1]);
		            }
		        },
		    });
	    }else{
			alert("El archivo no se puede subir...Seleccione otro.");
		}
	});

	$("form#datosArchivoFE").submit(function(e) {
	    e.preventDefault(); 
	    $("#resultadoSubirFE").html("<img src='img/loader.gif' />");   
	    if($("#fileToUploadFE").val().includes("html.zip")){
		    var formData = new FormData(this);
		    $.ajax({
		        url: "upload.php",
		        type: 'POST',
		        data: formData,
		        contentType: false,
	    		processData: false,
		        success: function (data) {
		            var partes = data.split(",");
		            resul = partes[0];
		            $("#resultadoSubirFE").text(partes[0]);
		            if(partes[0].includes("El archivo ha sido cargado")){
		            	descomprimirZip(partes[1]);
		            }
		        },
		    });
		}else{
			alert("El archivo no se puede subir...Seleccione otro.");
		}
	});

	$( "#idReinicioFabrica" ).click(function() {
	  var confirmacion = confirm("Esta seguro de reiniciar a valores de fabrica?");
		if(confirmacion){
			$.ajax({
		        url: "controlador.php",
		        type: 'POST',
			    data: {transaccion:"reiniciarFabrica"},
			    
			    success: function(data) {
			    	precarga.innerHTML = null;
			     	if(data.includes("OK")){
			     		console.log(data);
			     	} 
			   	}
			});
		}
	});
}

//Función que se ejecuta al dar click en Logs del Sistema
function CargarLogSistema(evento){
	evento.preventDefault();
	functionMenu();
	updateLogSistema();
}

//Funcion que se ejecuta al dar click en videos
function CargarVideos(evento){
	evento.preventDefault();
	functionMenu();
	updateVideos();
}

//Función que se ejecuta al dar click en Validaciones
function CargarValidaciones(evento){
	evento.preventDefault();
	functionMenu();
	updateValidaciones();
}

//Función que se ejecuta al dar click en Alarmas
function cargarAlarmas(evento){
	evento.preventDefault();
	fechaInicialAlarma ="0";
	fechaFinalAlarma ="0";
	functionMenu();
	borrarContenedores();
	borrarTimers();
	jQuery("#htmlTabla").html("");
	var form = '<div class="form-style-10">';
	form += '<h1>Consulta personalizada<span>Seleccione y rango de fechas!</span></h1>';
	form +="<form id='idFormAlarma'>";
		form += "<div class='inner-wrap'>";
			form += "<label for='fecha'>Fecha inicial:  <input type='date' id='idFechaInicial' required /></label>";
			form += "<label for='fecha'>  Fecha final:  <input type='date' id='idFechaFinal' required /></label>";	
			form += "<div>";
				form += "<label for='fecha'>Tipo de alarma: </label>";
				form += "<select name='alarmas_tx' type='text' id='idTipoAlarma' >";
					form += "<option value='0' selected >Todas</option>";
					form += "<option value='12'>Reset de sistema</option>";
					form += "<option value='13'>Reinicio preventivo</option>";
					form += "<option value='5'>Sensor bloqueado BQ1</option>";
					form += "<option value='6'>Sensor bloqueado BQ2</option>";
					form += "<option value='8'>Sistema antiagache</option>";
					form += "<option value='9'>Sistema antisalto</option>";
					form += "<option value='3'>Sensor obstruido</option>";
					form += "<option value='1'>Corto circuito</option>";
					form += "<option value='2'>Fuente ppal desconectada</option>";
					form += "<option value='17'>GPS</option>";
					form += "<option value='18'>Sistema hibernando</option>";
					form += "<option value='19'>Fuente ppal conectada</option>";
					form += "<option value='50'>Error en I2C</option>";
					form += "<option value='51'>Reinicio de aplicación</option>";
					form += "<option value='52'>Error en puerto serial</option>";
					form += "<option value='53'>Configuración WIFI recuperada</option>";
					form += "<option value='54'>Error en WIFI</option>";
					form += "<option value='10'>Escritura de datos</option>";
				form += "</select>";
			form += "</div>";
			form += "<input type='submit' id='idEnviarConsultaAlarma' ' value='Consultar' />";
			form += "<input type='submit' id='idDescargarConsultaAlarma' ' value='Descargar' />";
		form += "</div>";
	form += "</form>";
	form += '</div>';
	form += '<div id="idResultadoTabla"></div>';
	jQuery("#htmlTabla").html(form);
	jQuery("#idResultadoTabla").html("<img src='img/loader.gif'/>");
	updateAlarmas();
}
//Función que se ejecuta al dar click en GPS
function cargarGps(evento){
	evento.preventDefault();
	functionMenu();
	borrarTimers();
	borrarContenedores();
	jQuery("#htmlTabla").html("");
	precarga.innerHTML = "<img src='img/loader.gif' />";
	updateGps();
	if(clickGps == 0) timerGps = setInterval("updateGps()", 3000);
	clickGps++;
}

function cargarContadores(evento){
	if(evento != null){
            evento.preventDefault();
            functionMenu();
        }
	precarga.innerHTML = "<img src='img/loader.gif' />";
	
	borrarTimers();
	borrarContenedores();
	updateContadores();
	if(clickContador == 0) timer = setInterval("updateContadores()", 1000);
	clickContador++;
}

function cargarSistema(){
	updateSistema();
	if(clickSistema == 0) timerSistema = setInterval("updateSistema()", 1000);
	clickSistema++;
}

function cargarWifi(evento){
	evento.preventDefault();
	functionMenu();
	borrarContenedores();
	borrarTimers();
	jQuery("#htmlTabla").html("");
	updateWifi();
}

function cargarConfiguracion(evento){
	evento.preventDefault();
	functionMenu();
	borrarTimers();
	borrarContenedores();
	jQuery("#htmlTabla").html("<img src='img/loader.gif' />");
        console.log(firmware);
	jQuery("#htmlTabla").load("vistas.php?func=mostrarConfiguracion&firmware="+firmware,asignarEventosConfiguracion);
}

function CargarInfoSistema(evento){
	evento.preventDefault();
	functionMenu();
	borrarContenedores();
	borrarTimers();
	jQuery("#htmlTabla").html("");
	var datos = "transaccion=infoSistema&firmware="+firmware;
	ejecutarAJAX(datos);
}

//Conectar a la red wifi seleccionada
function conectarRedWifi(evento){
	evento.preventDefault();
	//alert(evento.target.dataset.id_historico);
	var idRedWifi = evento.target.dataset.id_wifi;
	var confirmacion = confirm("Esta seguro de conectar a esta red wifi?");
	if(confirmacion){
		var datos = "idRedWifi="+idRedWifi+"&transaccion=conectarRedWifi";
		console.log(datos);
		ejecutarAJAX(datos);
	}
	updateWifi();
}

//Funcion que hace consulta de las alarmas en un rango de fechas
function consultarAlarmas(evento){
	evento.preventDefault();
	fechaInicialAlarma = $("#idFechaInicial").val();
	fechaFinalAlarma = $("#idFechaFinal").val();
	tipoAlarma = $("#idTipoAlarma").val();
	updateAlarmas();
}

//Crea el formulario para ingresar redes wifi
function CrearFormularioNuevaRed(){
	var resultado = document.querySelector("#networkbox");
	//console.log(resultado);
	var Networks = resultado.dataset.valor;
	//console.log("valor "+Networks);
	resultado.innerHTML += '<br><br><div id="networkbox'+Networks+'" class="NetworkBoxes">Red wifi '+Networks;
		resultado.innerHTML +='SSID:<br>';
		resultado.innerHTML += '<input type="text" id="ssid0" name="ssid'+Networks+'"  />';
		resultado.innerHTML += '<br>';
		resultado.innerHTML += 'Clave:<br>';
		resultado.innerHTML += '<input type="text" id="psk0" name="psk'+Networks+'" />';
	resultado.innerHTML +='</div>';
	resultado.innerHTML += '<br>';
	//resultado.innerHTML += '<input type="button" value="Borrar" onClick="DeleteNetwork('+Networks+')" />';
	Networks++;
	$('#networkbox').attr('data-valor',Networks);
}
//Borra la red wifi seleccionada
function DeleteNetwork(network) {
	if(so_board.indexOf("sun8i") > -1){ // Codigo para Orange Pi
		scroll(0,0);
		var c = document.getElementsByName('ssid'+network);
		var red = $("input[name='ssid"+network+"']").val();
		//console.log( $("input[name='ssid"+network+"']").val());
		var datos = "transaccion=borrarRedWifi&red="+red;
		ejecutarAJAX(datos);
		return;
	}else{
		element = document.getElementById('networkbox'+network);
		element.parentNode.removeChild(element);
	    var Networks = document.querySelector('#Networks').value;
		console.log("Networks a borrar:"+Networks)
		Networks--;
		document.querySelector('#networkbox').dataset.valor = Networks;
		document.querySelector('#Save').click();
	}
}

function decimalToHex(d, padding) {
    var hex = Number(d).toString(16);
    padding = typeof (padding) === "undefined" || padding === null ? padding = 2 : padding;

    while (hex.length < padding) {
        hex = "0" + hex;
    }

    return hex;
}
//Función para descargar el detalle del conteo
function descargarConteos(evento){
	evento.preventDefault();
	if(evento != null) evento.preventDefault();
	borrarContenedores();
	document.getElementById("precarga").scrollIntoView();
	precarga.style.display = "block";
	precarga.innerHTML = "<img src='img/loader.gif' />";
	
	var fecha_inicial = $("#idFechaInicial").val();
	var hora_inicial = $("#idHoraInicial").val();
	var fecha_final = $("#idFechaFinal").val();
	var hora_final = $("#idHoraFinal").val();
	$.ajax({
	    url: "controlador.php",
	    type: 'POST',
	    data: {transaccion:"descargarConteos", fechaInicial:fecha_inicial, horaInicial:hora_inicial, fechaFinal:fecha_final, horaFinal:hora_final},
	    datatype: "JSON",
	    success: function(data) {
	    	precarga.innerHTML = null;
	     	var res = document.getElementById("respuesta");
	     	res.innerHTML = data;
	     	$("#respuesta").hide();
	     	//console.log(data);
	   	}
	});
}
//Función que descarga los historicos
function descargarHistoricos(evento){
	evento.preventDefault();
	if(evento != null) evento.preventDefault();
	borrarContenedores();
	document.getElementById("precarga").scrollIntoView();
	precarga.style.display = "block";
	precarga.innerHTML = "<img src='img/loader.gif' />";
	
	var fecha_inicial = $("#idFechaInicial").val();
	var hora_inicial = $("#idHoraInicial").val();
	var fecha_final = $("#idFechaFinal").val();
	var hora_final = $("#idHoraFinal").val();
	$.ajax({
	    url: "controlador.php",
	    type: 'POST',
	    data: {transaccion:"descargarHistoricos", fechaInicial:fecha_inicial, fechaFinal:fecha_final},
	    datatype: "JSON",
	    success: function(data) {
	    	precarga.innerHTML = null;
	     	var res = document.getElementById("respuesta");
	     	res.innerHTML = data;
	     	$("#respuesta").hide();
	     	//console.log(data);
	   	}
	});
}
//Función que ordena decomprimir un archivo subido al servidor
function descomprimirZip(ruta){
	$.ajax({
	    url: "upload.php",
	    type: 'POST',
	    data: {transaccion:"descomprimirZip", ruta:ruta, firmware:firmware},
	    datatype: "JSON",
	    success: function(data) {
	    	precarga.innerHTML = null;
	     	if(data.includes("FE exitoso")){
	     		$("#resultadoSubirFE").text(data);
	     		setTimeout(function(){
	     			window.location.reload(1);
				}, 5000);
	     	} 
                if(data.includes("exitoso")){
                    var confirmacion = confirm("Es necesario reiniciar el sistema.");
                    if(confirmacion){
                        var datos = "transaccion=reiniciar";
                        reinicio = 1;
                        ejecutarAJAX(datos);
                    }
                }
	     	else $("#resultadoSubirJar").text(data);
	   	}
	});
}

//Función que descarga las alarmas a un archivo
function descargarAlarmas(evento){
	evento.preventDefault();
	fechaInicialAlarma = $("#idFechaInicial").val();
	fechaFinalAlarma = $("#idFechaFinal").val();
	tipoAlarma = $("#idTipoAlarma").val();
	precarga.innerHTML = "<img src='img/loader.gif' />";
	$.ajax({
	    url: "controlador.php",
	    type: 'POST',
	    data: {transaccion:"descargarAlarmas", fechaInicial:fechaInicialAlarma, fechaFinal:fechaFinalAlarma, tipo:tipoAlarma},
	    datatype: "JSON",
	    success: function(data) {
	    	precarga.innerHTML = null;
	     	var res = document.getElementById("respuesta");
	     	res.innerHTML = data;
	     	$("#respuesta").hide();
	     	console.log(data);
	     	
	   	}
	});
}
//Función que edita la programación del audio
function editarAudio(evento){
	evento.preventDefault();
	var idAudio = evento.target.dataset.id_mensajesaudio;
	//console.log("#audio_"+idAudio);
	//alert($("#fechaInicial_"+idAudio).text());
	//Formulario para la configuración de la red wifi		
	var output = '<form id="audio_config_form">';
	output +=  '<fieldset class="infoheader">';
	output +=  '<legend>Editar programación de audio</legend>';
		output +=  '<div class="audio" id="audioConfigBox" align="left">';
		
		output +=  '<div id="lbAudio" >Audio:</div>';
		output +=  '<input type="text" id="audio" name="audio_tx" value="'+$("#audio_"+idAudio).text()+'"/>';
		
		output +=  "<div>";
		output +=  "<label>Intervalo(min):</label>";
		output +=  "<select name='intervalo_tx' type='text' id='intervalo' >";
			for(var j=1; j<=120; j++){
				if($("#intervalo_"+idAudio).text() === ""+j){
					output +=  "<option value='"+j+"' selected >"+j+"</option>";
				}else output +=  "<option value='"+j+"'>"+j+"</option>";
			}
		output +=  "</select>";
		output +=  '</div>';

		output +=  '<div id="lbFechaInicial" >Fecha inicial:</div>';
		output +=  '<input type="date" id="fechaInicial" name="fechaInicial_tx" value="'+$("#fechaInicial_"+idAudio).text()+'"/>';
		
		output +=  '<div id="lbFechaFinal" >Fecha final:</div>';
		output +=  '<input type="date" id="fechaFinal" name="fechaFinal_tx" value="'+$("#fechaFinal_"+idAudio).text()+'"/>';


		output +=  "<div>";
		output +=  "<label>Volumen(%):</label>";
		output +=  "<select name='volumen_tx' type='text' id='volumen' >";
			
			for(j=0; j<=100; j+=25){
				if($("#volumen_"+idAudio).text() === ""+j){
					output +=  "<option value='"+j+"' selected >"+j+"</option>";
				}else output +=  "<option value='"+j+"'>"+j+"</option>";
			}
		output +=  "</select>";
		output +=  '</div>';

		output +=  "<input type='submit' id='audioconfig-btn' name='audioconfig_btn' value='Guardar configuración'/>";
		output +=  '</div>';
		output +=  '</fieldset>';

	output +=  '</form>';
	$("#tablaProgramacionAudio").html(output);
	document.getElementById("audio_config_form").scrollIntoView();
	$("form#audio_config_form").submit(function(e) {    
	    e.preventDefault(); 
	    //alert($("#audio").val()+","+$("#intervalo").val()+","+$("#fechaInicial").val()+","+$("#fechaFinal").val()+","+$("#volumen").val());
	   	$.ajax({
		    url: "controlador.php",
		    type: 'POST',
		    data: {transaccion:"guardarAudio", audio:$("#audio").val(), intervalo:$("#intervalo").val(), fechaInicial:$("#fechaInicial").val(), fechaFinal:$("#fechaFinal").val(), volumen:$("#volumen").val()},
		    datatype: "JSON",
		    success: function(data) {
		     	graficos.innerHTML = data;
		     	setTimeout(function(){
	     			updateAudios();
				}, 2000);
		   	}
		});
	});	
}

//Función que da la opción de escuhar el audio
function escucharAudio(evento){
    evento.preventDefault();
    var idAudio = evento.target.dataset.id_mensajesaudio;
    console.log($("#audio_"+idAudio).text());
    
    console.log($("#volumen_"+idAudio).text());

    $.ajax({
        url: "controlador.php",
        type: 'POST',
        data: {transaccion:"escucharAudio", audio:$("#audio_"+idAudio).text(), volumen:$("#volumen_"+idAudio).text()},

        success: function(data) {
            console.log(data);
        }
    });
        
}

function editarContadoresFun(evento){
	evento.preventDefault();
	jQuery("#htmlTabla").load("vistas.php?func=editarContadores", asignarEventosContadores);
}

function editarContadoresForm(evento){
	evento.preventDefault();

	precarga.style.display = "block";
	precarga.innerHTML = "<img src='img/loader.gif' />";
	$.ajax({
		    url: "controlador.php",
		    type: 'POST',
		    data: {transaccion:"editarContadoresExe", numeracion:$("#idnumeracion").val(), totalDia:$("#idtotaldia").val(), entradas:$("#identradas").val(), salidas:$("#idsalidas").val()},
		    datatype: "JSON",
		    success: function(data) {
		    	precarga.innerHTML = null;
		     	graficos.innerHTML = data;
		     	setTimeout(function(){
	     			cargarContadores(null);
				}, 2000);
		   	}
		});
}

function ejecutarAJAX(datos){
	ajax = objetoAJAX();
	ajax.onreadystatechange=enviarDatos; //Detecta los cambios de estado, existen varios
	ajax.open("POST","controlador.php");
	ajax.setRequestHeader("Content-Type","application/x-www-form-urlencoded");
	ajax.send(datos);
}

//Función que da la orden de ejecutar la simulacion del GPS
function ejecutarSimulacion(evento){
	evento.preventDefault();
	//alert("grabarRecorrido");
	$.ajax({
	    url: "controlador.php",
	    type: 'POST',
	    data: {transaccion:"ejecutarSimulacion"},
	    success: function(data){
	    	//console.log(data);
	    	alert("Comando aceptado");
	   	},
	   	error: function(data){
	    	console.log(data);
	   	},
	});
} 

//Función que da la orden de ejecutar la recuperación de la BD de la MMC
function ejecutarRecuperacion(evento){
	evento.preventDefault();
	precarga.innerHTML = "<img src='img/loader.gif' />";
	borrarContenedores();
	respuesta.innerHTML = null;  
	$.ajax({
	    url: "controlador.php",
	    type: 'POST',
	    data: {transaccion:"ejecutarRecuperacion"},
	    success: function(data){
			precarga.innerHTML = null;
	    	console.log(data);
	    	$("#htmlTabla").html(data);
	   	},
	   	error: function(data){
	    	console.log(data);
	   	},
	});
} 

function enviarDatos(){
	precarga.style.display = "block";
	precarga.innerHTML = "<img src='img/loader.gif' />";
	console.log(ajax.responseText);
	if(ajax.readyState == READY_STATE_COMPLETE){
		if(ajax.status == STATUS_OK){ // Respuesta para peticiones correctas
			precarga.innerHTML = null;
			precarga.style.display = "none";
			respuesta.style.display = "block";
			
			if(ajax.responseText.indexOf("coordenadas") >-1){
				var indice = ajax.responseText.indexOf("coordenadas")+11;
				respuesta.innerHTML = ajax.responseText.substring(0,ajax.responseText.indexOf("coordenadas"));
				var indice2 = ajax.responseText.indexOf(",",(indice+1))
				latitud = ajax.responseText.substring((indice+1),indice2);
				longitud = ajax.responseText.substring(indice2+1);
				console.log("latitud:"+latitud);
				console.log("longitud:"+longitud);
				//<iframe src='https://www.google.com/maps/embed?pb=!1m14!1m12!1m3!1d5632.337169461522!2d"+longitud+"!3d"+latitud+"!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!5e0!3m2!1ses!2ses!4v1505251965090' width='400' height='300' frameborder='0' style='border:0' allowfullscreen></iframe>
				//respuesta.innerHTML += "<iframe src='https://www.google.com/maps/embed?pb=!1m14!1m12!1m3!1d5632.337169461522!2d"+longitud+"!3d"+latitud+"!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!5e0!3m2!1ses!2ses!4v1505251965090' width='400' height='300' frameborder='0' style='border:0' allowfullscreen></iframe>";
				//initMap();
			}//else respuesta.innerHTML = ajax.responseText;
			if(ajax.responseText.indexOf("hardware:")>-1){
				var res = ajax.responseText.split(":");
				console.log(res);
				so_board = res[1];
				if(res[1].indexOf("BCM2709")>-1){
					retardoReinicio = 200;
					retardoAplicacion = 100;
				}else if(res[1].indexOf("sun8i")>-1){
					if(res[3].indexOf("120")>-1){
						retardoReinicio = 950;
						retardoAplicacion = 100;
					}else{
						retardoReinicio = 800;
						retardoAplicacion = 100;
					}

				}
				console.log("retardoReinicio="+retardoReinicio);
			}
			//respuesta.innerHTML = "<iframe src='https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d5632.473827152388!2d-76.5185887884414!3d3.4084923080218825!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x8e30a6f0cc4bb3f1%3A0x1f0fb5e952ae6168!2sCali%2C+Valle+del+Cauca%2C+Colombia!5e0!3m2!1ses!2ses!4v1505244421413' width='400' height='300' frameborder='0' style='border:0' allowfullscreen></iframe>";
			if(ajax.responseText.indexOf("data-insertar")>-1){
				document.querySelector("#alta-historico").addEventListener("submit",insertarHistorico);
			}
			
			//Respuesta positiva al comando de gardar red wifi
			if(ajax.responseText.indexOf("WIFI-OK") >-1){
				alert("Modificación exitosa");
				updateWifi();
			}
			if(ajax.responseText.indexOf("WIFI-ERROR") >-1){
				alert("Hubo un problema al tratar de modificar los parámetros de red");
				updateWifi();
			}
			if(ajax.responseText.indexOf("OK-REINICIO")>-1){
				mostrarBarraReinicio(retardoReinicio,"Reinicio en progreso...");
			}
			if(ajax.responseText.indexOf("EjecutandoJAVA")>-1){
				mostrarBarraReinicio(retardoAplicacion,"Iniciando aplicación JAVA...");
			}
			if(ajax.responseText.indexOf("detenerJAVA")>-1){
				mostrarBarraReinicio(20,"Deteniendo aplicación JAVA...");
			}
			if(ajax.responseText.indexOf("result_config")>-1 && ajax.responseText.indexOf("No se insertó")==-1){
				mostrarBarraReinicio(70,"Insertando datos en BD...");
			}else if(ajax.responseText.indexOf("No se insertó")>-1){
				alert("Hubo un problema al tratar de modificar los parámetros de configuración");
			}
			if(ajax.responseText.indexOf("Se eliminó la tabla correctamente")>-1){
				mostrarBarraReinicio(50,"Borrando datos en BD...");
			}else if(ajax.responseText.indexOf("Ocurrio un error. No se eliminó la tabla")>-1){
				alert("Hubo un problema al tratar de borrar la tabla");
			}
			if(ajax.responseText.indexOf("CONFIGIP-OK") >-1){
				alert("Modificación exitosa");
				updateWifi();
			}
			if(ajax.responseText.indexOf("CONFIGIP-ERROR") >-1){
				alert("Hubo un problema al tratar de modificar los parámetros de red");
				updateWifi();
			}
			if(ajax.responseText.indexOf("borrarRedWifi-OK") >-1){
				if(ajax.responseText.indexOf("successfully deleted") >-1) alert("Modificación exitosa");
				else alert("Hubo un problema al tratar de modificar los parámetros de red");
				updateWifi();
			}
			if(ajax.responseText.indexOf("Uso disco") >-1){
				//borrarContenedores();
				respuesta.innerHTML = "";
				var	salida  = "<div style = 'display:inline-block;'><div class='chart'><canvas id='chart'></canvas></div>";
					salida += "<div class='chart'><canvas id='chart1'></canvas></div>";
					salida += "<div class='chart'><canvas id='chart2'></canvas></div>";
					salida += "<div class='chart'><canvas id='chart3'></canvas></div></div>";
				
				var out = document.querySelector("#graficos");
				out.innerHTML = salida; 
				var result = ajax.responseText.replace(/G/g,"");
				result = result.replace(/ /g,"");
				//alert("Trama a procesar: "+result);
				//indice = result.indexOf(",");
				//tmp = result.substring(result.indexOf(",")+1);
				var res = result.substring(result.indexOf(",")+1).split("+");
				res[10] = res[10].replace("C","");
		
				//functionMenu();
				//borrarTimers();
				//borrarContenedores();
				cargarSistema();

			    generarChartDisk(res[0],res[1],res[2],res[3],res[4],res[5],res[6],res[7],res[8],res[9],res[10]);

			}
			if(ajax.responseText.indexOf("logGps")  >-1){
				var res = ajax.responseText.split("&");
				var resultado = "";
				resultado +="<form id='alta-configuracion' class='formulario'>";
					resultado +="<fieldset>";
						resultado +="<legend>Datos en trama</legend>";
						resultado +="<div>";
							resultado +="<label>Fecha inicial: </label>";
							resultado +="<input readonly style='border: 0;' id='fechaInicial' value='"+res[1]+"'>";
						resultado +="</div>";	
						resultado +="<div>";
							resultado +="<label>Numeracion inicial: </label>";
							resultado +="<input readonly style='border: 0;' id='numeracionInicial' value='"+res[2]+"'>";
						resultado +="</div>";
						resultado +="<div>";
							resultado +="<label>Entradas al inicio: </label>";
							resultado +="<input readonly style='border: 0;' id='entradasInicial' value='"+res[3]+"'>";
						resultado +="</div>";
						resultado +="<div>";
							resultado +="<label>Salidas al inicio: </label>";
							resultado +="<input readonly style='border: 0;' id='salidasInicial' value='"+res[4]+"'>";
						resultado +="</div>";	
						resultado +="<div>";
							resultado +="<label>Fecha final: </label>";
							resultado +="<input readonly style='border: 0;' id='fechaFinal' value='"+res[5]+"'>";
						resultado +="</div>";	
						resultado +="<div>";
							resultado +="<label>Numeracion final: </label>";
							resultado +="<input readonly style='border: 0;' id='numeracionFinal' value='"+res[6]+"'>";
						resultado +="</div>";
						resultado +="<div>";
							resultado +="<label>Total dia: </label>";
							resultado +="<input readonly style='border: 0;' id='totalDia' value='"+res[7]+"'>";
						resultado +="</div>";
						resultado +="<div>";
							resultado +="<label>Entradas al final: </label>";
							resultado +="<input readonly style='border: 0;' id='entradasFinal' value='"+res[8]+"'>";
						resultado +="</div>";
						resultado +="<div>";
							resultado +="<label>Salidas al final: </label>";
							resultado +="<input readonly style='border: 0;' id='salidasFinal' value='"+res[9]+"'>";
						resultado +="</div>";			
						resultado +='<input type="submit" value="Enviar Trama" id="btnEnviarTrama">';	
					resultado +="</fieldset>";
				resultado +="</form>";
				
				$("#htmlTabla").html(resultado+res[0]);
				$("#btnEnviarTrama").click(EnviarTrama);
				
			}if(ajax.responseText.indexOf("SOCKET")  >-1){
				var res = ajax.responseText.split("&");
				
				var resultado = "";
				resultado +="<div>";
					resultado +="<label>Resultado de la operación: </label>";
					resultado +="<label>"+res[0]+"</label>";
				resultado +="</div>";	
				resultado +="<div>";
					resultado +="<label>Respuesta del servidor: </label>";
					if(res[1].includes("c,")) resultado +="<label>Confirmado</label>";
					else if(res[1].includes("e,")) resultado +="<label>Rechazado</label>";
					else resultado +="<label>No hubo respuesta...</label>";
				resultado +="</div>";
				$("#tablaLogGps").html(resultado);
			}

		}else{
			console.log("Valor reinicio: "+reinicio);
			if(reinicio == 1) mostrarBarraReinicio(retardoReinicio,"Reinicio en progreso...");
			if(reinicio == 2) mostrarBarraReinicio(retardoApagado,"Apagado en progreso...");
			else alert("El servidor no contestó\nError "+ajax.status+":"+ajax.statusText);
		}
		//console.log(ajax);
	}
}

//Envia la trama al servidor de Regisdata
function EnviarTrama(evento){
	evento.preventDefault();
	var date_i = $("#fechaInicial").val().split(" ");
	var fecha_i = date_i[0].split("-");
	var time_i = date_i[1].split(":");
	var date_f = $("#fechaFinal").val().split(" ");
	console.log(date_f);
	var fecha_f = date_f[0].split("-");
	var time_f = date_f[1].split(":");
	console.log(time_f);
	if(firmware.includes("F8")){
		var trama = "044<1,30,"+$("#numeracionInicial").val()+","+$("#entradasInicial").val()+","+$("#salidasInicial").val()+","+time_i[0]+","+time_i[1]+","+fecha_i[2]+","+fecha_i[1]+",";
		trama += "30,"+placa+","+$("#numeracionFinal").val()+","+$("#totalDia").val()+","+$("#entradasFinal").val()+","+$("#salidasFinal").val()+","+time_f[0]+","+time_f[1]+","+fecha_f[2]+","+fecha_f[1]+",";
		trama += firmware+",99,(0),[0],{0},";
		trama += (trama.length-4);
		var crc = 0x00;
		for(var i=4;i<(trama.length);i++){
			crc ^= trama.charCodeAt(i); 
		}
		trama += ">*"+decimalToHex(crc,2);
		var datos = "transaccion=enviarTrama&trama="+trama;
	}	
	if(firmware.includes("F2")){
		//console.log("Placa[0]:"+placa.charAt(0));
		var CRC = ((placa.charCodeAt(0)*placa.charCodeAt(1) + placa.charCodeAt(2)) * (placa.charCodeAt(3) * placa.charCodeAt(4) + placa.charCodeAt(5)));
		CRC = CRC%255;
		//console.log("CRC:"+CRC);
		var trama = "044<"+placa+","+$("#numeracionFinal").val()+","+$("#entradasFinal").val()+","+$("#salidasFinal").val()+","+$("#totalDia").val()+",3,("+matrizDatosConteo.length+",";
		for(var i=0; i<matrizDatosConteo.length; i++){
			if((i+1)< matrizDatosConteo.length){
				var date_i = matrizDatosConteo[i][3].split(" ");
				var fecha_i = date_i[0].split("-");
				var time_i = date_i[1].split(":");
				trama += fecha_i[1]+","+fecha_i[2]+","+time_i[0]+","+time_i[1]+","+matrizDatosConteo[i][6]+","+matrizDatosConteo[i][7]+","+matrizDatosConteo[i][4]+","+matrizDatosConteo[i][5]+",";
			}else{
				var date_i = matrizDatosConteo[i][3].split(" ");
				var fecha_i = date_i[0].split("-");
				var time_i = date_i[1].split(":");
				trama += fecha_i[1]+","+fecha_i[2]+","+time_i[0]+","+time_i[1]+","+matrizDatosConteo[i][6]+","+matrizDatosConteo[i][7]+","+matrizDatosConteo[i][4]+","+matrizDatosConteo[i][5];
			}
		}
		trama += "),[0],{0},";
		trama += (trama.length-4);
		var crc = CRC;
		for(var i=4;i<(trama.length);i++){
			crc ^= trama.charCodeAt(i); 
		}
		trama += ">*"+decimalToHex(crc,2);
		//console.log(trama);

		var datos = "transaccion=enviarTrama&trama="+trama;
	}
	ejecutarAJAX(datos);
}

function eliminarHistorico(evento){
	evento.preventDefault();
	//alert(evento.target.dataset.id_historico);
	var idHistorico = evento.target.dataset.id_historico;
	var confirmacion = confirm("Esta seguro de eliminar el registro historico?");
	if(confirmacion){
		var datos = "idHistorico="+idHistorico+"&transaccion=eliminarHistorico";
		ejecutarAJAX(datos);
	}
	updateHistorico();
}

function eliminarAlarma(evento){
	evento.preventDefault();
	//alert(evento.target.dataset.id_historico);
	var idAlarma = evento.target.dataset.id_alarma;
	var confirmacion = confirm("Esta seguro de eliminar el registro de alarma?");
	if(confirmacion){
		var datos = "idAlarma="+idAlarma+"&transaccion=eliminarAlarma";
		ejecutarAJAX(datos);
	}
	updateAlarmas();
}

function eliminarAudio(evento){
	evento.preventDefault();
	console.log(evento);
	var idAudio = evento.target.dataset.id_mensajesaudio;
	var confirmacion = confirm("Esta seguro de eliminar la programación de audio?");
	
	precarga.style.display = "block";
	precarga.innerHTML = "<img src='img/loader.gif' />";
	if(confirmacion){
		$.ajax({
		    url: "controlador.php",
		    type: 'POST',
		    data: {transaccion:"eliminarProgramacionAudio", id:idAudio},
		    datatype: "JSON",
		    success: function(data) {
		    		precarga.innerHTML = null;
		        	graficos.innerHTML = data;
			     	setTimeout(function(){
		     			updateAudios();
					}, 2000);
			    }
		});
	//updateAudio();
	}
}

function eliminarRedWifi(evento){
	evento.preventDefault();
	cambios_wifi = true;
	//alert(evento.target.dataset.id_historico);
	var idRedWifi = evento.target.dataset.id_wifi;
	var confirmacion = confirm("Esta seguro de eliminar el registro de red wifi?");
	if(confirmacion){
		var datos = "idRedWifi="+idRedWifi+"&transaccion=eliminarRedWifi";
		console.log(datos);
		ejecutarAJAX(datos);
	}
	updateWifi();
}

function functionMenu() {
    var x = document.getElementById("Topnav");
    if (x.className === "topnav") {
        x.className += " responsive";
    } else {
        x.className = "topnav";
    }
}
//Función que da la orden de grabar el recorrido GPS
function grabarRecorrido(evento){
	evento.preventDefault();
	//alert("grabarRecorrido");
	$.ajax({
	    url: "controlador.php",
	    type: 'POST',
	    data: {transaccion:"grabarRecorrido"},
	    success: function(data){
	    	//console.log(data);
	    	alert("Comando aceptado");
	   	},
	   	error: function(data){
	    	console.log(data);
	   	},
	});
} 
//Guardar configuración IP
function guardarConfigIp(evento){
	evento.preventDefault();
	cambios_wifi = true;
	var nombre = new Array();
	var valor = new Array();
	var datos = "";
	var i = 0;
	var j = 0;
	
	evento = document.querySelector("#ip_config_form");
	console.log(evento);
	for(i=0; i< (evento.length-1); i++){
		
		nombre[i] = evento.elements[i].name;
		//console.log("nombre: "+nombre[i]);
		valor[i] = evento.elements[i].value;
		//console.log("valor: "+valor[i]);
		datos += nombre[i]+"="+valor[i]+"&";
		j++;
	
	}
	datos += "transaccion=guardarIpConfig";
	//console.log(datos);
	ejecutarAJAX(datos);
}

//Guarda las redes wifi 
function guardarRedWifi(evento){
	//alert("Pregarando guardar");
	evento.preventDefault();
	scroll(0,0);
	var nombre = new Array();
	var valor = new Array();
	var datos = "";
	var i = 0;
	var j = 0;
	var valorSsid = 0;
	var valorPsk = 0;
	//console.log(evento.target);
	var datos_red = "";
	var config_ip = $("#ip_config").val();
	if(config_ip.indexOf("ESTATICA") > -1){
		var ip = $("#direccionIp").val();
		//console.log(ip);
		var mask = $("#mascarared").val();
		//console.log(mask);
		var gateway = $("#gateway").val();
		//console.log(gateway);
	}
	datos_red = "&config_ip="+config_ip+"&ip="+ip+"&mask="+mask+"&gateway="+gateway;
	console.log(datos_red);
	for(i=2; i< (evento.target.length-3); i++){
		if("Borrar".localeCompare(evento.target[i].value) != 0){
		nombre[i] = evento.target[i].name;
		if(nombre[i].indexOf("ssid") >-1) nombre[i] = "ssid"+(valorSsid++);
		if(nombre[i].indexOf("psk") >-1) nombre[i] = "psk"+(valorPsk++);
		//console.log("nombre: "+nombre[i]);
		valor[i] = evento.target[i].value;
		if(valor[i].length < 8){
			alert("El SSID y Clave deben contener al menos 8 caracteres");
			return;
		}
		//console.log("valor: "+valor[i]);
		datos += nombre[i]+"="+valor[i]+"&";
		j++;
		}
	}
	//console.log(""+(evento.target.length-3));
	var resultado = document.querySelector("#networkbox");
	var Networks = resultado.dataset.valor;
	datos += "Networks="+Networks+"&transaccion=guardarRedWifi&so_board="+so_board+datos_red;
	console.log(datos);
	ejecutarAJAX(datos);
}

//Función que genera la trama para enviar por wifi
function GenerarTrama(evento){
	evento.preventDefault();
	document.getElementById("htmlTabla").scrollIntoView();
	var fecha_inicial = $("#fecha_inicial").val();
	var hora_inicial = $("#hora_inicial").val();
	var fecha_final = $("#fecha_final").val();
	var hora_final = $("#hora_final").val();
	var datos = "transaccion=generarTrama&fechaInicial="+fecha_inicial+"&horaInicial="+hora_inicial+"&fechaFinal="+fecha_final+"&horaFinal="+hora_final;
	ejecutarAJAX(datos);
	cargarTablaConteo(fecha_inicial,hora_inicial,fecha_final,hora_final);
}

function cargarTablaConteo(fecha_inicial,hora_inicial,fecha_final,hora_final){
	
	precarga.style.display = "block";
	precarga.innerHTML = "<img src='img/loader.gif' />";
	$.ajax({
	    url: "controlador.php",
	    type: 'POST',
	    data: {transaccion:"datosConteo",fecha_inicial:fecha_inicial,hora_inicial:hora_inicial,fecha_final:fecha_final,hora_final:hora_final},
	    dataType:"json",
	    success: function(data) {
	    	precarga.innerHTML = null;
	        matrizDatosConteo = data;
	        console.log(matrizDatosConteo);
	        console.log(matrizDatosConteo.length);
	   	}
	});
}

/*
function initMap() {
	latitud_a = Number(latitud);
	longitud_a = Number(longitud);
	//console.log("La_a:"+latitud_a);
	//console.log("Lo_a:"+longitud_a);
    var myLatLng = {lat: latitud_a, lng: longitud_a};

    var map = new google.maps.Map(mapa, {
      zoom: 16,
      center: myLatLng
    });

    var marker = new google.maps.Marker({
      position: myLatLng,
      map: map,
      title: 'Estoy aquí!!!'
    });
}*/

function iniciarAplicacionJava(event){
	event.preventDefault();
	precarga.innerHTML = "<img src='img/loader.gif' />";
	//alert("Iniciando aplicacion JAVA");
	var datos = "transaccion=ejecutarJAVA&";
	ejecutarAJAX(datos);

}

function generarChartDisk(total,usado,restante,dato1,dato2,dato3,dato4,dato5,dato6,cpu,temp){
	var ctx = document.getElementById("chart");
	var myChart = new Chart(ctx, {
	    type: 'pie',
	    data: {
	        labels: ["Usado: "+usado+"Gbytes", "Libre: "+restante+"Gbytes"],
	        datasets: [{
	            label: 'Distribución de espacio en disco',
	            data: [usado,restante],
	            backgroundColor: [
	                'rgba(255, 99, 132,1)',
	                'rgba(54, 162, 235, 1)'
	            ],
	            borderColor: [
	                'rgba(255,99,132,1)',
	                'rgba(54, 162, 235, 1)'
	            ],
	            borderWidth: 1
	        }]
	    },
	    options: {
	    	responsive: true,
			legend: { display: true },
			title: {
			display: true,
			text: 'Uso Disco Duro'
			}
	    }
	});
	ctx = document.getElementById("chart1");
	myChart = new Chart(ctx, {
	    type: 'pie',
	    data: {
	        labels: ["Usada","Compartida","Cache","Disponible"],
	        datasets: [{
	            label: 'Distribución de memoria RAM',
	            data: [dato2,dato4,dato5,dato3],
	            backgroundColor: [
	                'blue',
	                'violet',
	                'yellow',
	                'green'
	            ],
	            borderColor: [
	                'blue',
	                'violet',
	                'yellow',
	                'green'
	            ],
	            borderWidth: 1
	        }]
	    },
	    options: {
	    	responsive: true,
	      legend: { display: true },
	      title: {
	        display: true,
	        text: 'Uso de RAM'
	      }
	    }
	});
	ctx = document.getElementById("chart2");
	var uso = 100-cpu;
	uso = uso.toFixed(2);
	myChart = new Chart(ctx, {
	    type: 'pie',
	    data: {
	        labels: ["Uso: "+uso+"%","Libre: "+cpu+"%"],
	        datasets: [{
	            label: 'Uso CPU %',
	            data: [uso,cpu],
	            backgroundColor: [
	                'red',
	                'green'
	            ],
	            borderColor: [
	                'red',
	                'green'
	            ],
	            borderWidth: 1
	        }]
	    },
	    options: {
	    	responsive: true,
	      legend: { display: true },
	      title: {
	        display: true,
	        text: 'Uso de la CPU %'
	      }
	    }
	});
	var color;
	if(temp < 52) color = 'green';
	else if(temp >=52 && temp < 75 ) color = 'yellow';
	else color = 'red'; 
	new Chart(document.getElementById("chart3"), {
	    type: 'bar',
	    data: {
	      labels: [temp+"ºC"],
	      datasets: [
	        {
	          backgroundColor: [color],
	          data: [temp]
	        }
	      ]
	    },
	    options: {
	      legend: { display: false },
	      title: {
	        display: true,
	        text: 'Temperatura del procesador'
	      }
	    }
	});
}


function insertarConfiguracion(event){
	
	event.preventDefault();
	//alert("Insertando configuración");
	scroll(0,0);
	var nombre = new Array();
	var valor = new Array();
	var datos = "";
    evento = document.querySelector("#alta-configuracion");
	for(var i=0; i< evento.length; i++){
		nombre[i] = evento.elements[i].name;
		//console.log(nombre[i]);
		valor[i] = evento.elements[i].value;
                if(valor[i].includes("+")) valor[i] = valor[i].replace("+","");
		//console.log(valor[i]);
		datos += nombre[i]+"="+valor[i]+"&";
		//console.log(datos);
	}
	ejecutarAJAX(datos);
}

function insertarHistorico(evento){
	evento.preventDefault();
	
	var nombre = new Array();
	var valor = new Array();
	var datos = "";
	scroll(0,0);
	for(var i=1; i< evento.target.length; i++){
		nombre[i] = evento.target[i].name;
		console.log(nombre[i]);
		valor[i] = evento.target[i].value;
		console.log(valor[i]);
		datos += nombre[i]+"="+valor[i]+"&";
		console.log(datos);
	}
	ejecutarAJAX(datos);
}

function mostrarBarraReinicio(intervalo, leyenda){
	respuesta.innerHTML = "0%";
	var elements = document.querySelectorAll(".bEspera");
	show(elements);
	//show(elements, 'inline-block'); // The second param allows you to specify a display value
	$("#barraEspera").show();
	var elem = document.getElementById("barraEspera");   
	var width = 1;
	var id = setInterval(frame,intervalo);
	function frame() {
	    if (width >= 100) {
	      	clearInterval(id);
	      	$("#barraEspera").hide();
	      	if(leyenda == "Iniciando aplicación JAVA..." || leyenda == "Insertando datos en BD..." || leyenda == "Deteniendo aplicación JAVA..."){
	      		/*
	      		elem.innerHTML = "<div id='barEspera' class='bEspera'>";
  					elem.innerHTML += "<div id='barraEspera' class='bEspera'></div>";
				elem.innerHTML += "</div>";*/
				elem.style.width = 0+'%';
				//elem.style.backgroundColor = 'white';
	      		btnConfig.click(); //Recarga la configuración
	      	}
	      	else setTimeout(window.location.reload(),1000); //Recarga la pagina despues de x segundos
	    } else {
	      width++; 
	      elem.style.width = width + '%'; 
	      respuesta.innerHTML =leyenda+ width + '%';
	    }
	}
}

function mostrarMapa(){
	ejecutarAJAX("&transaccion=mostrarMapa");
}

function objetoAJAX(){ // Obtiene el objeto AJAX del navegador
	if(window.XMLHttpRequest){ // Si es Chrome
		return new XMLHttpRequest();
	}else if(window.ActiveXObject){ // Si es IE
		return new ActiveXObject("Microsoft.XMLHTTP");
	}
}

function paginaActual(evento){
	evento.preventDefault();
	clickPagina = true;
	var idPagina = Number(evento.target.dataset.id_pagina);
	jQuery("#idResultadoTabla").load("vistas.php?func=mostrar"+tipoTabla+"&pageAct="+idPagina, asignarEventosTabla);
}

function programarAudios(evento){
	evento.preventDefault();
	precarga.innerHTML = "<img src='img/loader.gif' />";
	jQuery("#htmlTabla").load("vistas.php?func=programarAudios", asignarEventosAudio);
}

function reiniciarSistema(evento){
	evento.preventDefault();
	var datos = "transaccion=reiniciar";
	reinicio = 1;
	ejecutarAJAX(datos);
}

function retroceder(evento){
	evento.preventDefault();
	clickPagina = true;
	var idPagina = Number(evento.target.dataset.id_pagina) - 1;
	jQuery("#idResultadoTabla").load("vistas.php?func=mostrar"+tipoTabla+"&pageAct="+idPagina, asignarEventosTabla);
}
//Muestra los elementos 
function show (elements, specifiedDisplay) {
  var computedDisplay, element, index;

  elements = elements.length ? elements : [elements];
  for (index = 0; index < elements.length; index++) {
    element = elements[index];

    // Remove the element's inline display styling
    element.style.display = '';
    computedDisplay = window.getComputedStyle(element, null).getPropertyValue('display');

    if (computedDisplay === 'none') {
        element.style.display = specifiedDisplay || 'block';
    }
  }
}

function scanWifi(){
	precarga.innerHTML = "<img src='img/loader.gif' />";
	borrarContenedores();
	jQuery("#scanwifi").load("vistas.php?func=scanWifi",scanWifiListo);
}

function scanWifiListo(){
	precarga.innerHTML = null;
}

function servidorError(){
	$("#contenido").html("El contador no responde. Por favor verifique que se encuentre dentro de la red. Gracias.");
}

function stopAplicacionJava(evento){
	event.preventDefault();
	precarga.innerHTML = "<img src='img/loader.gif' />";
	//alert("Detener aplicacion JAVA");
	var datos = "transaccion=detenerJAVA&";
	ejecutarAJAX(datos);
}

function validarHardware(){
	ejecutarAJAX("&transaccion=validarHardware");
}


function updateHistorico(){
	tipoTabla = "Historico";
	jQuery("#idResultadoTabla").load("vistas.php?func=mostrarHistorico", asignarEventosTabla);
	
}

function updateLogSistema(){
	borrarTimers();
	borrarContenedores();
	jQuery("#htmlTabla").html("");
	precarga.innerHTML = "<img src='img/loader.gif' />";
	jQuery("#htmlTabla").load("vistas.php?func=mostrarLogSistema", asignarEventosLogs);
	
}

function updateValidaciones(){
	borrarContenedores();
	borrarTimers();
	jQuery("#htmlTabla").html("");
	precarga.innerHTML = "<img src='img/loader.gif' />";
	tipoTabla = "Validaciones";
	jQuery("#htmlTabla").load("vistas.php?func=mostrarValidaciones", asignarEventosTabla);
	
}

function updateVideos(){
    borrarTimers();
    borrarContenedores();
    jQuery("#htmlTabla").html("");
    precarga.innerHTML = "<img src='img/loader.gif' />";

    $.ajax({
        url: "controlador.php",
        type: 'POST',
        data: {transaccion:"consultarConfigVideos"},
        success: function(data) {
            var form = "";
            precarga.innerHTML = null;
            console.log(data);
            if(data.includes("NO_CONFIG")){
                var confirmacion = confirm("Las opciones de video no estan configuradas. Desea hacerlo?");
                if(confirmacion){
                    form = '<div class="form-style-10" id="idFormularioVideos">';
                    form += '<h1 id="idOpcionesVideo">Opciones de video<span>Click para ocultar o mostrar el formulario!</span></h1>';
                        form +="<form id='idFormVideos'>";
                            form += '<div class="inner-wrap">';
                                form += "<label for='activarCamara'>Activar Camara:";
                                    form += "<select name='activarCamara_tx' type='text' id='idActivarCamara'>";
                                        form += "<option value='0' style='color:red' selected >NO</option>";
                                        form += "<option value='1'  >SI</option>";
                                    form += "</select>" ;   
                                form += "</label>";
                                
                                form += "<label for='activarAConteo'>Activar video por conteo:";
                                    form += "<select name='activarAConteo_tx' type='text' id='idActivarAConteo'>";
                                        form += "<option value='0' selected >SI</option>";
                                        form += "<option value='1'  >NO</option>";
                                    form += "</select>" ;   
                                form += "</label>";
                                form += "<label for='activarTipoConteo'>Tipo de conteo:";
                                    form += "<select name='activarTipoConteo'_tx' type='text' id='idActivarTipoConteo'>";
                                        form += "<option value='0' selected >Entradas</option>";
                                        form += "<option value='1'  >Salidas</option>";
                                        form += "<option value='2'  >Entradas y Salidas</option>";
                                    form += "</select>" ;   
                                form += "</label>";
                                form += "<label for='activarTConteo'>Tiempo (seg) video por conteo:";
                                    form += "<select name='activarTConteo'_tx' type='text' id='idActivarTConteo'>";
                                        form += "<option value='3' selected >3</option>";
                                        form += "<option value='4  >4</option>";
                                        form += "<option value='5'  >5</option>";
                                    form += "</select>" ;   
                                form += "</label>";
                                
                                form += "<label for='activarABloqueo'>Activar video por bloqueo:";
                                    form += "<select name='activarABloqueo_tx' type='text' id='idActivarABloqueo'>";
                                        form += "<option value='0' selected >NO</option>";
                                        form += "<option value='1'  >SI</option>";
                                    form += "</select>" ;   
                                form += "</label>";
                                form += "<label for='activarTBloqueo'>Tiempo (seg) video por bloqueo:";
                                    form += "<select name='activarTBloqueo_tx' type='text' id='idActivarTBloqueo'>";
                                        form += "<option value='5' selected >5</option>";
                                        form += "<option value='10'  >10</option>";
                                        form += "<option value='15'  >15</option>";
                                        form += "<option value='20'  >20</option>";
                                    form += "</select>" ;   
                                form += "</label>";

                                form += "<label for='activarATapa'>Activar video por suiche tapa:";
                                    form += "<select name='activarATapa_tx' type='text' id='idActivarATapa'>";
                                        form += "<option value='0' selected >NO</option>";
                                        form += "<option value='1'  >SI</option>";
                                    form += "</select>" ;   
                                form += "</label>";
                                form += "<label for='activarTTapa'>Tiempo (seg) video por suiche tapa:";
                                    form += "<select name='activarTTapa_tx' type='text' id='idActivarTTapa'>";
                                        form += "<option value='5' selected >5</option>";
                                        form += "<option value='10'  >10</option>";
                                        form += "<option value='15'  >15</option>";
                                        form += "<option value='20'  >20</option>";
                                    form += "</select>" ;   
                                form += "</label>";

                                form += "<label for='activarAObstruido'>Activar video por sensor obstruido:";
                                    form += "<select name='activarAObstruido_tx' type='text' id='idActivarAObstruido'>";
                                        form += "<option value='0' selected >NO</option>";
                                        form += "<option value='1'  >SI</option>";
                                    form += "</select>" ;   
                                form += "</label>";
                                form += "<label for='activarTObstruido'>Tiempo (seg) video por sensor obstruido:";
                                    form += "<select name='activarTObstruido_tx' type='text' id='idActivarTObstruido'>";
                                        form += "<option value='5' selected >5</option>";
                                        form += "<option value='10'  >10</option>";
                                        form += "<option value='15'  >15</option>";
                                        form += "<option value='20'  >20</option>";
                                    form += "</select>" ;   
                                form += "</label>";

                                form += "<label for='limite'>Limite de videos:";
                                    form += "<select name='limite_tx' type='text' id='idLimiteVideos'>";
                                        form += "<option value='100' selected >100</option>";
                                        form += "<option value='200'  >200</option>";
                                        form += "<option value='300'  >300</option>";
                                        form += "<option value='400'  >400</option>";
                                        form += "<option value='500'  >500</option>";
                                        form += "<option value='1000'  >1000</option>";
                                    form += "</select>" ;   
                                form += "</label>";

                                form += "<button type='button' id='idEnviarConfigVideo'>Aplicar cambios</button>";
                                form += "<button type='button' id='idBorrarVideos'>Borrar todos los videos</button>";
                                form += "<button type='button' id='idProbarCamara'>Probar la camara</button>";
                            form += "</div>";
                        form += "</form>";
                    form += "</div>";
                }
            }else if(data.includes("CONFIG")){
                var partes = data.split(",");
                console.log(partes);
                form = '<div class="form-style-10" id="idFormularioVideos">';
                    form += '<h1 id="idOpcionesVideo">Opciones de video<span>Click para ocultar o mostrar el formulario!</span></h1>';
                        form +="<form id='idFormVideos'>";
                            form += '<div class="inner-wrap">';
                                form += "<label for='activarCamara'>Activar Camara:";
                                if(partes[1] == 0) var style = "style='color:red'";
                                    form += "<select name='activarCamara_tx' type='text' id='idActivarCamara' "+style+">";
                                        if(partes[1] == 0) form += "<option value='0' selected >NO</option>";
                                        else form += "<option value='0'>NO</option>";
                                        if(partes[1] == 1) form += "<option value='1' selected >SI</option>";
                                        else form += "<option value='1'>SI</option>";
                                    form += "</select>" ;   
                                form += "</label>";
                                
                                form += "<label for='activarAConteo'>Activar video por conteo:";
                                    form += "<select name='activarAConteo_tx' type='text' id='idActivarAConteo'>";
                                        if(partes[2] == 0)  form += "<option value='0' selected >NO</option>";
                                        else form += "<option value='0'>NO</option>"; 
                                        if(partes[2] == 1) form += "<option value='1' selected  >SI</option>";
                                        else form += "<option value='1'>SI</option>";
                                    form += "</select>" ;   
                                form += "</label>";
                                form += "<label for='activarTipoConteo'>Tipo de conteo:";
                                    form += "<select name='activarTipoConteo'_tx' type='text' id='idActivarTipoConteo'>";
                                        if(partes[3] == 0) form += "<option value='0' selected >Entradas</option>";
                                        else form += "<option value='0' >Entradas</option>"; 
                                        if(partes[3] == 1) form += "<option value='1' selected >Salidas</option>";
                                        else form += "<option value='1' >Salidas</option>";
                                        if(partes[3] == 2) form += "<option value='2' selected>Entradas y Salidas</option>";
                                        else form += "<option value='2'>Entradas y Salidas</option>";
                                    form += "</select>" ;   
                                form += "</label>";
                                form += "<label for='activarTConteo'>Tiempo (seg) video por conteo:";
                                    form += "<select name='activarTConteo'_tx' type='text' id='idActivarTConteo'>";
                                        if(partes[4] == 3) form += "<option value='3' selected >3</option>";
                                        else form += "<option value='3'>3</option>";
                                        if(partes[4] == 4) form += "<option value='4' selected >4</option>";
                                        else form += "<option value='4'>4</option>";
                                        if(partes[4] == 5) form += "<option value='5' selected >5</option>";
                                        else form += "<option value='5'>5</option>";
                                    form += "</select>" ;   
                                form += "</label>";
                                
                                form += "<label for='activarABloqueo'>Activar video por bloqueo:";
                                    form += "<select name='activarABloqueo_tx' type='text' id='idActivarABloqueo'>";
                                        if(partes[5] == 0) form += "<option value='0' selected >NO</option>";
                                        else form += "<option value='0'>NO</option>"; 
                                        if(partes[5] == 1) form += "<option value='1' selected>SI</option>";
                                        else form += "<option value='1'>SI</option>";
                                    form += "</select>" ;   
                                form += "</label>";
                                form += "<label for='activarTBloqueo'>Tiempo (seg) video por bloqueo:";
                                    form += "<select name='activarTBloqueo_tx' type='text' id='idActivarTBloqueo'>";
                                        if(partes[6] == 5) form += "<option value='5' selected >5</option>";
                                        else form += "<option value='5'>5</option>"; 
                                        if(partes[6] == 10) form += "<option value='10' selected>10</option>";
                                        else form += "<option value='10'>10</option>";
                                        if(partes[6] == 15) form += "<option value='15' selected>15</option>";
                                        else form += "<option value='15'>15</option>";
                                        if(partes[6] == 20) form += "<option value='20' selected>20</option>";
                                        else form += "<option value='20'>20</option>";
                                    form += "</select>" ;   
                                form += "</label>";

                                form += "<label for='activarATapa'>Activar video por suiche tapa:";
                                    form += "<select name='activarATapa_tx' type='text' id='idActivarATapa'>";
                                        if(partes[7] == 0) form += "<option value='0' selected >NO</option>";
                                        else form += "<option value='0'>NO</option>";
                                        if(partes[7] == 1) form += "<option value='1' selected>SI</option>";
                                        form += "<option value='1'>SI</option>";
                                    form += "</select>" ;   
                                form += "</label>";
                                form += "<label for='activarTTapa'>Tiempo (seg) video por suiche tapa:";
                                    form += "<select name='activarTTapa_tx' type='text' id='idActivarTTapa'>";
                                        if(partes[8] == 5) form += "<option value='5' selected >5</option>";
                                        else form += "<option value='5'>5</option>";
                                        if(partes[8] == 10) form += "<option value='10' selected>10</option>";
                                        else form += "<option value='10'>10</option>";
                                        if(partes[8] == 15) form += "<option value='15' selected>15</option>";
                                        else form += "<option value='15'>15</option>";
                                        if(partes[8] == 20) form += "<option value='20' selected>20</option>";
                                        else form += "<option value='20'>20</option>";
                                    form += "</select>" ;   
                                form += "</label>";

                                form += "<label for='activarAObstruido'>Activar video por sensor obstruido:";
                                    form += "<select name='activarAObstruido_tx' type='text' id='idActivarAObstruido'>";
                                        if(partes[9] == 0) form += "<option value='0' selected>NO</option>";
                                        else form += "<option value='0'>NO</option>";
                                        if(partes[9] == 1) form += "<option value='1' selected>SI</option>";
                                        else form += "<option value='1'>SI</option>";
                                    form += "</select>" ;   
                                form += "</label>";
                                form += "<label for='activarTObstruido'>Tiempo (seg) video por sensor obstruido:";
                                    form += "<select name='activarTObstruido_tx' type='text' id='idActivarTObstruido'>";
                                        if(partes[10] == 5) form += "<option value='5' selected >5</option>";
                                        else form += "<option value='5'>5</option>";
                                        if(partes[10] == 10) form += "<option value='10' selected >10</option>";
                                        else form += "<option value='10'>10</option>"; 
                                        if(partes[10] == 15) form += "<option value='15' selected >15</option>";
                                        else form += "<option value='15'>15</option>";
                                        if(partes[10] == 20) form += "<option value='20' selected >20</option>";
                                        else form += "<option value='20'>20</option>";
                                    form += "</select>" ;   
                                form += "</label>";

                                form += "<label for='limite'>Limite de videos:";
                                    form += "<select name='limite_tx' type='text' id='idLimiteVideos'>";
                                        if(partes[11] == 100) form += "<option value='100' selected >100</option>";
                                        else form += "<option value='100'>100</option>";
                                        if(partes[11] == 200) form += "<option value='200' selected >200</option>";
                                        else form += "<option value='200'>200</option>";
                                        if(partes[11] == 300) form += "<option value='300' selected >300</option>";
                                        else form += "<option value='300'>300</option>";
                                        if(partes[11] == 400) form += "<option value='400' selected >400</option>";
                                        else form += "<option value='400'>400</option>";
                                        if(partes[11] == 500) form += "<option value='500' selected >500</option>";
                                        else form += "<option value='500'>500</option>";
                                        if(partes[11] == 1000) form += "<option value='1000' selected >1000</option>";
                                        else form += "<option value='1000'>1000</option>";
                                    form += "</select>" ;   
                                form += "</label>";

                                form += "<button type='button' id='idEnviarConfigVideo'>Aplicar cambios</button>";
                                form += "<button type='button' id='idBorrarVideos'>Borrar todos los videos</button>";
                                form += "<button type='button' id='idProbarCamara'>Probar la camara</button>";
                                //form += "<input type='submit' id='idDescargarConteos' value='Descargar conteos' />";
                            form += "</div>";
                        form += "</form>";
                    form += "</div>";
            }
            else if(data.includes("ERROR")) {
                alert("Lo lamento. Hubo un error con la base de datos");
            }
            


            form += "<div id='idResultadoTabla'></div>";
            jQuery("#htmlTabla").html(form);
            $("#idEnviarConfigVideo").click(function( event ) {
                event.preventDefault();
                precarga.innerHTML = "<img src='img/loader.gif' />";
                $.ajax({
                    url: "controlador.php",
                    type: 'POST',
                    data: {transaccion:"confgVideos",activado:$("#idActivarCamara").val(),aConteo:$("#idActivarAConteo").val(),tipoConteo:$("#idActivarTipoConteo").val(),tConteo:$("#idActivarTConteo").val(),aBloqueo:$("#idActivarABloqueo").val(),tBloqueo:$("#idActivarTBloqueo").val(),aTapa:$("#idActivarATapa").val(),tTapa:$("#idActivarTTapa").val(),aObstruido:$("#idActivarAObstruido").val(),tObstruido:$("#idActivarTObstruido").val(),limiteVideos:$("#idLimiteVideos").val()},
                    success: function(data) {
                        precarga.innerHTML = null;
                        setTimeout(updateVideos(),1000); //Recarga la pagina despues de x segundos
                        if(data.includes("OK")) alert("Cambios realizados con exito");
                        else alert("Hubo un error en la base de datos al realizar los cambios");
                        }
                });
            });
            $("#idBorrarVideos").click(function( event ) {
                event.preventDefault();
                precarga.innerHTML = "<img src='img/loader.gif' />";
                var confirmacion = confirm("Estas seguro de borrar todos los videos. No se podran recuperar?");
                if(confirmacion)
                $.ajax({
                    url: "controlador.php",
                    type: 'POST',
                    data: {transaccion:"borrarVideos"},
                    success: function(data) {
                        precarga.innerHTML = null;
                        setTimeout(updateVideos(),1000); //Recarga la pagina despues de x segundos
                        if(data.includes("OK")) alert("Los videos fueron borrados con exito");
                        else alert("Hubo un error al borrar los videos");
                        }
                });
            });
            
            $("#idProbarCamara").click(function( event ) {
                event.preventDefault();
                jQuery("#htmlTabla").html("<img src='img/loader.gif' />");
                
                $.ajax({
                    url: "controlador.php",
                    type: 'POST',
                    data: {transaccion:"probarCamara"},
                    success: function(data) {
                        precarga.innerHTML = null;
                        jQuery("#htmlTabla").html(data); 
                        if(data.includes("Video listo")) setTimeout(updateVideos(),1500); //Recarga la pagina despues de x segundos
                    }
                });
            });
            
            $("#idOpcionesVideo").click(function( event ) {
                event.preventDefault();
                jQuery("#idFormVideos").toggle();
            });
            jQuery("#idFormVideos").hide();
            jQuery("#idResultadoTabla").html("<img src='img/loader.gif'/>");
            jQuery("#idResultadoTabla").load("vistas.php?func=mostrarVideos", asignarEventosVideos);

           
			
            //console.log(rutasVideos);
        }
    });
    
}

function updateAlarmas(){
	tipoTabla = "Alarmas";
	jQuery("#idResultadoTabla").load("vistas.php?func=mostrarAlarmas&fechaInicial="+fechaInicialAlarma+"&fechaFinal="+fechaFinalAlarma+"&tipoAlarma="+tipoAlarma, asignarEventosTabla);
	
}

function updateAudios(){
	borrarContenedores();
	borrarTimers();
	jQuery("#htmlTabla").html("");
	precarga.innerHTML = "<img src='img/loader.gif' />";
	jQuery("#htmlTabla").load("vistas.php?func=programarAudios", asignarEventosAudio);
	
}

function updateContadores(){
	borrarContenedores();
        var dc = new Date();
        var fechaHora = dc.getFullYear()+"."+(dc.getMonth()+1)+"."+dc.getDate()+"."+dc.getHours()+"."+dc.getMinutes()+"."+dc.getSeconds();
	$.ajax({
	    url: "vistas.php?func=mostrarContadores&firmware="+firmware+"&adjHora="+adjHora+"&fechaHora="+fechaHora,
	    type: 'GET',
	    success: function(data){ 
                
	        var partes = data.split("&");
                $("#htmlTabla").html(partes[0]);
	        precarga.innerHTML = null;
                var ds = new Date(partes[1]);
                console.log("Hora cliente js:"+dc);
                console.log("Hora contador:"+ds);
                var dif = (Math.abs(dc-ds))/1000;
                console.log("Diferencia:"+dif);
                if(dif > 600){
                    adjHora = 1;
                }else adjHora = 0;
                console.log(fechaHora+","+adjHora);
	    },
	    error: function(data) {
	        servidorError();
	    }
	});
}

function updateSistema(){
	tipoTabla = "Contadores";
	$.ajax({
	    url: "vistas.php?func=mostrarSistema&firmware="+firmware,
	    type: 'GET',
	    success: function(data){ 
	        $("#sistema").html(data);
	    },
	    error: function(data) {
	        servidorError();
	    }
	});
	$.ajax({
	    url: "vistas.php?func=mostrarSensores&firmware="+firmware,
	    type: 'GET',
	    success: function(data){ 
	        $("#sensores").html(data);
	    },
	    error: function(data) {
	        servidorError();
	    }
	});
	$("#htmlTabla").html("");
	
}

function updateGps(){
	//ejecutarAJAX("&transaccion=mostrarGps");
	$.ajax({
	    url: "vistas.php?func=mostrarGps",
	    type: 'GET',
	    success: function(data){ 
	    	precarga.innerHTML = null;
	        $("#htmlTabla").html(data);
	    },
	    error: function(data) {
	        servidorError();
	    }
	});
}

function updateWifi(){
	precarga.style.display = "block";
	precarga.innerHTML = "<img src='img/loader.gif' />";
	jQuery("#htmlTabla").load("vistas.php?func=mostrarWifi&soBoard="+so_board.replace(/ /g, "_"), asignarEventosWifi); //
	
}


function verCambios(){
	borrarContenedores();
	jQuery("#htmlTabla").load("vistas.php?func=verCambios");
	borrarTimers();
}

function verCambiosFE(){
	borrarContenedores();
	jQuery("#htmlTabla").html(FirmwareCambios);
	borrarTimers();
}

function Salir(){
	window.location.href="../index.php";
}

function Ayuda(){
	var item = 1;
	var tabla = "<table id='sistema' class = 'tabla'>";
    tabla += "<thead><h2 id='tituloTabla'>Videos de ayuda</h2>";
        tabla += "<tr>";
            tabla += "<th>Item</th>";
            tabla += "<th>Descripción</th>";
            tabla += "<th>Video</th>";
        tabla += "</tr>";
    tabla += "</thead>";
    tabla += "<tbody>";
    	tabla += "<tr>";
		tabla += "<td>"+(item++)+"</td>";
		tabla += "<td>INGRESO: Video que explica como ingresar a Regislog WEB</td>";
		tabla += '<td>';
		tabla += "<a target='_blank' href='videos_ayuda/ingreso.mp4'>Ver</a>";
		tabla += "</td>";
		tabla += "</tr>";

		tabla += "<tr>";
		tabla += "<td>"+(item++)+"</td>";
		tabla += "<td>CONTADORES: Video que explica cada uno de los registros de conteo y su funcionamiento</td>";
		tabla += '<td>';
		tabla += "<a target='_blank' href='videos_ayuda/contadores.mp4'>Ver</a>";
		tabla += "</td>";
		tabla += "</tr>";

		tabla += "<tr>";
		tabla += "<td>"+(item++)+"</td>";
		tabla += "<td>ALARMAS: Video que explica como visualizar las alarmas y cada una de sus opciones</td>";
		tabla += '<td>';
		tabla += "<a target='_blank' href='videos_ayuda/alarmas.mp4'>Ver</a>";
		tabla += "</td>";
		tabla += "</tr>";

		tabla += "<tr>";
		tabla += "<td>"+(item++)+"</td>";
		tabla += "<td>HISORICOS: Video explica que como visualizar los históricos y el detalle del conteo</td>";
		tabla += '<td>';
		tabla += "<a target='_blank' href='videos_ayuda/historicos.mp4'>Ver</a>";
		tabla += "</td>";
		tabla += "</tr>";

		tabla += "<tr>";
		tabla += "<td>"+(item++)+"</td>";
		tabla += "<td>USUARIO: Video que explica como cambiar las credenciales de ingreso (nombre de usuario y clave)</td>";
		tabla += '<td>';
		tabla += "<a target='_blank' href='videos_ayuda/usuario.mp4'>Ver</a>";
		tabla += "</td>";
		tabla += "</tr>";

    tabla += "</tbody>";		
    tabla += "</table>";
	borrarContenedores();
	jQuery("#htmlTabla").html(tabla);
	borrarTimers(); 
}

//Eventos
window.addEventListener("load",alCargarDocumento);