/*
 * Decompiled with CFR 0.152.
 */
package updateapp;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import updateapp.UpdateApp;
import updateapp.WatchDog;

public class HiloServidor
extends Thread {
    BufferedWriter bw;
    FileWriter archivo;
    Date horaSistema = null;
    String[] ruta_abosluta = new String[]{"/var/www/html/RegislogWeb/Logs/", "/var/www/html/GoldCheck/Logs/"};
    String[] ruta_abosluta_descargas = new String[]{"/var/www/html/RegislogWeb/descargas/", "/var/www/html/GoldCheck/descargas/"};
    String[] ruta_abosluta_firmware = new String[]{"/var/www/html/RegislogWeb/variables/", "/var/www/html/GoldCheck/variables/"};
    String[] ruta_abosluta_appJava = new String[]{"/home/root/NetBeansProjects/", "/home/pi/NetBeansProjects/"};
    int indiceRutasArchivos = 0;
    String url_firmware = null;
    String v_firmware = null;
    String v_html = null;
    String n_firmware = null;
    String n_html = null;
    int factortiempo = 1;
    String version = "UA0003";
    static final int TIEMPO_PROCESO = 300000;
    static final int TIEMPO_WATCHDOG = 480000;

    @Override
    public void run() {
        this.crearLog("Aplicaci\u00f3n UpdateApp " + this.version + " iniciada....");
        WatchDog watchDog = new WatchDog(System.currentTimeMillis() + 480000L);
        watchDog.start();
        while (true) {
            try {
                while (true) {
                    System.out.println("Hora: " + new Date());
                    this.archivoVersionApp();
                    this.archivoVersion();
                    this.DownloadFirmware();
                    this.archivoVersionHtml();
                    this.DownloadVersionHtml();
                    watchDog.setTempo(System.currentTimeMillis() + 480000L);
                    Thread.sleep(300000 / this.factortiempo);
                }
            }
            catch (InterruptedException ex) {
                Logger.getLogger(HiloServidor.class.getName()).log(Level.SEVERE, null, ex);
                if (this.indiceRutasArchivos == 0) {
                    this.indiceRutasArchivos = 1;
                    continue;
                }
                this.indiceRutasArchivos = 0;
                continue;
            }
            break;
        }
    }

    private void archivoVersionApp() {
        try {
            PrintWriter writer = new PrintWriter("/var/www/html/RegislogWeb/variables/UpdateApp.txt", "UTF-8");
            writer.println(this.version);
            writer.close();
        }
        catch (FileNotFoundException | UnsupportedEncodingException e) {
            System.err.println(e.getClass().getName() + ": " + e.getMessage());
            this.crearLog("archivoVersion:" + e.getMessage());
        }
    }

    private void DownloadFirmware() {
        byte[] buffer = new byte[1024];
        if (this.v_firmware == null) {
            return;
        }
        if (this.v_firmware.contains("F6")) {
            this.url_firmware = "http://70.35.207.155:80/RegisbusV6/JavaV6-1/firmware.txt";
        } else if (this.v_firmware.contains("F2")) {
            this.url_firmware = "http://70.35.207.155:80/RegisbusV6/JavaRCRB/firmware.txt";
        } else if (this.v_firmware.contains("F9")) {
            this.url_firmware = "http://70.35.207.155:80/GoldCheck/Java/firmware.txt";
        } else {
            System.out.println("DownloadFirmware: No se pudo establecer el firmware para descargarlo desde el servidor");
            this.crearLog("DownloadFirmware: No se pudo establecer el firmware para descargarlo desde el servidor");
            return;
        }
        ArrayList<String> lineas = new ArrayList<String>();
        try {
            URL url = new URL(this.url_firmware);
            URLConnection uRLConnection = url.openConnection();
            uRLConnection.setConnectTimeout(5000);
            InputStream inputStream = uRLConnection.getInputStream();
            while (inputStream.read(buffer) > 0) {
                lineas.add(new String(buffer, StandardCharsets.UTF_8).replaceAll("[^a-zA-Z0-9:,\\-\n\r]", ""));
            }
            this.factortiempo = 1;
        }
        catch (MalformedURLException ex) {
            this.crearLog("Download:" + ex.toString());
            return;
        }
        catch (IOException ex) {
            this.crearLog("Download:" + ex.toString());
            this.factortiempo = 2;
            return;
        }
        if (lineas.size() > 0) {
            this.n_firmware = (String)lineas.get(0);
            System.out.println("" + this.n_firmware);
            if (this.v_firmware != null) {
                if (this.v_firmware.contains(this.n_firmware.substring(0, 2))) {
                    System.out.println("Firmware compatible");
                    if (this.v_firmware.compareTo(this.n_firmware) >= 0) {
                        System.out.println("Firmware del Mini PC tiene una versi\u00f3n superior o igual al que quiere actualizarse online");
                        this.crearLog("DownloadFirmware: Firmware actualizado a la ultima version. " + this.v_firmware);
                    } else {
                        System.out.println("DownloadFirmware: Firmware se puede acutalizar");
                        if (this.DownloadJava()) {
                            this.ProcesarFirmware();
                        } else {
                            System.out.println("Hubo un error en la descarga del archivo");
                        }
                    }
                } else {
                    System.out.println("Firmware no compatible para actualizar online");
                    this.crearLog("DownloadFirmware: Firmware no compatible para actualizar online");
                }
            } else {
                System.out.println("Firmware del mini PC no se pudo establecer");
                this.crearLog("DownloadFirmware: Firmware del mini PC no se pudo establecer");
            }
        }
    }

    private boolean DownloadJava() {
        try {
            int count;
            if (this.v_firmware.contains("F6")) {
                this.url_firmware = "http://70.35.207.155:80/RegisbusV6/JavaV6-1/" + this.n_firmware + ".zip";
            } else if (this.v_firmware.contains("F2")) {
                this.url_firmware = "http://70.35.207.155:80/RegisbusV6/JavaRCRB/" + this.n_firmware + ".zip";
            } else if (this.v_firmware.contains("F9")) {
                this.url_firmware = "http://70.35.207.155:80/GoldCheck/Java/" + this.n_firmware + ".zip";
            } else {
                System.out.println("DownloadFirmware: No se pudo establecer el firmware para descargarlo desde el servidor");
                this.crearLog("DownloadFirmware: No se pudo establecer el firmware para descargarlo desde el servidor");
                return false;
            }
            URL url = new URL(this.url_firmware);
            URLConnection uRLConnection = url.openConnection();
            uRLConnection.setConnectTimeout(5000);
            File file = new File(this.ruta_abosluta_descargas[this.indiceRutasArchivos]);
            if (!file.exists()) {
                file.mkdirs();
            }
            InputStream in = uRLConnection.getInputStream();
            FileOutputStream out = new FileOutputStream(this.ruta_abosluta_descargas[this.indiceRutasArchivos] + this.n_firmware + ".zip");
            byte[] b = new byte[1024];
            while ((count = in.read(b)) >= 0) {
                out.write(b, 0, count);
            }
            out.flush();
            out.close();
            in.close();
            return true;
        }
        catch (MalformedURLException ex) {
            this.crearLog("DownloadJava:" + ex.toString());
        }
        catch (IOException ex) {
            this.crearLog("DownloadJava:" + ex.toString());
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void crearLog(String operacion) {
        try {
            this.horaSistema = new Date(System.currentTimeMillis());
            SimpleDateFormat dt = new SimpleDateFormat("yyyy-MM-dd");
            String anexo = dt.format(this.horaSistema);
            this.archivo = new FileWriter(new File(this.ruta_abosluta[this.indiceRutasArchivos] + "logUA-" + anexo + ".txt"), true);
            this.bw = new BufferedWriter(this.archivo);
            Calendar fechaActual = Calendar.getInstance();
            fechaActual.setTime(this.horaSistema);
            this.bw.write(String.valueOf(fechaActual.get(5)) + "/" + String.valueOf(fechaActual.get(2) + 1) + "/" + String.valueOf(fechaActual.get(1)) + ";" + String.valueOf(fechaActual.get(11)) + ":" + String.valueOf(fechaActual.get(12)) + ":" + String.valueOf(fechaActual.get(13)) + ";" + operacion + "\r\n");
            this.bw.flush();
            System.err.println("Log creado con exito");
        }
        catch (IOException ex) {
            Logger.getLogger(UpdateApp.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            if (this.bw != null) {
                try {
                    this.bw.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void archivoVersion() {
        InputStreamReader lector = null;
        try {
            String texto;
            String salida = null;
            lector = new FileReader(this.ruta_abosluta_firmware[this.indiceRutasArchivos] + "version.txt");
            BufferedReader contenido = new BufferedReader(lector);
            while ((texto = contenido.readLine()) != null) {
                System.out.println("archivo versi\u00f3n: " + texto);
                salida = texto;
            }
            String[] partes = salida.split(";");
            partes = partes[partes.length - 1].split(",");
            this.v_firmware = partes[0];
            if (this.v_firmware.contains("F2")) {
                StringBuilder sb = new StringBuilder(this.v_firmware);
                int index = this.v_firmware.indexOf(".");
                sb.deleteCharAt(index);
                this.v_firmware = sb.toString();
                this.v_firmware = this.v_firmware.replace(".", "0");
            }
            System.out.println("firmware:" + this.v_firmware);
            this.factortiempo = 1;
        }
        catch (FileNotFoundException ex) {
            this.indiceRutasArchivos = this.indiceRutasArchivos == 0 ? 1 : 0;
            this.factortiempo = 20;
            this.crearLog("archivoVersion:" + ex.getMessage());
        }
        catch (IOException ex) {
            this.crearLog("archivoVersion:" + ex.getMessage());
        }
        finally {
            try {
                if (lector != null) {
                    lector.close();
                }
            }
            catch (IOException ex) {
                this.crearLog("archivoVersion:" + ex.getMessage());
            }
        }
    }

    private void ProcesarFirmware() {
        try {
            File tmpDist;
            int i;
            File[] file;
            String ruta1;
            String ruta;
            if (this.v_firmware.contains("F6")) {
                ruta = this.ruta_abosluta_descargas[this.indiceRutasArchivos] + this.n_firmware + "/RV60";
            } else if (this.v_firmware.contains("F2")) {
                ruta = this.ruta_abosluta_descargas[this.indiceRutasArchivos] + this.n_firmware + "/OrangeWifi";
            } else if (this.v_firmware.contains("F9")) {
                ruta = this.ruta_abosluta_descargas[this.indiceRutasArchivos] + this.n_firmware + "/JavaGoldCheck";
            } else {
                System.out.println("ProcesarFirmware: No se pudo establecer el firmware para descargarlo desde el servidor");
                this.crearLog("ProcesarFirmware: No se pudo establecer el firmware para descargarlo desde el servidor");
                return;
            }
            Process p = Runtime.getRuntime().exec("sudo unzip -o " + this.ruta_abosluta_descargas[this.indiceRutasArchivos] + this.n_firmware + ".zip -d " + this.ruta_abosluta_descargas[this.indiceRutasArchivos]);
            while (p.isAlive()) {
            }
            System.out.println("El archivo del firmware se ha descomprimido");
            File oldfile = new File(ruta + ".txt");
            File newfile = new File(ruta + ".jar");
            if (!oldfile.renameTo(newfile)) {
                this.crearLog("ProcesarFirmware: Hubo un error al remombrar el archivo");
                return;
            }
            System.out.println("Archivo JAVA remombrado exitosamente");
            if (this.v_firmware.contains("F6")) {
                ruta = "RV60.jar";
                ruta1 = "RV60_OrangePi";
            } else if (this.v_firmware.contains("F2")) {
                ruta = "OrangeWifi.jar";
                ruta1 = "OrangeWifi";
            } else if (this.v_firmware.contains("F9")) {
                ruta = "JavaGoldCheck.jar";
                ruta1 = "JavaGoldCheck";
            } else {
                System.out.println("ProcesarFirmware: No se pudo establecer el firmware para descargarlo desde el servidor");
                this.crearLog("ProcesarFirmware: No se pudo establecer el firmware para descargarlo desde el servidor");
                return;
            }
            System.out.println("Dando permisos al firmware");
            p = Runtime.getRuntime().exec("sudo chmod 777 " + this.ruta_abosluta_descargas[this.indiceRutasArchivos] + this.n_firmware + "/" + ruta);
            while (p.isAlive()) {
            }
            System.out.println("Deteniendo la vieja versi\u00f3n del firmware");
            p = Runtime.getRuntime().exec("sudo pkill -9 -f " + ruta);
            while (p.isAlive()) {
            }
            System.out.println("Moviendo el nuevo firmware a la carpeta destino");
            p = Runtime.getRuntime().exec("sudo mv " + this.ruta_abosluta_descargas[this.indiceRutasArchivos] + this.n_firmware + "/" + ruta + " " + this.ruta_abosluta_appJava[this.indiceRutasArchivos] + ruta1 + "/dist/" + ruta);
            while (p.isAlive()) {
            }
            String folder = this.ruta_abosluta_descargas[this.indiceRutasArchivos] + this.n_firmware + "/lib/";
            File tmpDir = new File(folder);
            if (tmpDir.exists()) {
                System.out.println("El directorio de librerias existe");
                file = tmpDir.listFiles();
                System.out.println("Numero de archivos :" + file.length);
                for (i = 0; i < file.length; ++i) {
                    tmpDist = new File(this.ruta_abosluta_appJava[this.indiceRutasArchivos] + ruta1 + "/dist/lib/" + file[i].getName());
                    Files.move(file[i].toPath(), tmpDist.toPath(), StandardCopyOption.REPLACE_EXISTING);
                    this.crearLog("ProcesarFirmware: Se copia libreria  " + file[i].getName());
                }
            }
            if ((tmpDir = new File(folder = this.ruta_abosluta_descargas[this.indiceRutasArchivos] + this.n_firmware + "/audio/")).exists()) {
                System.out.println("El directorio de audio existe");
                file = tmpDir.listFiles();
                System.out.println("Numero de archivos :" + file.length);
                for (i = 0; i < file.length; ++i) {
                    tmpDist = new File(this.ruta_abosluta_appJava[this.indiceRutasArchivos] + ruta1 + "/audio/" + file[i].getName());
                    Files.move(file[i].toPath(), tmpDist.toPath(), StandardCopyOption.REPLACE_EXISTING);
                    this.crearLog("ProcesarFirmware: Se copia audio  " + file[i].getName());
                    System.out.println("ProcesarFirmware: Se copia audio  " + file[i].getName());
                }
            }
            System.out.println("Ejecutando el nuevo firmware");
            p = Runtime.getRuntime().exec("sudo java -jar " + this.ruta_abosluta_appJava[this.indiceRutasArchivos] + ruta1 + "/dist/" + ruta + " > /dev/null 2>/dev/null &");
            System.out.println("Proceso terminado");
            this.crearLog("ProcesarFirmware: El firmware JAVA fue actualizado de " + this.v_firmware + " a " + this.n_firmware);
        }
        catch (IOException ex) {
            this.crearLog("ProcesarFirmware:" + ex.toString());
            System.out.println("ProcesarFirmware:" + ex.toString());
        }
    }

    private void archivoVersionHtml() {
        InputStreamReader lector = null;
        try {
            String salida = null;
            String ruta = this.ruta_abosluta_firmware[this.indiceRutasArchivos] + "versionHtml.txt";
            File file = new File(ruta);
            if (file.exists()) {
                String texto;
                lector = new FileReader(ruta);
                BufferedReader contenido = new BufferedReader(lector);
                while ((texto = contenido.readLine()) != null) {
                    System.out.println("archivo versi\u00f3n Html: " + texto);
                    salida = texto;
                }
            } else {
                System.out.println("El archivo versionHtml no existe");
                this.crearLog("archivoVersionHtml: El archivo versionHtml no existe");
                this.v_html = "V101";
                return;
            }
            String[] partes = salida.split(" ");
            this.v_html = partes.length >= 2 ? partes[1].replace(".", "") : salida;
            System.out.println("version Html:" + this.v_html);
        }
        catch (FileNotFoundException ex) {
            this.indiceRutasArchivos = this.indiceRutasArchivos == 0 ? 1 : 0;
            this.crearLog("archivoVersionHtml:" + ex.toString());
        }
        catch (IOException ex) {
            this.crearLog("archivoVersionHtml:" + ex.toString());
        }
        try {
            lector.close();
        }
        catch (IOException ex) {
            this.crearLog("archivoVersionHtml:" + ex.toString());
        }
    }

    private void DownloadVersionHtml() {
        byte[] buffer = new byte[1024];
        if (this.v_firmware == null) {
            return;
        }
        ArrayList<String> lineas = new ArrayList<String>();
        try {
            URL url = null;
            if (this.v_firmware.contains("F6")) {
                url = new URL("http://70.35.207.155:80/RegisbusV6/Html-1/version.txt");
            } else if (this.v_firmware.contains("F2")) {
                url = new URL("http://70.35.207.155:80/RegisbusV6/Html-1/version.txt");
            } else if (this.v_firmware.contains("F9")) {
                url = new URL("http://70.35.207.155:80/GoldCheck/Html-1/version.txt");
            }
            URLConnection uRLConnection = url.openConnection();
            uRLConnection.setConnectTimeout(5000);
            InputStream inputStream = uRLConnection.getInputStream();
            while (inputStream.read(buffer) > 0) {
                lineas.add(new String(buffer, StandardCharsets.UTF_8).replaceAll("[^a-zA-Z0-9:,\\-\n\r]", ""));
            }
        }
        catch (MalformedURLException ex) {
            this.crearLog("DownloadHtml:" + ex.toString());
            return;
        }
        catch (IOException ex) {
            this.crearLog("DownloadHtml:" + ex.toString());
            return;
        }
        if (lineas.size() > 0) {
            this.n_html = (String)lineas.get(0);
            System.out.println("n_html " + this.n_html);
            System.out.println("v_html " + this.v_html);
            if (this.v_html != null) {
                if (this.v_html.contains(this.n_html.substring(0, 2))) {
                    System.out.println("Html compatible");
                    if (this.v_html.compareTo(this.n_html) >= 0) {
                        System.out.println("Html del Mini PC tiene una versi\u00f3n superior o igual al que quiere actualizarse online");
                        this.crearLog("DownloadHtml: Html actualizado a la ultima version. " + this.v_html);
                    } else {
                        System.out.println("DownloadHtml: Html se puede acutalizar");
                        if (this.DownloadHtml()) {
                            this.ProcesarHtml();
                        } else {
                            System.out.println("Hubo un error en la descarga del archivo");
                        }
                    }
                } else {
                    System.out.println("Html no compatible para actualizar online");
                    this.crearLog("DownloadHtml: Html no compatible para actualizar online");
                }
            } else {
                System.out.println("Html del mini PC no se pudo establecer");
                this.crearLog("DownloadHtml: Firmware del mini PC no se pudo establecer");
            }
        }
    }

    private boolean DownloadHtml() {
        try {
            int count;
            URL url = null;
            if (this.v_firmware.contains("F6")) {
                url = new URL("http://70.35.207.155:80/RegisbusV6/Html-1/" + this.n_html + ".zip");
            } else if (this.v_firmware.contains("F2")) {
                url = new URL("http://70.35.207.155:80/RegisbusV6/Html-1/" + this.n_html + ".zip");
            } else if (this.v_firmware.contains("F9")) {
                url = new URL("http://70.35.207.155:80/GoldCheck/Html-1/" + this.n_html + ".zip");
            }
            URLConnection uRLConnection = url.openConnection();
            uRLConnection.setConnectTimeout(5000);
            File file = new File(this.ruta_abosluta_descargas[this.indiceRutasArchivos]);
            if (!file.exists()) {
                file.mkdirs();
            }
            InputStream in = uRLConnection.getInputStream();
            FileOutputStream out = new FileOutputStream(this.ruta_abosluta_descargas[this.indiceRutasArchivos] + this.n_html + ".zip");
            byte[] b = new byte[1024];
            while ((count = in.read(b)) >= 0) {
                out.write(b, 0, count);
            }
            out.flush();
            out.close();
            in.close();
            return true;
        }
        catch (MalformedURLException ex) {
            this.crearLog("DownloadHtml:" + ex.toString());
        }
        catch (IOException ex) {
            this.crearLog("DownloadHtml:" + ex.toString());
        }
        return false;
    }

    private void ProcesarHtml() {
        try {
            Process p = Runtime.getRuntime().exec("sudo unzip -o " + this.ruta_abosluta_descargas[this.indiceRutasArchivos] + this.n_html + ".zip -d /home/root/");
            while (p.isAlive()) {
            }
            System.out.println("El archivo del html se ha descomprimido");
            System.out.println("Dando permisos al html");
            p = Runtime.getRuntime().exec("sudo chmod -R 777 /home/root/html");
            while (p.isAlive()) {
            }
            System.out.println("Deteniendo apache en el mini pc");
            System.out.println("Moviendo el nuevo html a la carpeta destino");
            p = Runtime.getRuntime().exec("sudo rsync -av /home/root/html /var/www/");
            while (p.isAlive()) {
            }
            System.out.println("Dando de nuevo permisos al html");
            p = Runtime.getRuntime().exec("sudo chmod -R ugo+rwx /var/www/html");
            while (p.isAlive()) {
            }
            System.out.println("Reiniciando el apache");
            p = Runtime.getRuntime().exec("sudo service apache2 restart");
            while (p.isAlive()) {
            }
            p = Runtime.getRuntime().exec("sudo pkill -9 -f OrangeWifi.jar");
            while (p.isAlive()) {
            }
            p = Runtime.getRuntime().exec("sudo java -jar /home/root/NetBeansProjects/OrangeWifi/dist/OrangeWifi.jar > /dev/null 2>/dev/null &");
            p = Runtime.getRuntime().exec("sudo pkill -9 -f RV60.jar");
            while (p.isAlive()) {
            }
            p = Runtime.getRuntime().exec("sudo java -jar /home/root/NetBeansProjects/RV60_OrangePi/dist/RV60.jar > /dev/null 2>/dev/null &");
            p = Runtime.getRuntime().exec("sudo pkill -9 -f JavaGoldCheck.jar");
            while (p.isAlive()) {
            }
            p = Runtime.getRuntime().exec("sudo java -jar /home/pi/NetBeansProjects/JavaGoldCheck/dist/JavaGoldCheck.jar > /dev/null 2>/dev/null &");
            System.out.println("sudo echo '" + this.n_html + "' > " + this.ruta_abosluta_firmware[this.indiceRutasArchivos] + "versionHtml.txt");
            String[] cmdline = new String[]{"sh", "-c", "sudo echo '" + this.n_html + "' > " + this.ruta_abosluta_firmware[this.indiceRutasArchivos] + "versionHtml.txt"};
            Runtime.getRuntime().exec(cmdline);
            System.out.println("Proceso de actualizaci\u00f3n completado");
            this.crearLog("ProcesarHtml: El html fue actualizado de " + this.v_html + " a " + this.n_html);
        }
        catch (IOException ex) {
            this.crearLog("ProcesarHtml:" + ex.toString());
        }
    }
}

