<?php 
require_once "conexionLocal.php"; 



if ($_GET["func"] == "mostrarHistorico") {
    mostrarHistorico();
}

if ($_GET["func"] == "mostrarValidaciones") {
    mostrarValidaciones();
}

if ($_GET["func"] == "mostrarAlarmas") {
    mostrarAlarmas($_GET["fechaInicial"],$_GET["fechaFinal"],$_GET["tipoAlarma"]);
}

if ($_GET["func"] == "mostrarContadores") {
    mostrarContadores($_GET["firmware"],$_GET["adjHora"],$_GET["fechaHora"]);
}

if ($_GET["func"] == "mostrarSensores") {
    mostrarSensores($_GET["firmware"]);
}

if ($_GET["func"] == "mostrarGps") {
    mostrarGps();
}

if ($_GET["func"] == "mostrarWifi") {
    //mostrarWifi($_GET["soBoard"]);
    conexionesWifi();
}

if ($_GET["func"] == "scanWifi") {
    scanWifi();
}

if ($_GET["func"] == "mostrarConfiguracion") {
    mostrarConfiguracion($_GET["firmware"]);
}

if ($_GET["func"] == "mostrarSistema") {
    mostrarSistema($_GET["firmware"]);
}

if ($_GET["func"] == "mostrarLogSistema") {
    mostrarLogSistema();
}

if ($_GET["func"] == "mostrarVideos") {
    mostrarVideos();
}

if ($_GET["func"] == "verCambios") {
    verCambios();
}

if ($_GET["func"] == "programarAudios") {
    programarAudios();
}

if ($_GET["func"] == "editarContadores") {
    editarContadores();
}
if ($_GET["func"] == "mostrarTablaVideos") {
    mostrarTablaVideos();
}
if ($_GET["func"] == "descargarVideo") {
    descargarVideo($_GET["ruta"]);
}

if ($_GET["func"] == "registrarCamaraIp") {
    registrarCamaraIp($_GET["id"]);
}


function altaHistorico(){
	$form ="<form id='alta-historico' class='formulario' data-insertar>";
		$form .= "<fieldset>";
			$form .= "<legend>Alta de historico dia:</legend>";
			$form .= "<div>";
				$form .= "<label for='fecha'>Fecha:</label>";
				$form .= "<input type='text' id='fecha' name='fecha_tx' required />";
			$form .= "</div>";
			$form .= "<div>";
				$form .= "<label for='total_dia'>Total dia:</label>";
				$form .= "<input type='text' id='total_dia' name='total_dia_tx' required />";
			$form .= "</div>";
			$form .= "<div>";
				$form .= "<input type='submit' id='insertar-btn' name='insertar_btn' value='Insertar' />";
				/*  Una entrada oculta para enviar los datos al controlador*/
				$form .= "<input type='hidden' id='transaccion' name='transaccion' value='insertar' />";
			$form .= "</div>";
		$form .= "</fieldset>";
	$form .= "</form>";	
	return printf($form);
}

function mostrarAlarmas($fechaInicial,$fechaFinal,$tipo){
	//print_r($tipo);
	$v_pag = false;
	try{
	$midb = conexionLocalSQLite3();
	$midb->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
	 
	if($fechaInicial == '0' || $fechaFinal == '0' || $fechaInicial == '' || $fechaFinal == '' ){
		$sql = 'FROM tablaAlarmas ORDER BY fecha DESC';
		$v_pag = true;
	}else if($tipo == 0){
		$sql = "FROM tablaAlarmas WHERE fecha >= '".$fechaInicial." 00:00:00' AND fecha <= '".$fechaFinal." 23:59:59' ORDER BY fecha DESC";
	}else{
		$sql = "FROM tablaAlarmas WHERE fecha >= '".$fechaInicial." 00:00:00' AND fecha <= '".$fechaFinal." 23:59:59' AND codigo = $tipo ORDER BY fecha DESC";
	}

	//Obtiene el numero de filas de la tabla
	$nRows = $midb->query('SELECT COUNT(*) '.$sql)->fetchColumn();
	$sql = 'SELECT * '.$sql;
	//print_r($sql);
	$results = $midb->prepare($sql); 
	$results->setFetchMode(PDO::FETCH_ASSOC);
	$results->execute();
	if($results){
		if($v_pag){
		/*Inicia paginación*/
		$regXPag = 20;
		$pagina = false;

		//Examniar la url de la pagina 
		if(isset($_GET["pageAct"])){ // Pregunta por url si la variable $p ya esta incializada
			$pagina = $_GET["pageAct"];
		}
		if(!$pagina){ // Este condicional es verdadero cuado se carga incialmente la pagina web
			$inicio = 0;
			$pagina = 1;
		}else{
			$inicio = ($pagina-1) * $regXPag;
		}
		$sql = $sql." LIMIT ".$regXPag." OFFSET ".$inicio;
		//echo $sql;

		$results = $midb->prepare($sql); 
		$results->setFetchMode(PDO::FETCH_ASSOC);
		$results->execute();
		//La función ceil lleva un fraccionario a su entero inmediatamente superior
		$totalPaginas = ceil($nRows/$regXPag);
		$paginacion = "<div class='paginacion'";
		$paginacion .= "<p>";
		$paginacion .= "Numero de resultados: <b>$nRows</b> ";
		$paginacion .= "Mostrando <b>$regXPag</b> resultados por pagina. ";
		$paginacion .= "Página <b>$pagina</b> de <b>$totalPaginas</b>";
		$paginacion .= "</p>";
		//Construye los enalces a las diferentes paginas 
		if($totalPaginas>1){
			$paginacion .= "<p>";
				$paginacion .= ($pagina!=1)?"<a href='#' id='retrocede' data-id_pagina='".$pagina."'>&laquo</a>":"";
				//Condicional que solo permite crear 7 enlaces a las diferentes paginas  
				$inicioPaginaMostrar = 1;
				if($pagina<8 && $totalPaginas >= 8 ) $totalPaginasMostar = 7;
				else if($pagina<8 && $totalPaginas < 8) $totalPaginasMostar = $totalPaginas;
				else{
					$inicioPaginaMostrar = $pagina;
					$totalPaginasMostar = $pagina+6;
					//Ajusta los enlaces para el ultimo bloque de paginas
					if($totalPaginasMostar >= $totalPaginas){
						$totalPaginasMostar = $totalPaginas;
					}
				}
				//////
				for($i=$inicioPaginaMostrar;$i<=$totalPaginasMostar;$i++){
					//Si muestro el indice de la pagina actual no muestro el enlace
					$actual = "<span class='actual'>$pagina</span>";
					$enlace = "<a href='#' class='paginaActual' data-id_pagina='".$i."'>$i</a>";
					$paginacion .= ($pagina == $i)?$actual:$enlace;
				}
				$paginacion .= ($pagina!=$totalPaginas)?"<a href='#' id='avanza' data-id_pagina='".$pagina."'>&raquo</a>":"";
			$paginacion .= "</p>";
		}
		$paginacion .= "</div>";
		/*Termina paginación */
	}
		$tabla = "<table id='alarmas' class = 'tabla'>";
		$tabla .= "<thead><h2 id='tituloTabla'>Tabla de alarmas</h2>";
			$tabla .= "<tr>";
				$tabla .= "<th>item</th>";
				$tabla .= "<th>Codigo</th>";
				$tabla .= "<th>Cantidad</th>";
				$tabla .= "<th>Fecha</th>";
				$tabla .= "<th>Acción</th>";
			$tabla .= "</tr>";
		$tabla .= "</thead>";
		$tabla .= "<tbody>";
		if($v_pag) $i = ($pagina-1)*20;
		else $i=0;

		while($fila = $results->fetch()){
			//echo  "dato";
			$tabla .= "<tr>";
				$tabla .= "<td>".++$i."</td>";
				//$tabla .= "<td>".$fila['Primary_Key']."</td>";
				//$tabla .= "<td>".$fila['codigo']."</td>";
				$codigo = $fila['codigo'];
				$cadena = listadoAlarmas($codigo);
				$tabla .= "<td>".$cadena."</td>";
				$cantidad = $fila['cantidad'];
				if($tipo == 5 || $tipo == 6) $totalCantidadAlarmas += $cantidad;
				$cadena = listadoCantidad($cantidad,$codigo);
				$tabla .= "<td>".$cadena."</td>";
				if($fila['estado'] == 2) $tabla .= "<td STYLE='background-color:#FE2E2E'>".$fila["fecha"]."</td>";
				else $tabla .= "<td>".$fila["fecha"]."</td>";
				$tabla .= "<td><a href='#' class='eliminar' data-id_alarma='".$fila['Primary_Key']."'>Eliminar</a></td>";
			$tabla .= "</tr>";
		}
		$tabla .= "</tbody>";		
		$tabla .= "</table>";
		if($tipo == 5 || $tipo == 6){
			$sumaAlarmas= "<div><h2>Total cantidad: $totalCantidadAlarmas</h2></div>";
		}
		$respuesta = $tabla.$paginacion;
	}else{
		//echo "No se cargo la tabla";
		$respuesta = "<div class= 'error'>Error: No se ejecuto la consulta a la base de datos</div>";
	}
	//Cierra la conexión con la base de datos
	$results = null;
	$midb = null;
/*
	$form = '<div class="form-style-10">';
	$form .= '<h1>Consulta personalizada<span>Seleccione y rango de fechas!</span></h1>';
	$form .="<form id='idFormAlarma'>";
		$form .= "<div class='inner-wrap'>";
			$form .= "<label for='fecha'>Fecha inicial:  <input type='date' id='idFechaInicial' required /></label>";
			$form .= "<label for='fecha'>  Fecha final:  <input type='date' id='idFechaFinal' required /></label>";	
			$form .= "<div>";
				$form .= "<label for='fecha'>Tipo de alarma: </label>";
				$form .= "<select name='numero_puertas_tx' type='text' id='idTipoAlarma' >";
					$form .= "<option value='0' selected >Todas</option>";
					$form .= "<option value='12'>Reset de sistema</option>";
					$form .= "<option value='13'>Reinicio preventivo</option>";
					$form .= "<option value='5'>Sensor bloqueado BQ1</option>";
					$form .= "<option value='6'>Sensor bloqueado BQ2</option>";
					$form .= "<option value='8'>Sistema antiagache</option>";
					$form .= "<option value='9'>Sistema antisalto</option>";
					$form .= "<option value='3'>Sensor obstruido</option>";
					$form .= "<option value='1'>Corto circuito</option>";
					$form .= "<option value='2'>Fuente ppal desconectada</option>";
					$form .= "<option value='17'>GPS</option>";
					$form .= "<option value='18'>Sistema hibernando</option>";
					$form .= "<option value='19'>Fuente ppal conectada</option>";
					$form .= "<option value='50'>Error en I2C</option>";
					$form .= "<option value='51'>Reinicio de aplicación</option>";
					$form .= "<option value='52'>Error en puerto serial</option>";
					$form .= "<option value='53'>Configuración WIFI recuperada</option>";
					$form .= "<option value='54'>Error en WIFI</option>";
					$form .= "<option value='10'>Escritura de datos</option>";
				$form .= "</select>";
			$form .= "</div>";
			$form .= "<input type='submit' id='idEnviarConsultaAlarma' ' value='Consultar' />";
			$form .= "<input type='submit' id='idDescargarConsultaAlarma' ' value='Descargar' />";
		$form .= "</div>";
	$form .= "</form>";
	$form .= '</div>';	
*/
	return printf($form.$respuesta.$sumaAlarmas);
	}catch(PDOException $e) {
    	echo "Lo siento hay un error en BD..  ". $e->getMessage() ;// Remove or modify after testing 
    	file_put_contents('PDOErrors.txt',date('[Y-m-d H:i:s]').", vistas.php, ". $e->getMessage()."\r\n", FILE_APPEND);  
 	}
}

function listadoCantidad($cantidad, $codigo){
	//echo "Enterando a cantida de alarma".$codigo.$cantidad;
	$cantidadAlarma = "".$cantidad;
	if($codigo == 12){ // evalua si la alarma corresponde a un reset de sistema
        switch($cantidad){
            case 0:
                $cantidadAlarma = "Bloqueo de nucleo";
                break;
            case 2:  
                 $cantidadAlarma = "Detección voltaje bajo";
                break;
            case 4:  
                 $cantidadAlarma = "Reset por reloj";
                break;
            case 8:  
                 $cantidadAlarma = "Reset por DBG";
                 break;
            case 16:  
                 $cantidadAlarma = "Reset por I2C";
                 break;
            case 32:  
                 $cantidadAlarma = "Reset por Watch Dog";
                 break;     
            case 64:  
                 $cantidadAlarma = "Reset por PIN";
                 break; 
            case 130:  
                 $cantidadAlarma = "Reset por Power";
                 break;     
        }
    }
    if($codigo == 10){ // Evalua si la alarma es de escritura de datos
        switch($cantidad){
        	case 1:
                $cantidadAlarma = "Placa";
                break;
            case 16:
                $cantidadAlarma = "Registros de conteo";
                break;
            case 7:
                $cantidadAlarma = "Numero de puertas";
                break;
            case 2:
                $cantidadAlarma = "Volumen y audio";
                break;
            case 5:
                $cantidadAlarma = "Descuento";
                break;
            case 10:
                $cantidadAlarma = "Trama GPS";
                break;     
            case 12:
                $cantidadAlarma = "Trama WIFI";
                break;     
            case 15:
                $cantidadAlarma = "Sentido";
                break;
            case 22:
                $cantidadAlarma = "Ip servidor";
                break;
            case 23:
                $cantidadAlarma = "Puerto servidor";
                break;
			case 25:
                $cantidadAlarma = "Permisos alarmas";
                break;		
            case 29:
                $cantidadAlarma = "Hora del sistema";
                break;
            case 31:
            	$cantidadAlarma = "UTC";
            	break; 
            case 32:
            	$cantidadAlarma = "Limite de velocidad";
            	break;
			case 41:
            	$cantidadAlarma = "Permisos de alarmas aplicados";
            	break;			
            
        }
        
    }
    if($codigo == 17){ // Evalua la alarma GPS sin conexión
        switch($cantidad){
        	case 1:
                $cantidadAlarma = "Sin cobertura";
                break;
            case 2:
                $cantidadAlarma = "Sin conexión";
                break;    
        }
    }
    return $cantidadAlarma;
}

function listadoAlarmas($codigo){
	switch ($codigo) {
	case 12:
            $codigoAlarma = "Reset de sistema";
            break;
        case 13:
            $codigoAlarma = "Reinicio preventivo";
            break;
        case 4:
            $codigoAlarma = "Tapa caja abierta";
            break;    
        case 5:
            $codigoAlarma = "Sensor Bloqueado BQ1";
            break;
        case 6:
            $codigoAlarma = "Sensor Bloqueado BQ2";
            break;
        case 8:
            $codigoAlarma = "Sistema antiagache";
            break;
        case 9:
            $codigoAlarma = "Sistema antisalto";
            break;
        case 3:
            $codigoAlarma = "Sensor obstruido";
            break;
        case 1:
            $codigoAlarma = "Corto circuito";
            break;    
        case 2:
            $codigoAlarma = "Fuente principal desconectada";
            break;
        case 16:
            $codigoAlarma = "Antipuerta activo";
            break;    
        case 17:
            $codigoAlarma = "GPS";
            break;
        case 18:
            $codigoAlarma = "Sistema hibernando";
            break;    
        case 19:
        	$codigoAlarma = "Fuente principal conectada";
        	break;      
        case 50:
            $codigoAlarma = "Error en I2C";
            break; 
        case 51:
            $codigoAlarma = "Reinicio de aplicación";
            break;
        case 52:
        	$codigoAlarma = "Error puerto serial";
        break;  
        case 53:
        	$codigoAlarma = "Configuración WIFI recuperada";
        break; 
        case 54:
        	$codigoAlarma = "Error en WIFI";
        break;   
        case 10:
            $codigoAlarma = "Escritura de datos";
            break;        
        default:
            $codigoAlarma = "Cadena no asignada ".$codigo;
            break;
	}
	return $codigoAlarma;
}

function mostrarHistorico(){
	try{
	$midb = conexionLocalSQLite3();
	$midb->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
	//Obtiene el numero de filas de la tabla
	$nRows = $midb->query('SELECT COUNT(*) FROM tablaHistoricos')->fetchColumn(); 
	
	$results = $midb->prepare('SELECT * FROM tablaHistoricos ORDER BY fecha_ingreso DESC'); 
	$results->setFetchMode(PDO::FETCH_ASSOC);
	$results->execute();
	if($results){
		/*Inicia paginación*/
		$regXPag = 8;
		$pagina = false;

		//Examniar la url de la pagina 
		if(isset($_GET["pageAct"])){ // Pregunta por url si la variable $p ya esta incializada
			$pagina = $_GET["pageAct"];
		}
		if(!$pagina){ // Este condicional es verdadero cuado se carga incialmente la pagina web
			$inicio = 0;
			$pagina = 1;
		}else{
			$inicio = ($pagina-1) * $regXPag;
		}
		$sql = "SELECT * FROM tablaHistoricos ORDER BY fecha_ingreso DESC LIMIT ".$regXPag." OFFSET ".$inicio;
		$results = $midb->prepare($sql); 
		$results->setFetchMode(PDO::FETCH_ASSOC);
		$results->execute();
		//La función ceil lleva un fraccionario a su entero inmediatamente superior
		$totalPaginas = ceil($nRows/$regXPag);
		$paginacion = "<div class='paginacion'";
		$paginacion .= "<p>";
		$paginacion .= "Numero de resultados: <b>$nRows</b> ";
		$paginacion .= "Mostrando <b>$regXPag</b> resultados por pagina. ";
		$paginacion .= "Página <b>$pagina</b> de <b>$totalPaginas</b>";
		$paginacion .= "</p>";
		//Construye los enalces a las diferentes paginas 
		if($totalPaginas>1){
			$paginacion .= "<p>";
				$paginacion .= ($pagina!=1)?"<a href='#' id='retrocede' data-id_pagina='".$pagina."'>&laquo</a>":"";
				//Condicional que solo permite crear 7 enlaces a las diferentes paginas  
				$inicioPaginaMostrar = 1;
				if($pagina<8) $totalPaginasMostar = 7;
				else{
					$inicioPaginaMostrar = $pagina;
					$totalPaginasMostar = $pagina+6;
					//Ajusta los enlaces para el ultimo bloque de paginas
					if($totalPaginasMostar >= $totalPaginas){
						$totalPaginasMostar = $totalPaginas;
					}
				}
				//////
				for($i=$inicioPaginaMostrar;$i<=$totalPaginasMostar;$i++){
					//Si muestro el indice de la pagina actual no muestro el enlace
					$actual = "<span class='actual'>$pagina</span>";
					$enlace = "<a href='#' class='paginaActual' data-id_pagina='".$i."'>$i</a>";
					$paginacion .= ($pagina == $i)?$actual:$enlace;
				}
				$paginacion .= ($pagina!=$totalPaginas)?"<a href='#' id='avanza' data-id_pagina='".$pagina."'>&raquo</a>":"";
			$paginacion .= "</p>";
		}
		$paginacion .= "</div>";
		/*Termina paginación */
		
		$tabla .= "<table id='idTablaHistoricos' class = 'tabla'>";
		$tabla .= "<thead><h2 id='tituloTabla'>Tabla de historicos";
		$tabla .= "<button type='button' id='idMostrarGrafico'>Grafico</button>";
		$tabla .= "</h2>";
			$tabla .= "<tr>";
				$tabla .= "<th>item</th>";
				$tabla .= "<th>Fecha historico</th>";
				$tabla .= "<th>Total pasajeros</th>";
				$tabla .= "<th>Fecha actualización</th>";
				$tabla .= "<th>Acción</th>";
			$tabla .= "</tr>";
		$tabla .= "</thead>";
		$tabla .= "<tbody>";
		$i = ($pagina-1)*8;
		$j=0;
		while($fila = $results->fetch()){
			//echo  "dato";
			$tabla .= "<tr>";
				++$i;
				$tabla .= "<td id='id_$j'>".$i."</td>";
				$tabla .= "<td id='idFecha_$j'>".$fila['fecha']."</td>";
				$tabla .= "<td id='idTotalDia_$j'>".$fila['total_dia']."</td>";
				$tabla .= "<td>".$fila["fecha_ingreso"]."</td>";
				$tabla .= "<td><a href='#' class='eliminar' data-id_historico='".$fila['id']."'>Eliminar</a></td>";
			$tabla .= "</tr>";
			$j++;
		}
		$tabla .= "</tbody>";		
		$tabla .= "</table>";
		$respuesta = $tabla.$paginacion;
	}else{
		//echo "No se cargo la tabla";
		$respuesta = "<div class= 'error'>Error: No se ejecuto la consulta a la base de datos</div>";
	}
	//Cierra la conexión con la base de datos
	$results = null;
	$midb = null;
	/*
	$form = '<div class="form-style-10">';
	$form .= '<h1>Consulta personalizada<span>Seleccione el rango de fechas!</span></h1>';
	$form .="<form id='idFormHistorico'>";
	$form .= '<div class="inner-wrap">';
			$form .= "<label for='fecha'>Fecha inicial:  <input type='date' id='idFechaInicial' required /><input type='time' value='00:00' id='idHoraInicial'></label>";
			$form .= "<label for='fecha'>  Fecha final:  <input type='date' id='idFechaFinal' required /><input type='time' value='23:59' id='idHoraFinal'></label>";
				$form .= "<input type='submit' id='idEnviarConsultaHistorico' value='Consultar conteos' />";
				$form .= "<input type='submit' id='idDescargarConteos' value='Descargar conteos' />";
				$form .= "<input type='submit' id='idDescargarHistoricos' value='Descargar historicos' />";
		$form .= "</div>";
	$form .= "</form>";
	$form .= "</div>";	
	*/
	return printf($form.$respuesta);
	}catch(PDOException $e) {
    	echo "Lo siento hay un error en BD..  ". $e->getMessage() ;// Remove or modify after testing 
    	file_put_contents('PDOErrors.txt',date('[Y-m-d H:i:s]').", myfile.php, ". $e->getMessage()."\r\n", FILE_APPEND);  
    }
}

function ConfigCamaraIp(){
    try{
		$midb = conexionLocalSQLite3();
		$midb->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
		$results = $midb->prepare('SELECT * FROM camarasIp'); 
		$results->setFetchMode(PDO::FETCH_ASSOC);
		$results->execute();
		if($results){
			$tabla  = "<table id='contadores' class = 'tabla'>";
			$tabla .= "<thead><h3 id='tituloTabla'>Registro de Cámaras</h3>";
				$tabla .= "<tr>";
					$tabla .= "<th>item</th>";
					$tabla .= "<th>ID Camara</th>";
					$tabla .= "<th>Descripción</th>";
					$tabla .= "<th>Acción</th>";
				$tabla .= "</tr>";
			$tabla .= "</thead>";
			$tabla .= "<tbody>";
			$i = 0;
			$idCamara = array();
			while($fila = $results->fetch()){
				$idCamara[] = $fila['idCamara']; //Registra las camaras que estan en base de datos
				$tabla .= "<tr>";
					++$i;
					$tabla .= "<td>".$i."</td>";
					$tabla .= "<td>".$fila['idCamara']."</td>";
					$tabla .= "<td>".$fila['nombre']."</td>";
					$tabla .= "<td><a href='#' class='eliminar' data-id_camara='".$fila['Primary_Key']."'>Eliminar</a></td>";
				$tabla .= "</tr>";
			}
			if(sizeof($idCamara) > 0){
				$encontrado = false;
				foreach($idCamara as $r){
					if($r == 'usb'){
						$encontrado = true;
						break;
					}
				}
				if($encontrado == false){
					++$i;
					$tabla .= "<tr>";
					$tabla .= "<td>".$i."</td>";
					$tabla .= "<td>usb</td>";
					$tabla .= "<td><input type='text' id='idDesCamarausb' name='desCamara_tx' value='Escribir aquí..'></td>";
					$tabla .= "<td><a href='#' class='registrar' data-id_camara='usb'>Registrar</a></td>";
					$tabla .= "</tr>";
				}
			}else{
				++$i;
				$tabla .= "<tr>";
				$tabla .= "<td>".$i."</td>";
				$tabla .= "<td>usb</td>";
				$tabla .= "<td><input type='text' id='idDesCamarausb' name='desCamara_tx' value='Escribir aquí..'></td>";
				$tabla .= "<td><a href='#' class='registrar' data-id_camara='usb'>Registrar</a></td>";
				$tabla .= "</tr>";
			}
			//Busca en la tabla de camaras IP las que estan reportando en el mini-pc
			exec('sudo ls /root/',$output,$error);
			foreach($output as $a){
				++$i;
				$encontrado = false;
				if(sizeof($a) > 0){
					foreach($idCamara as $b){
						if($a == $b){
							$encontrado = true;
							break;
						}
					}
				}
				if($encontrado == false){
					$tabla .= "<tr>";
					$tabla .= "<td>".$i."</td>";
					$tabla .= "<td>".$a."</td>";
					$tabla .= "<td><input type='text' id='idDesCamara$a' name='desCamara_tx' value='Escribir aquí..'></td>";
					$tabla .= "<td><a href='#' class='registrar' data-id_camara='".$a."'>Registrar</a></td>";
					$tabla .= "</tr>";
				}
			}
			
			$tabla .= "</tbody>";		
			$tabla .= "</table>";
			$respuesta = $tabla;
			
		}else{
			//echo "No se cargo la tabla";
			$respuesta = "<div class= 'error'>Error: No se ejecuto la consulta a la base de datos</div>";
		}
		//Cierra la conexión con la base de datos
		printf($respuesta);
		$results = null;
		$midb = null;
	}catch(PDOException $e) {
    	echo "Lo siento hay un error en BD..  ". $e->getMessage() ;// Remove or modify after testing 
    	file_put_contents('PDOErrors.txt',date('[Y-m-d H:i:s]').", vistas.php, ". $e->getMessage()."\r\n", FILE_APPEND);  
 	}
}


function registrarCamaraIp($idCamara,$desc){
	try{
		$sql = "INSERT INTO camarasIp (idCamara,nombre,estado) VALUES (:idCamara,:nombre,'1')";
		$midb = conexionLocalSQLite3();
		$midb->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
		$results = $midb->prepare($sql);
		$results->bindParam(':idCamara',$idCamara, PDO::PARAM_STR);
		$results->bindParam(':nombre',$desc, PDO::PARAM_STR);
		$results->execute();
		$respuesta = '';
		if($results){
			$respuesta .= "<div class='exito' data-recargar>Se insertó con exito la configuración de la camara</div>";
		}else{
			$respuesta .= "<div class='error' data-recargar>Ocurrio un error. No se insertó el registro</div>";
			$results = null;
			$midb = null;
			return printf($respuesta);
		}
		
		$sql = "DELETE FROM listadoVideos";
		$results = $midb->prepare($sql);
		$results->execute();
		if($results){
			$respuesta .= "<div class='exito' data-recargar>Se eliminó tabla de los videos</div>";
		}else{
			$respuesta .= "<div class='error' data-recargar>Ocurrio un error. No se eliminó la tabla videos</div>";
		}
		
	}catch(PDOException $e) {
    	echo "Lo siento hay un error.  ". $e->getMessage() ;// Remove or modify after testing 
    	file_put_contents('PDOErrors.txt',date('[Y-m-d H:i:s]').", vistas.php, ". $e->getMessage().$sql."\r\n", FILE_APPEND);  
 	}
 	
 	return printf($respuesta);
 	$results = null;
	$midb = null;
}
  
function mostrarTablaVideos(){
	try{
	$midb = conexionLocalSQLite3();
	$midb->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
	//Obtiene el numero de filas de la tabla
	$nRows = $midb->query('SELECT COUNT(*) FROM listadoVideos')->fetchColumn(); 
	
	$results = $midb->prepare('SELECT * FROM listadoVideos ORDER BY fecha DESC'); 
	$results->setFetchMode(PDO::FETCH_ASSOC);
	$results->execute();
	if($results){
		/*Inicia paginación*/
		$regXPag = 16;
		$pagina = false;

		//Examniar la url de la pagina 
		if(isset($_GET["pageAct"])){ // Pregunta por url si la variable $p ya esta incializada
			$pagina = $_GET["pageAct"];
		}
		if(!$pagina){ // Este condicional es verdadero cuado se carga incialmente la pagina web
			$inicio = 0;
			$pagina = 1;
		}else{
			$inicio = ($pagina-1) * $regXPag;
		}
		$sql = "SELECT * FROM listadoVideos ORDER BY fecha DESC LIMIT ".$regXPag." OFFSET ".$inicio;
		$results = $midb->prepare($sql); 
		$results->setFetchMode(PDO::FETCH_ASSOC);
		$results->execute();
		//La función ceil lleva un fraccionario a su entero inmediatamente superior
		$totalPaginas = ceil($nRows/$regXPag);
		$paginacion = "<div class='paginacion'";
		$paginacion .= "<p>";
		$paginacion .= "Numero de resultados: <b>$nRows</b> ";
		$paginacion .= "Mostrando <b>$regXPag</b> resultados por pagina. ";
		$paginacion .= "Página <b>$pagina</b> de <b>$totalPaginas</b>";
		$paginacion .= "</p>";
		//Construye los enalces a las diferentes paginas 
		if($totalPaginas>1){
			$paginacion .= "<p>";
				$paginacion .= ($pagina!=1)?"<a href='#' id='retrocede' data-id_pagina='".$pagina."'>&laquo</a>":"";
				//Condicional que solo permite crear 7 enlaces a las diferentes paginas  
				$inicioPaginaMostrar = 1;
				if($pagina<16) $totalPaginasMostar = 15;
				else{
					$inicioPaginaMostrar = $pagina;
					$totalPaginasMostar = $pagina+14;
					//Ajusta los enlaces para el ultimo bloque de paginas
					if($totalPaginasMostar >= $totalPaginas){
						$totalPaginasMostar = $totalPaginas;
					}
				}
				//////
				for($i=$inicioPaginaMostrar;$i<=$totalPaginasMostar;$i++){
					//Si muestro el indice de la pagina actual no muestro el enlace
					$actual = "<span class='actual'>$pagina</span>";
					$enlace = "<a href='#' class='paginaActual' data-id_pagina='".$i."'>$i</a>";
					$paginacion .= ($pagina == $i)?$actual:$enlace;
				}
				$paginacion .= ($pagina!=$totalPaginas)?"<a href='#' id='avanza' data-id_pagina='".$pagina."'>&raquo</a>":"";
			$paginacion .= "</p>";
		}
		$paginacion .= "</div>";
		/*Termina paginación */
		
		$tabla .= "<table id='idTablaVideos' class = 'tabla'>";
		$tabla .= "<thead><h2 id='tituloTabla'>Registro de videos";
		$tabla .= "</h2>";
			$tabla .= "<tr>";
				$tabla .= "<th>item</th>";
				$tabla .= "<th>Fecha video</th>";
				$tabla .= "<th>Descripción</th>";
				$tabla .= "<th>Acción</th>";
			$tabla .= "</tr>";
		$tabla .= "</thead>";
		$tabla .= "<tbody>";
		$i = ($pagina-1)*16;
		$j=0;
		while($fila = $results->fetch()){
			//echo  "dato";
			$tabla .= "<tr>";
				++$i;
				$tabla .= "<td id='id_$j'>".$i."</td>";
				$tabla .= "<td id='idFecha_$j'>".$fila['fecha']."</td>";
				$tabla .= "<td id='idNombre_$j'>".$fila['nombre']."</td>";
				$tabla .= "<td><a href='#' class='eliminar' data-id_video='".$fila['Primary_Key']."'>Eliminar</a>";
				$tabla .= "<a target='_blank' href='vistas.php?func=descargarVideo&ruta=".$fila['ruta']."'>    Descargar</a></td>";
			$tabla .= "</tr>";
			$j++;
		}
		$tabla .= "</tbody>";		
		$tabla .= "</table>";
		//$tabla .= "<iframe id='secretIFrame' src='' style='display:none; visibility:hidden;'></iframe>";
		$respuesta = $tabla.$paginacion;
	}else{
		//echo "No se cargo la tabla";
		$respuesta = "<div class= 'error'>Error: No se ejecuto la consulta a la base de datos</div>";
	}
	//Cierra la conexión con la base de datos
	$results = null;
	$midb = null;
	/*
	$form = '<div class="form-style-10">';
	$form .= '<h1>Consulta personalizada<span>Seleccione el rango de fechas!</span></h1>';
	$form .="<form id='idFormHistorico'>";
	$form .= '<div class="inner-wrap">';
			$form .= "<label for='fecha'>Fecha inicial:  <input type='date' id='idFechaInicial' required /><input type='time' value='00:00' id='idHoraInicial'></label>";
			$form .= "<label for='fecha'>  Fecha final:  <input type='date' id='idFechaFinal' required /><input type='time' value='23:59' id='idHoraFinal'></label>";
				$form .= "<input type='submit' id='idEnviarConsultaHistorico' value='Consultar conteos' />";
				$form .= "<input type='submit' id='idDescargarConteos' value='Descargar conteos' />";
				$form .= "<input type='submit' id='idDescargarHistoricos' value='Descargar historicos' />";
		$form .= "</div>";
	$form .= "</form>";
	$form .= "</div>";	
	*/
	return printf($respuesta);
	}catch(PDOException $e) {
    	echo "Lo siento hay un error en BD..  ". $e->getMessage() ;// Remove or modify after testing 
    	file_put_contents('PDOErrors.txt',date('[Y-m-d H:i:s]').", myfile.php, ". $e->getMessage()."\r\n", FILE_APPEND);  
    }
}


function mostrarValidaciones(){
	try{
	$midb = conexionLocalSQLite3();
	$midb->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
	//Obtiene el numero de filas de la tabla
	$nRows = $midb->query('SELECT COUNT(*) FROM tablaValidaciones')->fetchColumn(); 
	
	$results = $midb->prepare('SELECT * FROM tablaValidaciones ORDER BY fecha DESC'); 
	$results->setFetchMode(PDO::FETCH_ASSOC);
	$results->execute();
	if($results){
		/*Inicia paginación*/
		$regXPag = 20;
		$pagina = false;

		//Examniar la url de la pagina 
		if(isset($_GET["pageAct"])){ // Pregunta por url si la variable $p ya esta incializada
			$pagina = $_GET["pageAct"];

		}
		
		if(!$pagina){ // Este condicional es verdadero cuado se carga incialmente la pagina web
			$inicio = 0;
			$pagina = 1;
		}else{
			$inicio = ($pagina-1) * $regXPag;
		}
		$sql = "SELECT * FROM tablaValidaciones ORDER BY fecha DESC LIMIT ".$regXPag." OFFSET ".$inicio;
		$results = $midb->prepare($sql); 
		$results->setFetchMode(PDO::FETCH_ASSOC);
		$results->execute();
		//La función ceil lleva un fraccionario a su entero inmediatamente superior
		$totalPaginas = ceil($nRows/$regXPag);
		$paginacion = "<div class='paginacion'";
		$paginacion .= "<p>";
		$paginacion .= "Numero de resultados: <b>$nRows</b> ";
		$paginacion .= "Mostrando <b>$regXPag</b> resultados por pagina. ";
		$paginacion .= "Página <b>$pagina</b> de <b>$totalPaginas</b>";
		$paginacion .= "</p>";
		//Construye los enalces a las diferentes paginas 
		if($totalPaginas>1){
			$paginacion .= "<p>";
				$paginacion .= ($pagina!=1)?"<a href='#' id='retrocede' data-id_pagina='".$pagina."'>&laquo</a>":"";
				//Condicional que solo permite crear 7 enlaces a las diferentes paginas  
				$inicioPaginaMostrar = 1;
				if($pagina<8) $totalPaginasMostar = $totalPaginas;
				else{
					$inicioPaginaMostrar = $pagina;
					$totalPaginasMostar = $pagina+6;
					//Ajusta los enlaces para el ultimo bloque de paginas
					if($totalPaginasMostar >= $totalPaginas){
						$totalPaginasMostar = $totalPaginas;
					}
				}
				//////
				for($i=$inicioPaginaMostrar;$i<=$totalPaginasMostar;$i++){
					//Si muestro el indice de la pagina actual no muestro el enlace
					$actual = "<span class='actual'>$pagina</span>";
					$enlace = "<a href='#' class='paginaActual' data-id_pagina='".$i."'>$i</a>";
					$paginacion .= ($pagina == $i)?$actual:$enlace;
				}
				$paginacion .= ($pagina!=$totalPaginas)?"<a href='#' id='avanza' data-id_pagina='".$pagina."'>&raquo</a>":"";
			$paginacion .= "</p>";
		}
		$paginacion .= "</div>";
		/*Termina paginación */

		$tabla = "<table id='heroes' class = 'tabla'>";
		$tabla .= "<thead><h2 id='tituloTabla'>Tabla de validaciones</h2>";
			$tabla .= "<tr>";
				$tabla .= "<th>item</th>";
				$tabla .= "<th>UID</th>";
				$tabla .= "<th>Nombre</th>";
				$tabla .= "<th>Numero de documento</th>";
				$tabla .= "<th>Saldo</th>";
				$tabla .= "<th>Fecha</th>";
			$tabla .= "</tr>";
		$tabla .= "</thead>";
		$tabla .= "<tbody>";
		$i = ($pagina-1)*20;
		while($fila = $results->fetch()){
			//echo  "dato";
			$tabla .= "<tr>";
				$tabla .= "<td>".++$i."</td>";
				$tabla .= "<td>".$fila['uid']."</td>";
				$tabla .= "<td>".$fila['nombre']."</td>";
				$tabla .= "<td>".$fila["documento"]."</td>";
				$tabla .= "<td>".$fila["saldo"]."</td>";
				$tabla .= "<td>".$fila["fecha"]."</td>";
				//$tabla .= "<td><a href='#' class='eliminar' data-id_historico='".$fila['id']."'>Eliminar</a></td>";
			$tabla .= "</tr>";
		}
		$tabla .= "</tbody>";		
		$tabla .= "</table>";
		$respuesta = $tabla.$paginacion;
	}else{
		//echo "No se cargo la tabla";
		$respuesta = "<div class= 'error'>Error: No se ejecuto la consulta a la base de datos</div>";
	}
	//Cierra la conexión con la base de datos
	$results = null;
	$midb = null;
	return printf($respuesta);
	}catch(PDOException $e) {
    	echo "Lo siento hay un error en BD..  ". $e->getMessage() ;// Remove or modify after testing 
    	file_put_contents('PDOErrors.txt',date('[Y-m-d H:i:s]').", myfile.php, ". $e->getMessage()."\r\n", FILE_APPEND);  
 	}
}

function ajustarHora($var){
    //print_r("-Entro:".$var);
    $partes = explode(".", $var);
    $comando = 'sudo date --set "'.$partes[0].'-'.$partes[1].'-'.$partes[2].' '.$partes[3].':'.$partes[4].':'.$partes[5].'"';
    file_put_contents('ajustarHora.txt',date('[Y-m-d H:i:s]').", $comando, ".exec($comando)."\r\n", FILE_APPEND);
    exec('sudo pkill -9 -f OrangeWifi.jar');
    exec('sudo pkill -9 -f RV60.jar');
    exec('sudo java -jar /home/root/NetBeansProjects/OrangeWifi/dist/OrangeWifi.jar > /dev/null 2>/dev/null &');
    exec('sudo java -jar /home/root/NetBeansProjects/RV60_OrangePi/dist/RV60.jar > /dev/null 2>/dev/null &');
}

function mostrarContadores($firmware,$adjHora,$fechaHora){
    //print_r($adjHora);
    //print_r("-".$fechaHora);
    
    if($adjHora == 1 && strpos($firmware, 'F5') !== false) ajustarHora($fechaHora);
    
    try{
	$midb = conexionLocalSQLite3();
	$midb->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
	$results = $midb->prepare('SELECT * FROM REGISTROS_CONTEO'); 
	$results->setFetchMode(PDO::FETCH_ASSOC);
	$results->execute();
	if($results){
		do{
			$archivoGps = fopen("/var/www/html/RegislogWeb/variables/gps.txt", "r") or die("No se puede abrir el archivo!");
			$fileGps = fgets($archivoGps);
			fclose($archivoGps);
			$gps = explode(",", $fileGps);
		}while(count($gps) < 3);
		
                
                $hora = $gps[5];
		$compAplicacion = comprobarAplicacionJava();
		if($compAplicacion == 1){
			$cadena = 'FUNCIONANDO';
			$background = '#81F781';
		}else{
			$cadena = 'NO FUNCIONANDO';
			$background = '#FE2E2E';	
		}
		$tabla  = "<div id='statusAplicacionJava' STYLE='background-color:".$background."'>SISTEMA :".$cadena."</div>";
		$tabla .= "<table id='contadores' class = 'tabla'>";
		$tabla .= "<thead><h3 id='tituloTabla'>Tabla Contadores - Fecha: ".$hora."</h3>";
			$tabla .= "<tr>";
				$tabla .= "<th>item</th>";
				$tabla .= "<th>NUMERACION</th>";
				$tabla .= "<th>TOTAL DIA</th>";
				$tabla .= "<th>ENTRADAS</th>";
				$tabla .= "<th>SALIDAS</th>";
			$tabla .= "</tr>";
		$tabla .= "</thead>";
		$tabla .= "<tbody>";
		$i = 0;
		while($fila = $results->fetch()){
			$tabla .= "<tr>";
			    ++$i;
				$tabla .= "<td>".$i."</td>";
				$tabla .= "<td>".$fila['NUMERACION']."</td>";
				$tabla .= "<td>".$fila['TOTAL_DIA']."</td>";
				$tabla .= "<td>".$fila["ENTRADAS"]."</td>";
				$tabla .= "<td>".$fila["SALIDAS"]."</td>";
			$tabla .= "</tr>";
		}
		$tabla .= "</tbody>";		
		$tabla .= "</table>";
		//Tabla 4*4 de temperatura
		/*
		do{
			$archivoTemperatura = fopen("/var/www/html/RegislogWeb/variables/temperatura.txt", "r") or die("No se puede abrir el archivo!");
			$fileTemperatura = fgets($archivoTemperatura);
			fclose($archivoTemperatura);
			$Temperatura = explode(",", $fileTemperatura);
		}while(count($Temperatura) < 15);

		$tabla .= "<table id='temperatura' class = 'tabla'>";
		$tabla .= "<thead><h3 id='tituloTabla'>Tabla temperatura - Fecha: ".$hora."</h3>";
	
		$tabla .= "</thead>";
		$tabla .= "<tbody>";
		for($i=0;$i<4;$i++){
			$tabla .= "<tr>";
				if($Temperatura[($i*4)] > 500) $tabla .= "<td bgcolor='red'>".($Temperatura[($i*4)]-500)."</td>";
				else $tabla .= "<td>".$Temperatura[($i*4)]."</td>";
				if($Temperatura[($i*4)+1] > 500) $tabla .= "<td bgcolor='red'>".($Temperatura[($i*4)+1]-500)."</td>";
				else $tabla .= "<td>".$Temperatura[($i*4)+1]."</td>";
				if($Temperatura[($i*4)+2] > 500) $tabla .= "<td bgcolor='red'>".($Temperatura[($i*4)+2]-500)."</td>";
				else $tabla .= "<td>".$Temperatura[($i*4)+2]."</td>";
				if($Temperatura[($i*4)+3] > 500) $tabla .= "<td bgcolor='red'>".($Temperatura[($i*4)+3]-500)."</td>";
				else $tabla .= "<td>".$Temperatura[($i*4)+3]."</td>";

			$tabla .= "</tr>";
		}
		$tabla .= "</tbody>";		
		$tabla .= "</table>";
		*/
		$respuesta = $tabla.$paginacion;
	}else{
		//echo "No se cargo la tabla";
		$respuesta = "<div class= 'error'>Error: No se ejecuto la consulta a la base de datos</div>";
	}
	//Cierra la conexión con la base de datos
	$results = null;
	$midb = null;
        if(strpos($firmware, 'F5') !== false){ // Si es un equipo Regisbus gold
            return printf($respuesta."&".$hora);
        }else return printf($respuesta);
	}catch(PDOException $e) {
    	echo "Lo siento hay un error en BD..  ". $e->getMessage() ;// Remove or modify after testing 
    	file_put_contents('PDOErrors.txt',date('[Y-m-d H:i:s]').", myfile.php, ". $e->getMessage()."\r\n", FILE_APPEND);  
 	}
}

function mostrarSensores($firmware){
	$compAplicacion = comprobarAplicacionJava();
	if($compAplicacion == 0){
		$respuesta = "<div class= 'error'>Error: No se esta ejecutando la aplicación en Java</div>";
		return printf($respuesta);
	}
	do{
		$archivoSensores = fopen("/var/www/html/RegislogWeb/variables/sensores.txt", "r") or die("No se puede abrir el archivo!");
		$fileSensores = fgets($archivoSensores);
		fclose($archivoSensores);
		$sensores = explode(",", $fileSensores);
	}while(count($sensores) < 4);
	//print_r($sensores);
	if(strpos($firmware, 'F5') !== false || strpos($firmware, 'F8') !== false || strpos($firmware, 'F4') !== false){
		// Tabla equipos RV50
		$tabla = "<table id='sensores' class = 'tabla'>";
		$tabla .= "<thead><h2 id='tituloTabla'>Tabla Sensores</h2>";
			$tabla .= "<tr>";
				$tabla .= "<th>PTA</th>";
				$tabla .= "<th>S1</th>";
				$tabla .= "<th>S2</th>";
				$tabla .= "<th>S3</th>";
				$tabla .= "<th>S4</th>";
			$tabla .= "</tr>";
		$tabla .= "</thead>";
		$tabla .= "<tbody>";
		$j = 0;
		for($i =0; $i<4; $i++){
			$tabla .= "<tr>";
				$index = $i+$j;
				$tabla .= "<td>".$sensores[$index]."</td>";
				$j = $j+1;
				$index = $i+$j;
				$sx = $sensores[$index];
				if($sx == 0) $tabla .= "<td bgcolor='red'>".$sx."</td>";
				else $tabla .= "<td>".$sx."</td>";
				$j = $j+1;
				$index = $i+$j;
				$sx = $sensores[$index];
				if($sx == 0) $tabla .= "<td bgcolor='red'>".$sx."</td>";
				else $tabla .= "<td>".$sx."</td>";
				$j = $j+1;
				$index = $i+$j;
				$sx = $sensores[$index];
				if($sx == 0) $tabla .= "<td bgcolor='red'>".$sx."</td>";
				else $tabla .= "<td>".$sx."</td>";
				$j = $j+1;
				$index = $i+$j;
				$sx = $sensores[$index];
				if($sx == 0) $tabla .= "<td bgcolor='red'>".$sx."</td>";
				else $tabla .= "<td>".$sx."</td>";
			$tabla .= "</tr>";
		}
		$tabla .= "</tbody>";		
		$tabla .= "</table>";
	}else{
		//Tabla equipos Regiscenter include
		$tabla = "<table id='sensores' class = 'tabla'>";
		$tabla .= "<thead><h2 id='tituloTabla'>Tabla Sensores</h2>";
			$tabla .= "<tr>";
				
				$tabla .= "<th>S1</th>";
				$tabla .= "<th>S2</th>";
			
			$tabla .= "</tr>";
		$tabla .= "</thead>";
		$tabla .= "<tbody>";
		$j = 0;
		for($i =0; $i<2; $i++){
			$tabla .= "<tr>";

				$sx = $sensores[$i*2];
				if($sx == 0) $tabla .= "<td bgcolor='red'>".$sx."</td>";
				else $tabla .= "<td>".$sx."</td>";
				
				$sx = $sensores[($i*2)+1];
				if($sx == 0) $tabla .= "<td bgcolor='red'>".$sx."</td>";
				else $tabla .= "<td>".$sx."</td>";
				
			$tabla .= "</tr>";
		}
		$tabla .= "</tbody>";		
		$tabla .= "</table>";
	}
	$respuesta = $tabla;
	return printf($respuesta);
}

function mostrarLogSistema(){
	$row = exec('ls -ls /var/www/html/RegislogWeb/Logs/',$output,$error);
	$resultado = '<div>';
	if(count($output) > 1){
		$resultado .= '<button type="button" id="borrarLogs">Borrar logs</button>';
	}
	foreach($output as $a){
		if(preg_match('/log/i',$a)){
			$arrLog = preg_split('/\s+/', $a);
			foreach ($arrLog as $b) {
				if(preg_match('/log/i',$b)){
					//print_r($arrLog);
					$resultado .= '<div>'.$b;
					$resultado .= "<a target='_blank' href='Logs/".clean($b)."'>    Descargar</a>";
					$resultado .= "</div>";
				}
			}
		}
	}
	$resultado .= '</div>';
	if($error){
		printf('<div>Error : '.$error.'</div>');
	exit;
	}
	return printf($resultado);
}

function mostrarVideos(){
    $row = exec('ls -t /var/www/html/RegislogWeb/videos/',$output,$error);
    $item = 1;
    if(count($output) > 1){
            $resultado .= '<button type="button" id="borrarVideos">Borrar videos</button>';
    }
    $tabla = "<table id='sistema' class = 'tabla'>";
        $tabla .= "<thead><h2 id='tituloTabla'>Videos disponibles ".count($output)."</h2>";
                $tabla .= "<tr>";
                        $tabla .= "<th>Item</th>";
                        $tabla .= "<th>Video de Alarma</th>";
                        $tabla .= "<th>Fecha</th>";
                        $tabla .= "<th>Acción</th>";
                $tabla .= "</tr>";
        $tabla .= "</thead>";
        $tabla .= "<tbody>";
        $regular = '(avi|mp4)';
        foreach($output as $a){
            //if(preg_match('/$regular/i',$a)){
                $arrLog = preg_split('/\s+/', $a);
				//print_r('resultado');
				//print_r($a);
                foreach ($arrLog as $b) {
                    //if(preg_match('/$regular/i',$b)){
                        $r = clean($b);
                        $partes = explode('-',$r);
                        $nombre = str_replace("1"," ",$partes[0]);
                        $tabla .= "<tr class ='$partes[1]$partes[2]$partes[3]'>";
                        $tabla .= "<td>".$item++."</td>";
                        $tabla .= "<td>$nombre</td>";
                        $tabla .= "<td class='rutaVideo'>$partes[1]/$partes[2]/$partes[3] $partes[4]:$partes[5]:".str_replace(".mp4","",$partes[6])."</td>";
                        $tabla .= '<td>';
                        $tabla .= "<a target='_blank' href='videos/".clean($b)."'>    Descargar</a>";
                        $tabla .= "</td>";
                        $tabla .= "</tr>";
                    //}
                }
            //}
        }
        $tabla .= "</tbody>";		
    $tabla .= "</table>";
    $filtro = "<div id = 'idFiltro' class = 'tabla'></div>";
    $respuesta = $filtro.$tabla;
    if($error){
            printf('<div>Error : '.$error.'</div>');
    exit;
    }
    return printf($respuesta);
}

function mostrarSistema($firmware){
	$compAplicacion = comprobarAplicacionJava();
	if($compAplicacion == 0){
		$respuesta = "<div class= 'error'>Error: No se esta ejecutando la aplicación en Java</div>";
		return printf($respuesta);
	}
	if(strpos($firmware, 'F5') !== false || strpos($firmware, 'F4') !== false || strpos($firmware, 'F8') !== false){
		do{
			$archivoVoltajes = fopen("/var/www/html/RegislogWeb/variables/voltajes.txt", "r") or die("No se puede abrir el archivo!");
			$fileVoltajes = fgets($archivoVoltajes);
			fclose($archivoVoltajes);
			$voltajes = explode(",", $fileVoltajes);
                        if(strpos($firmware, 'F5') !== false && $voltajes[0] == 0) $voltajes[0] = 1;
                        else if(strpos($firmware, 'F5') !== false && $voltajes[0] == 1) $voltajes[0] = 0;
		}while(count($voltajes) < 3);
		$tabla = "<table id='sistema' class = 'tabla'>";
		$tabla .= "<thead><h2 id='tituloTabla'>Tabla Sistema</h2>";
			$tabla .= "<tr>";
				$tabla .= "<th>Suiche</th>";
				$tabla .= "<th>Volt. Batería</th>";
				$tabla .= "<th>Volt. Alimentación</th>";
				$tabla .= "<th>Volt. Sensores</th>";
			$tabla .= "</tr>";
		$tabla .= "</thead>";
		$tabla .= "<tbody>";
		
		$tabla .= "<tr>";
			$sx = $voltajes[0];
			if($sx == 0) $tabla .= "<td bgcolor='red'>Abierta</td>";
			else $tabla .= "<td>Cerrado</td>";
			$sx = $voltajes[1];
			if(strpos($firmware, 'F8') !== false) $sx = (25/10)*($sx/255)*3.3;
			else $sx = (20/10)*($sx/255)*5;
			$sx = number_format($sx, 2, '.', '');
			if($sx == 0) $tabla .= "<td bgcolor='red'>".$sx."</td>";
			else $tabla .= "<td>".$sx."</td>";
			$sx = $voltajes[2];
			if(strpos($firmware, 'F8') !== false) $sx = 1.6+(112/12)*($sx/255)*3.3;
			else $sx = (13.3/3.3)*($sx/255)*5;
			$sx = number_format($sx, 2, '.', '');
			if($sx == 0) $tabla .= "<td bgcolor='red'>".$sx."</td>";
			else $tabla .= "<td>".$sx."</td>";
			$sx = $voltajes[3];
			if(strpos($firmware, 'F8') !== false) $sx = (2.5/1.5)*($sx/255)*3.3;
			else  $sx = (12.2/10)*($sx/255)*5;
			$sx = number_format($sx, 2, '.', '');
			if($sx < 2.5) $tabla .= "<td bgcolor='red'>".$sx."</td>";
			else $tabla .= "<td>".$sx."</td>";
		$tabla .= "</tr>";
		
		$tabla .= "</tbody>";		
		$tabla .= "</table>";
		$respuesta = $tabla;


		return printf($respuesta);
	}
}

function mostrarGps(){
	do{
		$archivoRuta = fopen("/var/www/html/RegislogWeb/variables/estado_ruta.txt", "r") or die("No se puede abrir el archivo!");
		$fileRuta = fgets($archivoRuta);
		fclose($archivoRuta);
		$Ruta = explode(",", $fileRuta);
	}while(count($Ruta) < 3);
	
	$tablaRuta = "<table id='gpsRuta' class = 'tabla'>";
	$tablaRuta .= "<thead><h2 id='tituloTabla'>RUTA</h2>";
			$tablaRuta .= "<tr>";
				$tablaRuta .= "<th>Estado</th>";
				$tablaRuta .= "<th>PUNTOS RECIBIDOS</th>";
				$tablaRuta .= "<th>TOTAL DE PUNTOS</th>";
				$tablaRuta .= "<th>RUTA</th>";
			$tablaRuta .= "</tr>";
		$tablaRuta .= "</thead>";
		$tablaRuta .= "<tbody>";
		$tablaRuta .= "<tr>";
			if($Ruta[0] == 1) $estado = 'Recibiendo desde el servidor';
			if($Ruta[0] == 2) $estado = 'Ruta procesada';
			$tablaRuta .= "<td>".$estado."</td>";
			$tablaRuta .= "<td>".$Ruta[1]."</td>";
			$tablaRuta .= "<td>".$Ruta[2]."</td>";
			$tablaRuta .= "<td>".$Ruta[3]."</td>";
		$tablaRuta .= "</tr>";
		$tablaRuta .= "</tbody>";		
	$tablaRuta .= "</table>";
	do{
		$archivoGps = fopen("/var/www/html/RegislogWeb/variables/gps.txt", "r") or die("No se puede abrir el archivo!");
		$fileGps = fgets($archivoGps);
		fclose($archivoGps);
		$gps = explode(",", $fileGps);
	}while(count($gps) < 3);
	//print_r($gps);
	$tabla = "<table id='gps' class = 'tabla'>";
		if($gps[7] == 1)
		$tabla .= "<thead><h2 id='tituloTabla'>ESTADO GPS CELLOCATOR</h2>";
		if($gps[7] == 2)
		$tabla .= "<thead><h2 id='tituloTabla'>ESTADO GPS ST300R</h2>";
			$tabla .= "<tr>";
				$tabla .= "<th>LATITUD</th>";
				$tabla .= "<th>LONGITUD</th>";
				$tabla .= "<th>ID GPS</th>";
				if($gps[7] == 1)
					$tabla .= "<th>BUFFER</th>";
				$tabla .= "<th>SUICHE</th>";
			$tabla .= "</tr>";
		$tabla .= "</thead>";
		$tabla .= "<tbody>";
		$latitud = 0;
		$longitud = 0;
		
		$tabla .= "<tr>";
			$tabla .= "<td>".$gps[0]."</td>";
			$latitud = $gps[0];
			$tabla .= "<td>".$gps[1]."</td>";
			$longitud = $gps[1];
			$tabla .= "<td>".$gps[2]."</td>";
			if($gps[7] == 1)
				$tabla .= "<td>".$gps[3]."</td>";
			$tabla .= "<td>";
			if($gps[8] == 1){
				$tabla .=   	'<div class="led-green"></div>';	    
			}else $tabla .=   	'<div class="led-red"></div>';
			$tabla .= "</td>";
		$tabla .= "</tr>";
		
		$tabla .= "</tbody>";		
	$tabla .= "</table>";

	/*
	$tabla .= "<form action='upload.php' method='post' enctype='multipart/form-data'>";
	    $tabla .= "Cargar puntos de control";
	    $tabla .= "<input type='file' name='fileToUpload' id='fileToUpload'>";
	    $tabla .= "<input type='submit' value='Subir puntos' name='submit'>";
	$tabla .= "</form>";
	*/
	try{
		//Carga los puntos de control almacenados
		$midb = conexionLocalSQLite3();
		$midb->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
		$results = $midb->prepare('SELECT * FROM tablaRuta'); 
		$results->setFetchMode(PDO::FETCH_ASSOC);
		$results->execute();
		if($results){
			$tabla .= "<table id='ruta' class = 'tabla'>";
			$tabla .= "<thead><h2 id='tituloTabla'>Puntos de control</h2>";
				$tabla .= "<tr>";
					$tabla .= "<th>CODIGO</th>";
					$tabla .= "<th>LATITUD</th>";
					$tabla .= "<th>LONGITUD</th>";
					$tabla .= "<th>RADIO</th>";
					$tabla .= "<th>DIRECCION</th>";
					$tabla .= "<th>TIEMPO BASE</th>";
					$tabla .= "<th>DISTANCIA BASE</th>";
				$tabla .= "</tr>";
			$tabla .= "</thead>";
			$tabla .= "<tbody>";
			while($response = $results->fetch()){
				$tabla .= "<tr>";
					$tabla .= "<td>".$response['codigo']."</td>";
					$tabla .= "<td>".$response['latitud']."</td>";
					$tabla .= "<td>".$response['longitud']."</td>";
					$tabla .= "<td>".$response['radio']."</td>";
					$tabla .= "<td>".$response['direccion']."</td>";
					$tabla .= "<td>".$response['tiempoBase']."</td>";
					$tabla .= "<td>".$response['distanciaBase']."</td>";
				$tabla .= "</tr>";
			}
			$tabla .= "</tbody>";		
			$tabla .= "</table>";
			//echo $tabla;
			//$respuesta = $tabla."&coordenadas:".$latitud."&".$longitud;
			
		}
	}catch(PDOException $e) {
    	echo "Lo siento hay un error en BD..  ". $e->getMessage() ;// Remove or modify after testing 
    	file_put_contents('PDOErrors.txt',date('[Y-m-d H:i:s]').", myfile.php, ". $e->getMessage()."\r\n", FILE_APPEND);  
 	}

 	$respuesta = $tablaRuta.$tabla."coordenadas:".$latitud.",".$longitud;
 	//echo "&coordenadas:".$latitud;
	return printf($respuesta);
}

function infoSistema(){
	exec('df -h',$return);
	$disk = array();
	$i = 0;

	foreach($return as $a){

		if(preg_match('/root/i',$a) || preg_match('/mmc/i',$a)){
			//print_r("a:".$a);
			preg_match_all('/(?:\d*\.)?\d+/',$a,$c);
			
			for($i=0;$i<5;$i++) $disk[$i] = $c[0][$i];	
			print_r($disk);	
			if($disk[4] > 100) $disk[4] = $disk[4]/1000;
			$resultado = "Uso disco,".$disk[2]."+".$disk[3]."+".$disk[4]."+";
			$resultado = str_replace("/", "", $resultado);
		}
	}
	
	//print_r($resultado); 

	exec('free',$return);
	$men = array();
	$i = 0;
	foreach($return as $a){
		if(preg_match('/Mem:/i',$a)){
			$result = explode("      ",$a);
			foreach($result as $b){
				$men[$i] = $b;
				//echo 'Memoria:'.$men[$i];
				$i++;
			}
		}
	}
	exec('mpstat',$return);
	$cpu = array();
	$i = 0;
	foreach($return as $a){
		if(preg_match('/all/i',$a)){
			$result = explode("   ",$a);
			foreach($result as $b){
				$cpu[$i] = $b;
				//echo 'CPU:'.$cpu[$i];
				$i++;
			}
		}
	}

	exec('sudo cat /sys/devices/virtual/thermal/thermal_zone0/temp',$res);
	//print_r($res);
	
	$temperatura = $res[0]/1000;
	//print_r($temperatura);
	/*
	foreach($res as $a){
		if(preg_match('/temp:/i',$a)){
			$tpr = preg_split('/\s\s+/', $a);
			print_r($tpr);
			$temperatura = clean($tpr[1]);
		}
	}
	/*
	exec('sudo sensors',$res);
	//print_r($res);
	foreach($res as $a){
		if(preg_match('/temp1/i',$a)){

			$tpr = preg_split('/:/', $a);
			//print_r($tpr);
			$temperatura = clean($tpr[1]);
			//print_r($temperatura);
			//$temperatura = clean($temperatura);
		}
	}*/
	$resultado .= $men[1]."+".$men[2]."+".$men[3]."+".$men[4]."+".$men[5]."+".$men[6]."+".$cpu[11]."+".$temperatura."+";
	
	//echo "resultado: ".$resultado;
	return printf($resultado);
}

function wifiStatus(){
	exec('ifconfig wlan0',$return);
		exec('iwconfig wlan0',$return);
		$strWlan0 = implode(" ",$return);
		$strWlan0 = preg_replace('/\s\s+/', ' ', $strWlan0);
		preg_match('/HWaddr ([0-9a-f:]+)/i',$strWlan0,$result);
		if(count($result)==0){
			preg_match('/ether ([0-9a-f:]+)/i',$strWlan0,$result);
		}
		$strHWAddress = $result[1];
		preg_match('/inet addr:([0-9.]+)/i',$strWlan0,$result);
		if(count($result)==0){
			preg_match('/inet ([0-9.]+)/i',$strWlan0,$result);
		}
		$strIPAddress = $result[1];
		preg_match('/Mask:([0-9.]+)/i',$strWlan0,$result);
		if(count($result)==0){
			preg_match('/netmask ([0-9.]+)/i',$strWlan0,$result);
		}
		$strNetMask = $result[1];
		preg_match('/RX packets:(\d+)/',$strWlan0,$result);
		if(count($result)==0){
			preg_match('/RX packets (\d+)/',$strWlan0,$result);
		}
		$strRxPackets = $result[1];
		preg_match('/TX packets:(\d+)/',$strWlan0,$result);
		if(count($result)==0){
			preg_match('/TX packets (\d+)/',$strWlan0,$result);
		}
		$strTxPackets = $result[1];
		preg_match('/RX Bytes:(\d+ \(\d+.\d+ MiB\))/i',$strWlan0,$result);
		if(count($result)==0){
			preg_match('/RX packets '.$strRxPackets.' bytes (\d+)/',$strWlan0,$result);
		}
		$strRxBytes = $result[1];
		preg_match('/TX Bytes:(\d+ \(\d+.\d+ [K|M|G]iB\))/i',$strWlan0,$result);
		if(count($result)==0){
			preg_match('/TX packets '.$strTxPackets.' bytes (\d+)/',$strWlan0,$result);
		}
		$strTxBytes = $result[1];
		preg_match('/ESSID:\"([a-zA-Z0-9\s]+)\"/i',$strWlan0,$result);
		$strSSID = str_replace('"','',$result[1]);
		preg_match('/Access Point: ([0-9a-f:]+)/i',$strWlan0,$result);
		$strBSSID = $result[1];
		preg_match('/Sensitivity:([0-9]+\/[0-9]+)/i',$strWlan0,$result);
		$strTxPower = $result[1];
		preg_match('/Link Quality=([0-9]+\/[0-9]+)/i',$strWlan0,$result);
		$strLinkQuality = $result[1];
		preg_match('/Signal level=([0-9]+\/[0-9]+)/i',$strWlan0,$result);
		$strSignalLevel = $result[1];
		if(strpos($strWlan0, "UP") !== false && strpos($strWlan0, "RUNNING") !== false) {
			$strStatus = '<span style="color:green">Interface is up</span>';
		} else {
			$strStatus = '<span style="color:red">Interface is down</span>';
		}

		exec('ifconfig eth0',$resultado);
		foreach($resultado as $b){
			if(preg_match('/ether/i',$b)){
				$arrmask = preg_split('/\s+/', $b);
				$mask_eth0[] = $arrmask[1];
			}
		}
		//print_r($arrmask);
	return '<div class="infobox">
				<div class="infoheader">Información y estadísitica Wireless</div>
				<div id="intinfo"><div class="intheader">Información de la interface</div>
				Interface Name : wlan0<br />
				Interface Status : ' . $strStatus . '<br />
				IP Address : ' . $strIPAddress . '<br />
				Subnet Mask : ' . $strNetMask . '<br />
				Mac Address WIFI: ' . $strHWAddress . '<br />
				Mac Address ETH0: ' . $arrmask[2] . '<br />
				<div class="intheader">Interface Statistics</div>
				Received Packets : ' . $strRxPackets . '<br />
				Received Bytes : ' . $strRxBytes . '<br /><br />
				Transferred Packets : ' . $strTxPackets . '<br />
				Transferred Bytes : ' . $strTxBytes . '<br />
				</div>
			<div id="wifiinfo">
				<div class="intheader">Wireless Information</div>
					Connected To : ' . $strSSID . '<br />
					AP Mac Address : ' . $strBSSID . '<br />
					Sensivitivity : ' . $strTxPower .'<br />
					Link Quality : ' . $strLinkQuality . '<br />
					Signal Level : ' . $strSignalLevel . '<br />
				</div>
			</div>';
}

function comprobarAplicacionJava(){
	$address = '127.0.0.1';
	$port = 65535;

	if (($sock = socket_create(AF_INET, SOCK_STREAM, SOL_TCP)) === false) {
	    //echo "socket_create() falló: razón: " . socket_strerror(socket_last_error()) . "\n";
	    socket_shutdown($sock, 2);
	    return 1;
	}

	if (socket_bind($sock, $address, $port) === false) {
	    //echo "socket_bind() falló: razón: " . socket_strerror(socket_last_error($sock)) . "\n";
	    socket_shutdown($sock, 2);
	    return 1;
	}

	if (socket_listen($sock, 5) === false) {
	    //echo "socket_listen() falló: razón: " . socket_strerror(socket_last_error($sock)) . "\n";
	    socket_shutdown($sock, 2);
	    return 1;
	}
	socket_shutdown($sock, 2);
	return 0;
}

function mostrarConfiguracion($firmware){
    
	$compAplicacion = comprobarAplicacionJava();
	try{
		$midb = conexionLocalSQLite3();
		$midb->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
		$results = $midb->prepare('SELECT * FROM tablaConfiguracion'); 
		$results->setFetchMode(PDO::FETCH_ASSOC);
		$results->execute();
		while($fila = $results->fetch()){
			$form = '<div class="form-style-10">';
			$form .= '<h1>Configuración del sistema<span>Modifique los datos de la configuración!</span></h1>';
			$form .="<form id='alta-configuracion' class='formulario' data-insertarConfiguracion>";
			$form .= '<div class="inner-wrap">';;
				$form .= "<div>";
					$valor = $fila['numero_puertas']; 
					$form .= "<label for='numero_puertas'>Numero de puertas:</label>";
					$form .= "<select name='numero_puertas_tx' type='text' id='numero_puertas' >";
						$valor = $fila['numero_puertas']; 
						if(!strcmp("1", $valor)) $form .= "<option value='1' selected >1</option>";
						else $form .= "<option value='1'>1</option>";
						if(!strcmp("2", $valor)) $form .= "<option value='2' selected >2</option>";
						else $form .= "<option value='2'>2</option>";
					$form .= "</select>";
					//$form .= "<input type='text' id='numero_puertas' name='numero_puertas_tx' value=".$fila['numero_puertas'].">";
				$form .= "</div>";
				
				$form .= "<label for='ip_servidor'>IP Servidor: <input type='text' id='ip_servidor' name='ip_servidor_tx' value=".$fila['ip_servidor']."></label>";
				
				$form .= "<label for='puerto_servidor'>Puerto Servidor: <input type='text' id='puerto_servidor' name='puerto_servidor_tx' value=".$fila['puerto_servidor']."></label>";
						
					
				$form .= "<label for='firmware'>Versión app: <input type='text' id='firmware' name='firmware_tx' value=".$fila['firmware']."></label>";
						
				$form .= "<label for='firmware_contador'>Firmware contador: <input type='text' id='firmware_contador' name='firmware_contador_tx' value=".$fila['firmware_contador']."></label>";

					$form .= "<div>";
						$firmware = $fila['firmware_contador'];
						$form .= "<label for='sentido'>Sentido de conteo:</label>";
						$form .= "<select name='sentido_tx' type='text' id='sentido' >";
						$valor = $fila['sentido'];
						//Pregunta si es Regiscenter estadistico
						if(strpos($firmware,"F2") !== false){
							if(!strcmp("0", $valor)) $form .= "<option value='0' selected >0</option>";
							else $form .= "<option value='0'>0</option>";
							if(!strcmp("1", $valor)) $form .= "<option value='1' selected >1</option>";
							else $form .= "<option value='1'>1</option>";
						}else{
							 
							if(!strcmp("00", $valor)) $form .= "<option value='00' selected >00</option>";
							else $form .= "<option value='00'>00</option>";
							if(!strcmp("01", $valor)) $form .= "<option value='01' selected >01</option>";
							else $form .= "<option value='01'>01</option>";
							if(!strcmp("10", $valor)) $form .= "<option value='10' selected >10</option>";
							else $form .= "<option value='10'>10</option>";
							if(!strcmp("11", $valor)) $form .= "<option value='11' selected >11</option>";
							else $form .= "<option value='11'>11</option>";
						}
						$form .= "</select>";
					$form .= "</div>";

					if(strpos($firmware,"F5") !== false || strpos($firmware,"F8") !== false){
						$form .= "<div>";
							$form .= "<label for='descuento'>Descuento:</label>";
							$form .= "<select name='descuento_tx' type='text' id='descuento' >";
							$valor = $fila['descuento'];
							if(!strcmp("25", $valor) || !strcmp("1", $valor)) $form .= "<option value='25' selected >25</option>";
							else $form .= "<option value='25'>25</option>";
							if(!strcmp("50", $valor) || !strcmp("2", $valor)) $form .= "<option value='50' selected >50</option>";
							else $form .= "<option value='50'>50</option>";
							if(!strcmp("100", $valor) || !strcmp("3", $valor)) $form .= "<option value='100' selected >100</option>";
							else $form .= "<option value='100'>100</option>";
							$form .= "</select>";
						$form .= "</div>";
					}
					
					$form .= "<label for='placa'>Placa: <input type='text' id='placa' name='placa_tx' value=".$fila['placa']."></label>";
						
					
					$form .= "<label for='utc'>UTC: <input type='text' id='utc' name='utc_tx' value=".$fila['utc']."></label>";
						
					$form .= "<div>";
						$form .= "<label for='regisdata'>Regisdata:</label>";
						$regisdata = $fila['regisdata'];
						$form .= "<select name='regisdata_tx' type='text' id='regisdata' >";
							if(!strcmp("0", $regisdata)) $form .= "<option value='0' selected >SIN TRANSMITIR</option>";
							else $form .= "<option value='0'>SIN TRANSMITIR</option>";
							if(!strcmp("1", $regisdata)) $form .= "<option value='1' selected >REGISDATA COMERCIAL</option>";
							else $form .= "<option value='1'>REGISDATA COMERCIAL</option>";
						$form .= "</select>";
					$form .= "</div>";
                                       
					if(strpos($firmware,"F5") !== false || strpos($firmware,"F8") !== false){
						$form .= "<div>";
							$form .= "<label for='trama_gps'>Trama GPS:</label>";
							$trama_gps = $fila['trama_gps'];
							$form .= "<select name='trama_gps_tx' type='text' id='trama_gps' >";
								if(!strcmp("0", $trama_gps)) $form .= "<option value='0' selected >SIN TRAMA GPS</option>";
								else $form .= "<option value='0'>SIN TRAMA GPS</option>";
								if(!strcmp("1", $trama_gps)) $form .= "<option value='1' selected >CELLOCATOR</option>";
								else $form .= "<option value='1'>CELLOCATOR</option>";
								if(!strcmp("2", $trama_gps)) $form .= "<option value='2' selected >ST300R</option>";
								else $form .= "<option value='2'>ST300R</option>";
							$form .= "</select>";
						$form .= "</div>";
					}
					if(strpos($firmware,"F5") !== false || strpos($firmware,"F8") !== false){
						$form .= "<div>";
							$limiteVelocidad = $fila['limiteVelocidad'];
							$form .= "<label for='limiteVelocidad'>Limite velocidad:</label>";
							$form .= "<select name='limiteVelocidad_tx' type='text' id='limiteVelocidad' >";
								if(!strcmp("60", $limiteVelocidad)) $form .= "<option value='60' selected >60</option>";
								else $form .= "<option value='60'>60</option>";
								if(!strcmp("80", $limiteVelocidad)) $form .= "<option value='80' selected >80</option>";
								else $form .= "<option value='80'>80</option>";
								if(!strcmp("100", $limiteVelocidad)) $form .= "<option value='100' selected >100</option>";
								else $form .= "<option value='100'>100</option>";
							$form .= "</select>";
						$form .= "</div>";
					}
					if(strpos($firmware,"F5") !== false || strpos($firmware,"F8") !== false  || strpos($firmware,"F4") !== false){
						$form .= "<div>";
							$form .= "<label for='volumen'>Volumen:</label>";
							$volumen = $fila['volumen'];
							$form .= "<select name='volumen_tx' type='text' id='volumen' >";
								if(!strcmp("0", $volumen)) $form .= "<option value='0' selected >0</option>";
								else $form .= "<option value='0'>0</option>";
								if(!strcmp("25", $volumen)) $form .= "<option value='25' selected >25</option>";
								else $form .= "<option value='25'>25</option>";
								if(!strcmp("50", $volumen)) $form .= "<option value='50' selected >50</option>";
								else $form .= "<option value='50'>50</option>";
								if(!strcmp("75", $volumen)) $form .= "<option value='75' selected >75</option>";
								else $form .= "<option value='75'>75</option>";
								if(!strcmp("100", $volumen)) $form .= "<option value='100' selected >100</option>";
								else $form .= "<option value='100'>100</option>";
							$form .= "</select>";
						$form .= "</div>";
					}
					if(strpos($firmware,"F5") !== false){
						$form .= "<div>";
							$form .= "<label for='horaHibernacion'>Hora hibernación:<input type='time' id='horaHibernacion' name='horaHibernacion_tx' value=".$fila['horaHibernacion']."></label>";
							$form .= "<label for='duracionHibernacion'>Duración hibernación (mins):</label>";
							$duracion = $fila['duracionHibernacion'];
							$form .= "<select name='duracionHibernacion_tx' type='text' id='duracionHibernacion' >";
								if(!strcmp("0000", $duracion)) $form .= "<option value='0000' selected >0000</option>";
								else $form .= "<option value='0000'>0000</option>";
								if(!strcmp("0060", $duracion)) $form .= "<option value='0060' selected >0060</option>";
								else $form .= "<option value='0060'>0060</option>";
								if(!strcmp("0180", $duracion)) $form .= "<option value='0180' selected >0180</option>";
								else $form .= "<option value='0180'>0180</option>";
								if(!strcmp("0240", $duracion)) $form .= "<option value='0240' selected >0240</option>";
								else $form .= "<option value='0240'>0240</option>";
								if(!strcmp("0300", $duracion)) $form .= "<option value='0300' selected >0300</option>";
								else $form .= "<option value='0300'>0300</option>";
								if(!strcmp("0360", $duracion)) $form .= "<option value='0360' selected >0360</option>";
								else $form .= "<option value='0360'>0360</option>";
								if(!strcmp("0420", $duracion)) $form .= "<option value='0420' selected >0420</option>";
								else $form .= "<option value='0420'>0420</option>";
							$form .= "</select>";
						$form .= "</div>";
					}
					
					if(strpos($firmware,"F5") !== false || strpos($firmware,"F4") !== false){
						$valor = $fila['display'];
						if($valor != null){
							$form .= "<div>";
								$form .= "<label for='opcionesDisplay'>Opciones Display:</label>";
								$form .= "<select name='opcionesDisplay_tx' type='text' id='opcionesDisplay' >";
								
								if(!strcmp("0", $valor)) $form .= "<option value='0' selected >APAGADO</option>";
								else $form .= "<option value='0'>APAGADO</option>";
								if(!strcmp("1", $valor)) $form .= "<option value='1' selected >NUMERACION</option>";
								else $form .= "<option value='1'>NUMERACION</option>";
								if(!strcmp("2", $valor)) $form .= "<option value='2' selected >TOTAL DIA</option>";
								else $form .= "<option value='2'>TOTAL DIA</option>";
								if(!strcmp("3", $valor)) $form .= "<option value='3' selected >ENTRADAS</option>";
								else $form .= "<option value='3'>ENTRADAS</option>";
								if(!strcmp("4", $valor)) $form .= "<option value='4' selected >SALIDAS</option>";
								else $form .= "<option value='4'>SALIDAS</option>";
								$form .= "</select>";
							$form .= "</div>";
						}
					}
						
					$form .= "<label for='bd_id'>ID base de datos: <input type='text' id='bd_id' name='bd_id_tx' value=".$fila['bd_id']."></label>";
					
					$form .= "<div>";
						$form .= "<label for='borrarContadores'>Borrar contadores:</label>";
						$form .= "<select name='borrarContadores_tx' type='text' id='borrarContadores' >";
						$valor = $fila['borrar_contadores'];
						if(!strcmp("0", $valor)) $form .= "<option value='0' selected >NO</option>";
						else $form .= "<option value='0'>NO</option>";
						if(!strcmp("1", $valor)) $form .= "<option value='1' selected >SI</option>";
						else $form .= "<option value='1'>SI</option>";
						$form .= "</select>";
					$form .= "</div>";

					
					$valor = $fila['errorh'];
						if($valor == "3" || $compAplicacion == 0){
							$resultado .= "<input type='text' id='errorh' name='errorh_tx' STYLE='background-color:#FE2E2E' value='Sin conexión serial'>";
						}else if($valor == "0" && $compAplicacion == 1){
							$resultado .= "<input type='text' id='errorh' name='errorh_tx'  value='BUENA'>";
						}else if($valor == "1"){
							$resultado .= "<input type='text' id='errorh' name='errorh_tx' STYLE='background-color:#FE2E2E'  value='Error en I2C'>";
						}
						else $resultado .= "<input type='text' id='errorh' name='errorh_tx' value='Error sin identificar:".$valor."'>";
					$form .= "<label for='errorh'>Estado conexión: $resultado</label>";
						
					
					//Guardar configuración
					
						$form .= "<input type='submit' id='insertar-btn' name='insertar_btn' value='Guardar configuración' />";
						/*  Una entrada oculta para enviar los datos al controlador*/
						$form .= "<input type='hidden' id='transaccion' name='transaccion' value='insertarConfiguracion' />";
					
					
					
					
				$form .= "</div>";
			$form .= "</form>";
			$form .= "</div>";		
		}
		//Campo para la administración de base de datos
		
		$form .= '<div class="form-style-10">';
			$form .= "<fieldset>";
				$form .= "<legend>Administración de base de datos:</legend>";
				$form .= "<input type='button' id='borrarTablaAlarmas' name='borrarTablaAlarmasava_tx' value='Borrar tabla alarmas'>";
				$form .= "<input type='button' id='borrarTablaHistoricos' name='borrarTablaHistoricos_tx' value='Borrar tabla históricos'>";
			$form .= "</fieldset>";
		$form .= "</div>";
					
		// Campo de verificación aplicación JAVA
		
		$form .= '<div class="form-style-10">';
			
				
				$archivoVersion = fopen("/var/www/html/RegislogWeb/variables/version.txt", "r") or die("No se puede abrir el archivo!");
				$fileVersion = fgets($archivoVersion);
				fclose($archivoVersion);
				$Version = explode(";", $fileVersion);
				//print_r($Version);
				$Version = explode(',',$Version[(count($Version)-2)]);
				//print_r($Version);
				
				$form .= "<legend>Aplicación JAVA:  ".$Version[0]."  </legend>";
				//$form .= "<label for='aplicacionJava'>Aplicación JAVA:</label>";
				if($compAplicacion == 1){
					$cadena = 'FUNCIONANDO';
					$background = '#81F781';
				}else{
					$cadena = 'NO FUNCIONANDO';
					$background = '#FE2E2E';	
				}
				$form .= "<input type='text' id='aplicacionJava' name='aplicacionJava_tx' STYLE='background-color:".$background."' value='".$cadena."''>";
				if($compAplicacion == 0) $form .= "<input type='button' id='StartaplicacionJava' name='StartaplicacionJava_tx' value='Iniciar aplicación'>";
				else $form .= "<input type='button' id='StopaplicacionJava' name='StopaplicacionJava_tx' value='Detener aplicación'>";
			
		$form .= "</div>";
			
		$form .= "<button id='boton_reinicio' )'>Reiniciar sistema</button>";
		$form .= "<button id='boton_apagar' )'>Apagar sistema</button>";
	}catch(PDOException $e) {
    	echo "Lo siento hay un error en BD..  ". $e->getMessage() ;// Remove or modify after testing 
    	file_put_contents('PDOErrors.txt',date('[Y-m-d H:i:s]').", vistas.php, ". $e->getMessage()."\r\n", FILE_APPEND);  
 	}
 	$results = null;
	$midb = null;
	return printf($form);
}

function clean($string) {
   $string = str_replace(' ', '', $string); // Replaces all spaces with hyphens.

   return preg_replace('/[^A-Za-z0-9\-.]/', '', $string); // Removes special chars.
}
function mostrarWifi($so_board){
	$output = wifiStatus();
	$ssid = array();
	$psk = array();
	if(strcmp("sun8i", $so_board) !== false){ // Si el servidor es Orange Pi
		exec('sudo nmcli connection show',$resultado);
		foreach($resultado as $a) {
			if(preg_match('/wireless/i',$a)){
				$arrssid = preg_split('/\s+/', $a);
				$ssid[] = $arrssid[0];
				exec('sudo nmcli --show-secrets connection show '.$arrssid[0],$result);
				foreach($result as $b){
					if(preg_match('/.psk:/i',$b)){
						$arrspsk = preg_split('/\s+/', $b);
						$psk[] = $arrspsk[1];
					}
					if(preg_match('/ipv4.method:/i',$b)){
						$arrsDhcp = preg_split('/\s+/', $b);
						if(strcmp('auto', clean($arrsDhcp[1])) == 0)
							$ip_fija = 0;
						else $ip_fija = 1;
					}
					if(preg_match('/ipv4.addresses:/i',$b)){
						$arrsIpaddress = preg_split('/\s+/', $b);
						
						$tmp = explode("/", $arrsIpaddress[1]);
						$direccion = $tmp[0];
						switch (clean($tmp[1])) {
							case '8':
								$mascara = "255.0.0.0";
								break;
							case '16':
								$mascara = "255.255.0.0";
								break;
							case '24':
								$mascara = "255.255.255.0";
								break;
							case '32':
								$mascara = "255.255.255.255";
								break;
							case '64':
								$mascara = "255.255.255.255";
								break;	
						}
					}
					if(preg_match('/ipv4.gateway:/i',$b)){
						$arrsGateway = preg_split('/\s+/', $b);
						$gateway = $arrsGateway[1];
						$result = null;
						break;
					}
				}
			}	
		}
		
		$numSSIDs = count($ssid);
	}else{
		exec('sudo cat /etc/wpa_supplicant/wpa_supplicant.conf',$return);
		//print_r($return);
		foreach($return as $a) {
			if(preg_match('/ssid/i',$a)) {
				$arrssid = explode("=",$a);
				//print_r($arrssid);
				$ssid[] = str_replace('"','',$arrssid[1]);
				//print_r($ssid);
			}
			if(preg_match('/#psk/i',$a)) {
				$arrpsk = explode("=",$a);
				$psk[] = str_replace('"','',$arrpsk[1]);
			}
		}
		$numSSIDs = count($ssid);
		
		//Obtiene los datos de la configuración wifi
		exec('sudo cat /etc/network/interfaces',$resultado);
		$ip_fija = 0;
		$direccion = "192.168.2.20";
		$mascara = "255.255.255.0";
		$gateway = "192.168.2.1";
		foreach($resultado as $b) {
			if(preg_match('/address/i',$b)) {
				$ip_fija = 1;
				$resultado = explode("address ",$b); 
				$direccion = $resultado[1];
				//echo "Direccion: ".$direccion;
			}
			if(preg_match('/netmask/i',$b)) {
				$ip_fija = 1;
				$resultado = explode("netmask ",$b); 
				$mascara = $resultado[1];
				//echo "Mascara: ".$mascara;
			}
			if(preg_match('/gateway/i',$b)) {
				$ip_fija = 1;
				$resultado = explode("gateway ",$b); 
				$gateway = $resultado[1];
				//echo "Gateway: ".$gateway;
			}
		}
	}
	$output .= '<form id="wpa_conf_form">';
	$output .= '<fieldset class="infoheader">';
	$output .= '<legend>Redes almacenadas:</legend>';
		$output .= '<input type="hidden" id="Networks" name="Networks" value="'.$numSSIDs.'" />';
		$output .= '<div class="network" id="networkbox" align="left" data-valor="'.$numSSIDs.'">';
		for($ssids = 0; $ssids < $numSSIDs; $ssids++) {
			$output .= '<div id="networkbox'.$ssids.'" class="NetworkBoxes" >Red wifi '.$ssids;
				$output .= '<br>';
				$output .= 'SSID:<br>';
				$output .= '<input type="text" id="ssid0" name="ssid'.$ssids.'" value="'.$ssid[$ssids].'" />';
				$output .= '<br>';
				$output .= 'Clave:<br>';
				$output .= '<input type="text" id="psk0" name="psk'.$ssids.'" value="'.$psk[$ssids].'" />';
				$output .= '<br>';
				$output .= '<input type="button" value="Borrar" onClick="DeleteNetwork('.$ssids.')" />';
			$output .= '</div>';
			
		}
		$output .= '</div>';
		$output .= '<input type="button" value="Encontrar redes" name="Scan" id="scanWifi" />';
		//$output .= '<input type="button" value="Adicionar red" class="adicionarRed" />';
		$output .= '<input type="submit" value="Guardar" name="SaveWPAPSKSettings" id="Save" />';
		$output .= '</fieldset>';
			
		//Formulario para la configuración de la red wifi	
		$output .= '</form>';
		$output .= '<form id="ip_config_form">';
		$output .= '<fieldset class="infoheader">';
		$output .= '<legend>Configuración de red:</legend>';
			$output .= '<div class="network" id="ipConfigBox" align="left">';
			$output .= "<div>";
			$output .= "<label for='borrarContadores'>Configuración IP:</label>";
			$output .= "<select name='ip_config_tx' type='text' id='ip_config' >";
			if($ip_fija == 1){
				$output .= "<option value='ESTATICA' selected >ESTATICA</option>";
				$output .= "<option value='DINAMICA'>DINAMICA</option>";
			}else{
				$output .= "<option value='ESTATICA' >ESTATICA</option>";
				$output .= "<option value='DINAMICA' selected >DINAMICA</option>";
			}
			$output .= "</select>";
			$output .= '</div>';
			$output .= '<div id="lbdireccionIp" >Dirección IP:</div>';
			$output .= '<input type="text" id="direccionIp" name="direccionIp_tx" value="'.$direccion.'"/>';
			$output .= '<div id="lbmascarared" >Máscara de red:</div>';
			$output .= '<input type="text" id="mascarared" name="mascarared_tx" value="'.$mascara.'"/>';
			$output .= '<div id="lbgateway" >Gateway:</div>';
			$output .= '<input type="text" id="gateway" name="gateway_tx" value="'.$gateway.'"/>';
			if(strcmp("sun8i", $so_board) !== false) //Es servidor Orange
				$output .= "<input type='submit' id='ipconfig-btn' name='ipconfig_btn' value='Guardar configuración' style='display: none;' />";
			else
				$output .= "<input type='submit' id='ipconfig-btn' name='ipconfig_btn' value='Guardar configuración' />";
			$output .= '</div>';
			$output .= '</fieldset>';
		$output .= '</form>';
		
	return printf($output);
}
function conexionesWifi(){
	$wifiEstado = wifiStatus();
	try{
		//Carga las redes almacenadas en base de datos
		$midb = conexionLocalSQLite3();
		$midb->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
		$results = $midb->prepare('SELECT * FROM conexionesWifi'); 
		$results->setFetchMode(PDO::FETCH_ASSOC);
		$results->execute();
		if($results){
			$tabla .= "<table id='conexionesWifi' class = 'tabla'>";
			$tabla .= "<thead><tr><th colspan='9' >CONEXIONES WIFI</th></tr>";
				$tabla .= "<tr>";
					$tabla .= "<th>SSID</th>";
					$tabla .= "<th>CLAVE</th>";
					$tabla .= "<th>METODO</th>";
					$tabla .= "<th>TIPO</th>";
					$tabla .= "<th>IP</th>";
					$tabla .= "<th>MASCARA</th>";
					$tabla .= "<th>GATEWAY</th>";
					$tabla .= "<th>DNS</th>";
					$tabla .= "<th>ACCION</th>";
				$tabla .= "</tr>";
			$tabla .= "</thead>";
			$tabla .= "<tbody>";
			while($response = $results->fetch()){
				$tabla .= "<tr>";
					$tabla .= "<td>".$response['ssid']."</td>";
					$tabla .= "<td>".$response['clave']."</td>";
					$tabla .= "<td>".$response['metodo']."</td>";
					$tabla .= "<td>".$response['tipo']."</td>";
					$tabla .= "<td>".$response['ip']."</td>";
					$tabla .= "<td>".$response['mask']."</td>";
					$tabla .= "<td>".$response['gateway']."</td>";
					$tabla .= "<td>".$response['dns']."</td>";
					$tabla .= "<td><a href='#' class='eliminar' data-id_wifi='".$response['Primary_Key']."'>Eliminar</a>
					<a href='#' class='conectar' data-id_wifi='".$response['Primary_Key']."'>Conectar</a></td>";
				$tabla .= "</tr>";
			}
			$tabla .= "</tbody>";		
			$tabla .= "</table>";
			$tabla .= "<input type='submit' id='aplicarCambios-btn' name='aplicarCambios-btn' value='Aplicar cambios'/>";
				$output .= '</div>';
                                                        
			//$output .= '</form>';
			//Formulario para la configuración de la red wifi		
			$output .= '<div class="form-style-10">';
			$output .= '<h1>Nueva red<span>Ingrese los datos de conexión!</span></h1>';
			$output .= '<form id="ip_config_form">';
			$output .= '<div class="inner-wrap">';
				
				$output .= '<label>SSID <input type="text" id="ssid" name="ssid_tx"/></label>';
				$output .= '<label>Clave <input type="text" id="clave" name="clave_tx"/></label>';

				$output .= "<div>";
				$output .= "<label>Tipo:</label>";
				$output .= "<select name='tipo_tx' type='text' id='tipo' >";
					$output .= "<option value='Red_base' selected >RED BASE</option>";
					$output .= "<option value='Red_movil'>RED MOVIL</option>";
				$output .= "</select>";
				$output .= '</div>';

				$output .= "<div>";
				$output .= "<label>Conexión:</label>";
				$output .= "<select name='ip_config_tx' type='text' id='ip_config' >";
					$output .= "<option value='DINAMICA' selected >DINAMICA</option>";
					$output .= "<option value='ESTATICA'>ESTATICA</option>";
				$output .= "</select>";
				$output .= '</div>';

				$output .= "<div id='idIpEstatica'>";
					$output .= '<label>Dirección IP <input type="text" id="direccionIp" name="direccionIp_tx"/></label>';

					$output .= "<div>";
					$output .= "<label>Máscara de red:</label>";
					$output .= "<select name='mascarared_tx' type='text' id='mascarared_tx' >";
						$output .= "<option value='255.255.255.0' selected >255.255.255.0</option>";
						$output .= "<option value='255.255.0.0'>255.255.0.0</option>";
						$output .= "<option value='255.0.0.0'>255.0.0.0</option>";
					$output .= "</select>";
					$output .= '</div>';

					$output .= '<label>Gateway <input type="text" id="gateway" name="gateway_tx"/></label>';
					
					$output .= '<label>DNS <input type="text" id="dns" name="dns_tx"/></label>';

				$output .= '</div>';
				$output .= "<input type='submit' id='ipconfig-btn' name='ipconfig_btn' value='Guardar configuración'/>";
			$output .= '</div>';
			$output .= '<input type="button" value="Encontrar redes" name="Scan" id="scanWifi" />';
			$output .= '</form>';	
			$output .= '</div>';
		}
	}catch(PDOException $e) {
    	echo "Lo siento hay un error en BD..  ". $e->getMessage() ;// Remove or modify after testing 
    	file_put_contents('PDOErrors.txt',date('[Y-m-d H:i:s]').", myfile.php, ". $e->getMessage()."\r\n", FILE_APPEND);  
 	}
 	return printf($wifiEstado.$tabla.$output);
}

function guardarRedWifi($so_board,$ip_config,$ip,$mask,$gateway){
	print_r("Entro a guardarRedWifi ".$so_board);
	$networks = $_POST['Networks'];
	if(strcmp("sun8i", $so_board) !== false){ // Si el servidor es Orange Pi
		
		$ssid_a = array();

		//Obtiene las redes actuales del servidor
		exec('sudo nmcli connection show',$resultado);
		foreach($resultado as $a) {
			if(preg_match('/wireless/i',$a)){
				$arrssid = preg_split('/\s+/', $a);
				$ssid_a[] = escapeshellarg($arrssid[0]);
			}
		}
		$numSSIDs = count($ssid_a);
		print_r('numero de redes: '.$numSSIDs);
		for($x = 0; $x < $networks; $x++) {
			$ssid = escapeshellarg($_POST['ssid'.$x]);
			$psk = escapeshellarg($_POST['psk'.$x]);
			$red_existe = 0;
			print_r($ssid);
			for($i=0;$i<$numSSIDs;$i++){ //Compara las redes del servidor con las que el usuario quiere grabar
				if(strcmp($ssid, strval ($ssid_a[$i])) == 0) $red_existe = 1;
				//print_r($ssid_a[$i]);
				//print_r(strcmp($ssid, strval ($ssid_a[$i])));

			}
			//print_r('  red existe = '.$red_existe);
			//return;
			if($red_existe == false){ // Si al red no existe hay que crearla
				$comando = 'sudo nmcli c add type wifi con-name '.$ssid.' ifname wlan0 ssid '.$ssid;
				//print_r($comando);
				print_r(shell_exec($comando));
			}

			if(strcmp("ESTATICA", $ip_config) == 0){
				switch ($mask) {
					case '255.0.0.0':
						$mask = '8';
						break;
					case '255.255.0.0':
						$mask = '16';
						break;
					case '255.255.255.0':
						$mask = '24';
						break;
					case '255.255.255.255':
						$mask = '32';
						break;	
				}
				$comando = "sudo nmcli con modify ".$ssid." ifname wlan0 ssid registeltest ip4 ".$ip."/".$mask." gw4 ".$gateway;
				print_r($comando);
				print_r(shell_exec($comando));
				$comando = "sudo nmcli con mod ".$ssid." ipv4.method manual";
				print_r($comando);
				print_r(shell_exec($comando));
				return;
			}else{
				$comando = "sudo nmcli con mod ".$ssid." ipv4.method auto";
				print_r($comando);
				shell_exec($comando);
			}

			$comando = 'sudo nmcli c modify '.$ssid.' wifi-sec.key-mgmt wpa-psk wifi-sec.psk '.$psk;
			print_r($comando);
			if(shell_exec($comando) == NULL) printf("WIFI-OK");
			else printf("WIFI-ERROR");
		}
		//shell_exec("sudo nmcli radio wifi off && sleep 5 && nmcli radio wifi on");
		return;
	}
	
	$networks = $_POST['Networks'];
	$config = "ctrl_interface=DIR=/var/run/wpa_supplicant GROUP=netdev"."\n";
	$config .= "update_config=1"."\n";
	$config .= "country=GB"."\n";
	for($x = 0; $x < $networks; $x++) {
		$network = '';
		$ssid = escapeshellarg($_POST['ssid'.$x]);
		$psk = escapeshellarg($_POST['psk'.$x]);
		//echo 'wpa_passphrase '.$ssid.' '.$psk;
		exec('wpa_passphrase '.$ssid.' '.$psk,$network);
		foreach($network as $b) {
			$config .= "$b"."\n";
		}
		//print_r($config);
		exec("echo '$config' > /tmp/wifidata",$return);
		system('sudo cp /tmp/wifidata /etc/wpa_supplicant/wpa_supplicant.conf',$returnval);
		if($returnval == 0) {
			exec("sudo chmod 777 /etc/wpa_supplicant/wpa_supplicant.conf",$returnval);
			printf("WIFI-OK");
		} else {
			printf("WIFI-ERROR");
		}
	}
}

function scanWifi(){
	$output = '<body>'; 
	$output .= '<fieldset class="infoheader">';
	$output .= '<legend>Resultados de escaneo WIFI:</legend>';
	$output .= '<div>Nota: Los nombres de red que contengan espacios en blanco no serán correctamente detectados</div>';
	$resultado = '';
	exec('sudo nmcli device wifi list',$resultado);
	$i = 0;
	foreach($resultado as $a) {
		if($i++ == 0) continue;
		$arrssid = preg_split('/\s+/', $a);
		$ssid_a[] = escapeshellarg($arrssid[0]);
		$pos = array_search('Infra', $arrssid);
		//print_r($pos);
		$output .= '<div  style="border:solid green;">'. escapeshellarg($arrssid[1]) .'con señal: '. escapeshellarg($arrssid[($pos+4)]) .'<input class="infobox" type="button" value="Conectar a esta red" onClick="AddScanned('.escapeshellarg($arrssid[1]).')" />'.'</div>';
		//$output .=  '<input class="infobox" type="button" value="Conectar a esta red" onClick="AddScanned(\''.$ssid[$j].'\')" />';
	}

	$output .= '</fieldset>';
	$output .= '</body>'; 
	return printf($output);
}

function generarDetalleConteos($fechaInicial,$horaInicial,$fechaFinal,$horaFinal){
    //print_r("SELECT * FROM tablaLogGps WHERE fecha >= '".$fechaInicial." ".$horaInicial."' AND fecha <= '".$fechaFinal." ".$horaFinal."' ORDER BY fecha");
    do{
		$archivoGps = fopen("/var/www/html/RegislogWeb/variables/gps.txt", "r") or die("No se puede abrir el archivo!");
		$fileGps = fgets($archivoGps);
		fclose($archivoGps);
		$gps = explode(",", $fileGps);
	}while(count($gps) < 3);
	
	$trama_gps = $gps[7];
	//print_r($trama_gps);
    try{
		//Carga las redes almacenadas en base de datos
		$midb = conexionLocalSQLite3();
		$midb->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
		$results = $midb->prepare("SELECT * FROM tablaLogGps WHERE fecha >= '".$fechaInicial." ".$horaInicial."' AND fecha <= '".$fechaFinal." ".$horaFinal."' ORDER BY fecha"); 
		$results->setFetchMode(PDO::FETCH_ASSOC);
		$results->execute();
		if($results){
			$tabla .= "<table id='logGps' class = 'tabla'>";
			$tabla .= "<thead><tr><th colspan='9' >DETALLE DE CONTEOS</th></tr>";
				$tabla .= "<tr>";
					if($trama_gps != 0){
						$tabla .= "<th>Latitud</th>";
						$tabla .= "<th>Longitud</th>";
					}
					//$tabla .= "<th>Velocidad</th>";
					$tabla .= "<th>Fecha</th>";
					$tabla .= "<th>Numeracion</th>";
					$tabla .= "<th>Total dia</th>";
					$tabla .= "<th>Entradas</th>";
					$tabla .= "<th>Salidas</th>";
					//$tabla .= "<th>Bufer</th>";
				$tabla .= "</tr>";
			$tabla .= "</thead>";
			$tabla .= "<tbody>";
			$i=0;
			while($response = $results->fetch()){
				if(($i++) == 0){
					$fechaInicio = $response['fecha'];
					$numeracionInicial = $response['numeracion'];
					$entradasInicial = $response['entradas'];
					$salidasInicial = $response['salidas'];
				}
				$tabla .= "<tr>";
					if($trama_gps != 0){
						$tabla .= "<td>".$response['latitud']."</td>";
						$tabla .= "<td>".$response['longitud']."</td>";
					}
					//$tabla .= "<td>".$response['velocidad']."</td>";
					$tabla .= "<td>".$response['fecha']."</td>";
					$tabla .= "<td>".$response['numeracion']."</td>";
					$tabla .= "<td>".$response['total_dia']."</td>";
					$tabla .= "<td>".$response['entradas']."</td>";
					$tabla .= "<td>".$response['salidas']."</td>";
					//$tabla .= "<td>".$response['bufferSalidaGPS']."</td>";
				$tabla .= "</tr>";
				$fechaFinal = $response['fecha'];
				$numeracionFinal = $response['numeracion'];
				$total_dia = $response['total_dia'];
				$entradasFinal = $response['entradas'];
				$salidasFinal = $response['salidas'];
			}
			$tabla .= "</tbody>";		
			$tabla .= "</table>";	
		}
	}catch(PDOException $e) {
    	echo "Lo siento hay un error en BD..  ". $e->getMessage() ;// Remove or modify after testing 
    	file_put_contents('PDOErrors.txt',date('[Y-m-d H:i:s]').", vistas.php, ". $e->getMessage()."\r\n", FILE_APPEND);  
 	}
 	$tabla .= "<table id='idTotalizador' class = 'tabla'>";
		$tabla .= "<thead><tr><th colspan='9' >TOTAL CONTEOS</th></tr>";
			
		$tabla .= "</thead>";
		$tabla .= "<tbody>";			
			$tabla .= "<tr>";
				$tabla .= "<td><h2>".($numeracionFinal-$numeracionInicial)."</h2></td>";
			$tabla .= "</tr>";
		$tabla .= "</tbody>";		
	$tabla .= "</table>";
	return printf($tabla);
}

function generarDetalleVideos($fechaInicial,$horaInicial,$fechaFinal,$horaFinal){
    try{
	$midb = conexionLocalSQLite3();
	$midb->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
	//Obtiene el numero de filas de la tabla
	$results = $midb->prepare('SELECT * FROM listadoVideos ORDER BY fecha'); 
	$results->setFetchMode(PDO::FETCH_ASSOC);
	$results->execute();
	if($results){
		$sql = "SELECT * FROM listadoVideos WHERE fecha >= '".$fechaInicial." ".$horaInicial."' AND fecha <= '".$fechaFinal." ".$horaFinal."' ORDER BY fecha DESC";
		$results = $midb->prepare($sql); 
		$results->setFetchMode(PDO::FETCH_ASSOC);
		$results->execute();

		
		$tabla  = "<table id='idTablaVideos' class = 'tabla'>";
		$tabla .= "<thead><h2 id='tituloTabla'>Registro de videos";
		$tabla .= "</h2>";
			$tabla .= "<tr>";
				$tabla .= "<th>item</th>";
				$tabla .= "<th>Fecha video</th>";
				$tabla .= "<th>Descripción</th>";
				$tabla .= "<th>Acción</th>";
			$tabla .= "</tr>";
		$tabla .= "</thead>";
		$tabla .= "<tbody>";
		$j=1;
		while($fila = $results->fetch()){
			//echo  "dato";
			$tabla .= "<tr>";
				++$i;
				$tabla .= "<td id='id_$j'>".$j."</td>";
				$tabla .= "<td id='idFecha_$j'>".$fila['fecha']."</td>";
				$tabla .= "<td id='idNombre_$j'>".$fila['nombre']."</td>";
				$tabla .= "<td>";
				$tabla .= "<a target='_blank' href='vistas.php?func=descargarVideo&ruta=".$fila['ruta']."'>    Descargar</a></td>";
			$tabla .= "</tr>";
			$j++;
		}
		$tabla .= "</tbody>";		
		$tabla .= "</table>";
		$respuesta = $tabla;
	}else{
		//echo "No se cargo la tabla";
		$respuesta = "<div class= 'error'>Error: No se ejecuto la consulta a la base de datos</div>";
	}
	//Cierra la conexión con la base de datos
	$results = null;
	$midb = null;

	return printf($respuesta);
	}catch(PDOException $e) {
    	echo "Lo siento hay un error en BD..  ". $e->getMessage() ;// Remove or modify after testing 
    	file_put_contents('PDOErrors.txt',date('[Y-m-d H:i:s]').", vistas.php, ". $e->getMessage()."\r\n", FILE_APPEND);  
    }
}

function generarTrama($fechaInicial,$horaInicial,$fechaFinal,$horaFinal){
    //print_r("SELECT * FROM tablaLogGps WHERE fecha >= '".$fechaInicial." ".$horaInicial."' AND fecha <= '".$fechaFinal." ".$horaFinal."' ORDER BY fecha");
    try{
		//Carga las redes almacenadas en base de datos
		$midb = conexionLocalSQLite3();
		$midb->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
		$results = $midb->prepare("SELECT * FROM tablaLogGps WHERE fecha >= '".$fechaInicial." ".$horaInicial."' AND fecha <= '".$fechaFinal." ".$horaFinal."' ORDER BY fecha"); 
		$results->setFetchMode(PDO::FETCH_ASSOC);
		$results->execute();
		if($results){
			$tabla .= "<table id='logGps' class = 'tabla'>";
			$tabla .= "<thead><tr><th colspan='9' >LOG GPS</th></tr>";
				$tabla .= "<tr>";
					$tabla .= "<th>Latitud</th>";
					$tabla .= "<th>Longitud</th>";
					$tabla .= "<th>Velocidad</th>";
					$tabla .= "<th>Fecha</th>";
					$tabla .= "<th>Numeracion</th>";
					$tabla .= "<th>Total dia</th>";
					$tabla .= "<th>Entradas</th>";
					$tabla .= "<th>Salidas</th>";
					$tabla .= "<th>Bufer</th>";
				$tabla .= "</tr>";
			$tabla .= "</thead>";
			$tabla .= "<tbody>";
			$i=0;
			while($response = $results->fetch()){
				if(($i++) == 0){
					$fechaInicio = $response['fecha'];
					$numeracionInicial = $response['numeracion'];
					$entradasInicial = $response['entradas'];
					$salidasInicial = $response['salidas'];
				}
				$tabla .= "<tr>";
					$tabla .= "<td>".$response['latitud']."</td>";
					$tabla .= "<td>".$response['longitud']."</td>";
					$tabla .= "<td>".$response['velocidad']."</td>";
					$tabla .= "<td>".$response['fecha']."</td>";
					$tabla .= "<td>".$response['numeracion']."</td>";
					$tabla .= "<td>".$response['total_dia']."</td>";
					$tabla .= "<td>".$response['entradas']."</td>";
					$tabla .= "<td>".$response['salidas']."</td>";
					$tabla .= "<td>".$response['bufferSalidaGPS']."</td>";
				$tabla .= "</tr>";
				$fechaFinal = $response['fecha'];
				$numeracionFinal = $response['numeracion'];
				$total_dia = $response['total_dia'];
				$entradasFinal = $response['entradas'];
				$salidasFinal = $response['salidas'];
			}
			$tabla .= "</tbody>";		
			$tabla .= "</table>&".$fechaInicio."&".$numeracionInicial."&".$entradasInicial."&".$salidasInicial."&".$fechaFinal."&".$numeracionFinal."&".$total_dia."&".$entradasFinal."&".$salidasFinal;	
		}
	}catch(PDOException $e) {
    	echo "Lo siento hay un error en BD..  ". $e->getMessage() ;// Remove or modify after testing 
    	file_put_contents('PDOErrors.txt',date('[Y-m-d H:i:s]').", vistas.php, ". $e->getMessage()."\r\n", FILE_APPEND);  
 	}

	return printf($tabla);
}

function verCambios(){
	do{
		$archivoVersion = fopen("/var/www/html/RegislogWeb/variables/version.txt", "r") or die("No se puede abrir el archivo!");
		$fileVersion = fgets($archivoVersion);
		fclose($archivoVersion);
		$Version = explode(";", $fileVersion);
	}while(count($Version) < 1);
	//print_r($Version);
	$tabla .= "<table id='logCambiosVersion' class = 'tabla'>";
		$tabla .= "<thead><tr><th colspan='3' >LOG DE CAMBIOS</th></tr>";
			$tabla .= "<tr>";
				$tabla .= "<th>Versión</th>";
				$tabla .= "<th>fecha</th>";
				$tabla .= "<th>Cambios</th>";
			$tabla .= "</tr>";
		$tabla .= "</thead>";
		$tabla .= "<tbody>";
		foreach($Version as $a){
			$datos = explode(",", $a);
			//print_r($datos);
			$tabla .= "<tr>";
				$tabla .= "<td>".$datos[0]."</td>";
				$tabla .= "<td>".$datos[1]."</td>";
				$tabla .= "<td>".$datos[2]."</td>";
			$tabla .= "</tr>";
		}
		$tabla .= "</tbody>";		
	$tabla .= "</table>";
	return printf($tabla);
}

function programarAudios(){
	$row = exec('ls -ls /var/www/html/RegislogWeb/uploads/',$output,$error);
	$resultado = '<div>';
	
	if(count($output) > 1){
		$resultado .= '<button type="button" id="borrarLogs">Borrar logs</button>';
	}
	$i = 0;
	foreach($output as $a){
		if(preg_match('/mp3/i',$a) || preg_match('/wav/i',$a)){
			$arrLog = preg_split('/\s+/', $a);
			foreach ($arrLog as $b) {
				if(preg_match('/mp3/i',$b) || preg_match('/wav/i',$b)){
					$audio_a[$i++] = $b;
				}
			}
		}
	}
	//print_r($audio_a);
	try{
		//Carga las redes almacenadas en base de datos
		$midb = conexionLocalSQLite3();
		$midb->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
		$tabla .= "<table id='programacionAudio' class = 'tabla'>";
			$tabla .= "<thead><tr><th colspan='6' >PROGRAMACION DE AUDIOS</th></tr>";
				$tabla .= "<tr>";
					$tabla .= "<th>Audio</th>";
					$tabla .= "<th>Intervalo (min)</th>";
					$tabla .= "<th>Fecha inicial</th>";
					$tabla .= "<th>Fecha final</th>";
					$tabla .= "<th>Volumen</th>";
					$tabla .= "<th>Acción</th>";
				$tabla .= "</tr>";
			$tabla .= "</thead>";
			$tabla .= "<tbody>";
				$i = 0;
				foreach($audio_a as $a){
					$nRows = $midb->query("SELECT COUNT(*) FROM mensajesAudio WHERE nombre = '".$a."'")->fetchColumn(); 
					if($nRows >0){
						$results = $midb->prepare("SELECT * FROM mensajesAudio WHERE nombre = '".$a."'"); 
						$results->setFetchMode(PDO::FETCH_ASSOC);
						$results->execute();
						if($results){
							while($response = $results->fetch()){
								$i++;
								$tabla .= "<tr>";
									$tabla .= "<td id='audio_".$i."'>".$response['nombre']."</td>";
									$tabla .= "<td id='intervalo_".$i."'>".$response['intervalo']."</td>";
									$tabla .= "<td id='fechaInicial_".$i."'>".$response['fecha_inicial']."</td>";
									$tabla .= "<td id='fechaFinal_".$i."'>".$response['fecha_final']."</td>";
									$tabla .= "<td id='volumen_".$i."'>".$response['volumen']."</td>";
									$tabla .= "<td><a href='#' class='eliminar' data-id_mensajesaudio='".$response['Primary_Key']."'>Eliminar  </a>"
                                                                                . "<span style='display:inline-block; width: 5px;'></span>"
                                                                                . "<a href='#' class='editar' data-id_mensajesAudio='".$i."'>Editar</a>"
                                                                                . "<span style='display:inline-block; width: 5px;'></span>"
                                                                                . "<a href='#' class='escuchar' data-id_mensajesAudio='".$i."'>Escuhar</a>"
                                                                                . "</td>";
								$tabla .= "</tr>";
							}
						}
					}else{
						$i++;
						$tabla .= "<tr>";
							$tabla .= "<td id='audio_".$i."'>".$a."</td>";
							$tabla .= "<td id='intervalo_".$i."'></td>";
							$tabla .= "<td id='fechaInicial_".$i."'></td>";
							$tabla .= "<td id='fechaFinal_".$i."'></td>";
							$tabla .= "<td id='volumen_".$i."'></td>";
							$tabla .= "<td><a href='#' class='editar' data-id_mensajesaudio='".$i."'>Editar</a></td>";
						$tabla .= "</tr>";
					}
				}
			$tabla .= "</tbody>";		
		$tabla .= "</table>";	
		$tabla .= "<div id='tablaProgramacionAudio'></div>";
		$tabla .= '<button type="button" id="aplicarCambiosAudios">Aplicar cambios</button>';
		$tabla .= '<button type="button" id="borrarProgramacionAudios">Borrar toda la programación</button>';
	}catch(PDOException $e) {
    	echo "Lo siento hay un error en BD..  ". $e->getMessage() ;// Remove or modify after testing 
    	file_put_contents('PDOErrors.txt',date('[Y-m-d H:i:s]').", vistas.php, ". $e->getMessage()."\r\n", FILE_APPEND);  
 	}
	return printf($tabla);
}

function editarContadores(){
	try{
	$midb = conexionLocalSQLite3();
	$midb->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
	$results = $midb->prepare('SELECT * FROM REGISTROS_CONTEO'); 
	$results->setFetchMode(PDO::FETCH_ASSOC);
	$results->execute();
	if($results){
		while($fila = $results->fetch()){
			$form ="<form id='alta-contadores' class='formulario' data-insertar>";
				$form .= "<fieldset>";
					$form .= "<legend>Modificar contadores</legend>";
					$form .= "<div>";
						$form .= "<label for='numeracion'>Numeración:</label>";
						$form .= "<input type='text' id='idnumeracion' name='numeracion_tx' value ='".$fila['NUMERACION']."'required />";
					$form .= "</div>";
					
					$form .= "<div>";
						$form .= "<label for='totaldia'>Total día:</label>";
						$form .= "<input type='text' id='idtotaldia' name='totaldia_tx' value ='".$fila['TOTAL_DIA']."'required />";
					$form .= "</div>";

					$form .= "<div>";
						$form .= "<label for='entradas'>Entradas:</label>";
						$form .= "<input type='text' id='identradas' name='entradas_tx' value ='".$fila['ENTRADAS']."'required />";
					$form .= "</div>";

					$form .= "<div>";
						$form .= "<label for='salidas'>Salidas:</label>";
						$form .= "<input type='text' id='idsalidas' name='salidas_tx' value ='".$fila['SALIDAS']."'required />";
					$form .= "</div>";

					$form .= "<div>";
						$form .= "<input type='submit' id='insertarcontadores-btn' name='insertarcontadores_btn' value='Aplicar cambios' />";
						/*  Una entrada oculta para enviar los datos al controlador*/
						$form .= "<input type='hidden' id='transaccion' name='transaccion' value='insertar' />";
					$form .= "</div>";
				$form .= "</fieldset>";
			$form .= "</form>";	
		}

	}else{
		//echo "No se cargo la tabla";
		$form = "<div class= 'error'>Error: No se ejecuto la consulta a la base de datos</div>";
	}
	//Cierra la conexión con la base de datos
	$results = null;
	$midb = null;
	return printf($form);
	}catch(PDOException $e) {
    	echo "Lo siento hay un error en BD..  ". $e->getMessage() ;// Remove or modify after testing 
    	file_put_contents('PDOErrors.txt',date('[Y-m-d H:i:s]').", vistas.php, ". $e->getMessage()."\r\n", FILE_APPEND);  
 	}
}

function descargarAlarmas($fechaInicial,$fechaFinal,$tipo){
	if($tipo == 0){
		$sql = "FROM tablaAlarmas WHERE fecha >= '".$fechaInicial." 00:00:00' AND fecha <= '".$fechaFinal." 23:59:59' ORDER BY fecha DESC";
	}else{
		$sql = "FROM tablaAlarmas WHERE fecha >= '".$fechaInicial." 00:00:00' AND fecha <= '".$fechaFinal." 23:59:59' AND codigo = $tipo ORDER BY fecha DESC";
	}
	$sql = 'SELECT * '.$sql;
	try{
		$midb = conexionLocalSQLite3();
		$midb->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
		$results = $midb->prepare($sql); 
		$results->setFetchMode(PDO::FETCH_ASSOC);
		$results->execute();
		$result = '"FECHA ALARMA";"DESCRIPCION";"CANTIDAD"'."\r\n";
		if($results){
			while($fila = $results->fetch()){
				$codigo = $fila['codigo'];
				$descripcion = listadoAlarmas($codigo);
				$cantidad = $fila['cantidad'];
				$cadena = listadoCantidad($cantidad,$codigo);
				$fecha = $fila["fecha"];
				$result .= '"'.$fecha.'";"'.$descripcion.'";"'.$cadena.'"'."\r\n";
			}
		}
		exec("sudo echo '".$result."' > /var/www/html/RegislogWeb/variables/alarmas.csv");
	
		$resultado = "<iframe width='1' height='1' frameborder='0' src='variables/alarmas.csv'></iframe>";
		 
		return printf($resultado);
	}catch(PDOException $e) {
    	echo "Lo siento hay un error en BD..  ". $e->getMessage() ;// Remove or modify after testing 
    	file_put_contents('PDOErrors.txt',date('[Y-m-d H:i:s]').", vistas.php, ". $e->getMessage()."\r\n", FILE_APPEND);  
 	}
}

function filterData(&$str)
{
    $str = preg_replace("/\t/", "\\t", $str);
    $str = preg_replace("/\r?\n/", "\\n", $str);
    if(strstr($str, '"')) $str = '"' . str_replace('"', '""', $str) . '"';
}

function descargarConteos($fechaInicial,$horaInicial,$fechaFinal,$horaFinal){
    
    do{
		$archivoGps = fopen("/var/www/html/RegislogWeb/variables/gps.txt", "r") or die("No se puede abrir el archivo!");
		$fileGps = fgets($archivoGps);
		fclose($archivoGps);
		$gps = explode(",", $fileGps);
	}while(count($gps) < 3);
	
	$trama_gps = $gps[7];
	//print_r($trama_gps);
    try{
		//Carga las redes almacenadas en base de datos
		$midb = conexionLocalSQLite3();
		$midb->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
		$results = $midb->prepare("SELECT * FROM tablaLogGps WHERE fecha >= '".$fechaInicial." ".$horaInicial."' AND fecha <= '".$fechaFinal." ".$horaFinal."' ORDER BY fecha"); 
		$results->setFetchMode(PDO::FETCH_ASSOC);
		$results->execute();
		if($trama_gps != 0)  $result = '"FECHA CONTEO";"NUMERACION";"TOTAL DIA";"ENTRADAS";"SALIDAS";"LATITUD";"LONGITUD"'."\r\n";
		else $result = '"FECHA CONTEO";"NUMERACION";"TOTAL DIA";"ENTRADAS";"SALIDAS"'."\r\n";
		$i = 0;
		if($results){
			while($response = $results->fetch()){
				
				if($trama_gps != 0){
						$latitud = $response['latitud'];
						$longitud = $response['longitud'];
						$latitud = str_replace('.', ',', $latitud);
						$longitud = str_replace('.', ',', $longitud);
					}
					
					$fecha = $response['fecha'];
					$numeracion = $response['numeracion'];
					$totaldia = $response['total_dia'];
					$entradas = $response['entradas'];
					$salidas = $response['salidas'];
					
					if($i++ == 0) $numeracionInicial = $numeracion;
					else $numeracionFinal = $numeracion;

					if($trama_gps != 0) $result .= '"'.$fecha.'";"'.$numeracion.'";"'.$totaldia.'";"'.$entradas.'";"'.$salidas.'";"'.$latitud.'";"'.$longitud.'"'."\r\n";
					else  $result .= '"'.$fecha.'";"'.$numeracion.'";"'.$totaldia.'";"'.$entradas.'";"'.$salidas.'"'."\r\n";
			}
		}
		$result .= '"TOTAL CONTEOS:";"'.($numeracionFinal-$numeracionInicial).'"';
		exec("sudo echo '".$result."' > /var/www/html/RegislogWeb/variables/detalle_conteo.csv");
		
		$resultado = "<iframe width='1' height='1' frameborder='0' src='variables/detalle_conteo.csv'></iframe>";
		 
		return printf($resultado);
	}catch(PDOException $e) {
    	echo "Lo siento hay un error en BD..  ". $e->getMessage() ;// Remove or modify after testing 
    	file_put_contents('PDOErrors.txt',date('[Y-m-d H:i:s]').", vistas.php, ". $e->getMessage()."\r\n", FILE_APPEND);  
 	}	
}

function descargarHistoricos($fechaInicial,$fechaFinal){
    try{
		$fechaInicial = str_replace("-", "/", $fechaInicial);
		$fechaFinal = str_replace("-", "/", $fechaFinal);
		$midb = conexionLocalSQLite3();
		$midb->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
		$sql = "SELECT * FROM tablaHistoricos WHERE fecha >= '".$fechaInicial."' AND fecha <= '".$fechaFinal."' ORDER BY fecha";
		
		$results = $midb->prepare("SELECT * FROM tablaHistoricos WHERE fecha >= '".$fechaInicial."' AND fecha <= '".$fechaFinal."' ORDER BY fecha"); 
		$results->setFetchMode(PDO::FETCH_ASSOC);
		$results->execute();
		$result = '"FECHA";"TOTAL DIA"'."\r\n";
		
		if($results){
			while($response = $results->fetch()){

				$fecha = $response['fecha'];
				$total_dia = $response['total_dia'];

				$result .= '"'.$fecha.'";"'.$total_dia.'"'."\r\n";
				
			}
		}  
		exec("sudo echo '".$result."' > /var/www/html/RegislogWeb/variables/historicos.csv");
	  
		$resultado = "<iframe width='1' height='1' frameborder='0' src='variables/historicos.csv'></iframe>";
		
		return printf($resultado);
	}catch(PDOException $e) {
    	echo "Lo siento hay un error en BD..  ". $e->getMessage() ;// Remove or modify after testing 
    	file_put_contents('PDOErrors.txt',date('[Y-m-d H:i:s]').", vistas.php, ". $e->getMessage()."\r\n", FILE_APPEND);  
 	}	
}
  
  
function reiniciarSistema(){
	printf("OK-REINICIO");
	exec('sudo shutdown -r now');
}

function apagarSistema(){
	print_r("OK-APAGADO");
	exec('sudo shutdown -h now');
}
   
function descargarVideo($ruta){
	$nombre = basename($ruta);
	$partes = explode('/',$ruta);
	//print_r ($partes);
	exec('sudo cp '.$ruta.' /var/www/html/RegislogWeb/videos/'.$partes[3].'-'.$nombre);
	exec('sudo chmod 777 /var/www/html/RegislogWeb/videos/'.$partes[3].'-'.$nombre);
	$download_file = '/var/www/html/RegislogWeb/videos/'.$partes[3].'-'.$nombre;
	//$ruta = null;
	if(!empty($ruta)){
		// Check file is exists on given path.
		if(file_exists($download_file))
		{
			header('Content-Description: File Transfer');
			header('Content-Type: application/octet-stream');
			header('Content-Disposition: attachment; filename="'.basename($download_file).'"');
			header('Expires: 0');
			header('Cache-Control: must-revalidate');
			header('Pragma: public');
			header('Content-Length: ' . filesize($download_file));
			readfile($download_file);
			exec('sudo rm /var/www/html/RegislogWeb/videos/'.$partes[3].'-'.$nombre);
			exit;
		}
		else
		{
		  print_r('ERROR.. El archivo de video no se encontro');
		}
	}else{
		print_r('ERROR.. ruta del archivo no valida');
	}
}

 ?>
