//Constantes
var READY_STATE_COMPLETE = 4;
var STATUS_OK = 200;
//Variables
var ajax = null;
var velGauge;
var rutaTiempoGauge;
var matrizPuntos;
var resultadoGps;
var distancia = [];
var diferenciaTiempo = [];
var checkPoint = [];
var matrizPuntos = [];
var cargaInicial = 0;
var rutaTerminada = 0;
var timerRuta = null;
var datosCard;
var validacion = false;
var activar_audio = false;

var audio_velocidad = 0;

var vel_test = 0;
var ajaxStatus = 0;
var hora_control;
var hora_texto = "";
//Variables
var respuesta = document.querySelector("#htmlTabla");
var cronometro = document.querySelector("#cronometro");
var hora = document.querySelector("#hora");
var nombrePunto = document.querySelector("#nombrePunto");

var btnEnviarMensaje = document.querySelector("#btnEnviarMensaje");

var reiniciarPagina = 0;

var btnMensajeLeido = document.querySelector("#btnMensajeLeido");
//Funciones
//Función que asigna los eventos al cargar el documento principal
function alCargarDocumento(){
	
	btnEnviarMensaje.addEventListener('click',enviarMensaje);
	btnMensajeLeido.addEventListener('click',mensajeLeido);
	timerVelocidad = setInterval(velocidad,1000);
	timerMensages = setInterval(mensages,1000);
	velGauge =  new RadialGauge({
	    renderTo: document.querySelector("#canvas_velocidad"),
	    width: 300,
	    height: 300,
	    units: 'Km/h',
	    title: false,
	    value: 80,
	    minValue: 0,
	    maxValue: 140,
	    majorTicks: [
	        '0','20','40','60','80','100','120','140'
	    ],
	    minorTicks: 2,
	    strokeTicks: false,
	    highlights: [
	        { from: 0, to: 40, color: 'rgba(0,255,0,.15)' },
	        { from: 40, to: 60, color: 'rgba(255,255,0,.15)' },
	        { from: 60, to: 80, color: 'rgba(255,30,0,.25)' },
	        { from: 80, to: 100, color: 'rgba(255,0,225,.25)' },
	        { from: 100, to: 140, color: 'rgba(0,0,255,.25)' }
	    ],
	    colorPlate: '#222',
	    colorMajorTicks: '#f5f5f5',
	    colorMinorTicks: '#ddd',
	    colorTitle: '#fff',
	    colorUnits: '#ccc',
	    colorNumbers: '#eee',
	    colorNeedle: 'rgba(240, 128, 128, 1)',
	    colorNeedleEnd: 'rgba(255, 160, 122, .9)',
	    valueBox: true,
	    animationRule: 'bounce',
	    animationDuration: 500
	});

	velGauge.draw();
}


function cargarTablaRuta(){
	$.ajax({
	    url: "controlador_c.php",
	    type: 'POST',
	    data: {transaccion:"datosRuta"},
	    dataType:"json",
	    success: function(data) {
	        matrizPuntosRutas = data;
	        
	        console.log("Numero filas: "+matrizPuntosRutas.length);
	        if(crearTablaRutaActual()) return;
	        	timerRuta = setInterval(crearTablaRutaActual,1000);	
	   	}
	});
}

function cargarDatos(){
	$.ajax({
	    url: "controlador_c.php",
	    type: 'POST',
	    data: {transaccion:"datosTarjeta"},
	    dataType:"json",
	    success: function(data) {
	        datosCard = data;
	        //console.log("Datos tarjeta "+datosCard[7]);
	        if(datosCard[7] == 0) validacion =  false;
	        else validacion =  true;
	   	}
	});
}

function mostrarValidacion(){
	if(datosCard[7] == 1){
        html = "<div>"+datosCard[0]+" "+datosCard[1]+"<br>";
        html += "<br>";
        html += "<div style='color:green;'>VALIDACION EXITOSA</div></div>";

        if(!activar_audio){
        	var audio =document.createElement("audio");
    		audio.src = "audio/Tarjeta_confirmada.wav";
    		audio.play();
    		activar_audio = true;
    		cronometro.innerHTML = html;
        }
    }
    if(datosCard[7] == 2){
        html = "<div>"+datosCard[0]+" "+datosCard[1]+"<br>";
        html += "<br>";
        html += "<h2 style='color:red;'>SALDO INSUFICIENTE</h2></div>";

        if(!activar_audio){			
        	var audio =document.createElement("audio");
    		audio.src = "audio/Saldo_insuficiente.wav";
    		audio.play();
    		activar_audio = true;
    		cronometro.innerHTML = html;
        }
    }
}

function calcularDistancias(){
	var positivo = false;
	var latitud_r = resultadoGps[1] * Math.PI / 180;
	var longitud_r = resultadoGps[2] *Math.PI /180;
	var latitud_p;
	var longitud_p;
	var nombre_punto;
	var hora;
	var minutos;
	var segundos;
	var h;
	var m;
	var s;
	var numero_negativo = false;
	var indicePunto = 0;
	var puntoEncontrado = false;
	var baseEncontrada = false;
	cargarDatos();
	if(validacion){
		mostrarValidacion();
		return;
	}else activar_audio = false;
	//latitud_r = 3.44068;
	//longitud_r = -76.60674;
	for(var i=0; i<matrizPuntos.length; i++){
		latitud_p = matrizPuntos[i][1] * Math.PI / 180;
		longitud_p = matrizPuntos[i][2] * Math.PI / 180;
		var deltaLat = latitud_p - latitud_r;
		var deltaLon = longitud_p - longitud_r;
		var a = Math.pow(Math.sin(deltaLat/2),2) + Math.cos(latitud_p) * Math.cos(latitud_r) * Math.pow(Math.sin(deltaLon/2),2);
		var b = 2 * Math.asin(Math.sqrt(a));
		distancia[i] = 6371000*b;
		if((distancia[i] < matrizPuntos[i][3]) && checkPoint[i] != 2 && checkPoint[i] != 3){ // Si esta dentro de un punto de control y no ha sido chequeado
			
			if(i>2 && matrizPuntos[i][5] == 4 && checkPoint[i-1] !=0){ //El punto es una base de llegada y el punto anterior fue chequeado?
				checkPoint[i] = 2;
				nombrePunto.innerHTML = "La ruta ha finalizado: "+matrizPuntos[i][0];
				cronometro.innerHTML = "<div style='color:black; font-weight: bold;'>--:--</div><h3 style='color:green; padding: 5px;'>A tiempo</h3>";
				location.reload();
				return;
			}else if(matrizPuntos[i][5] == 4) return;
			checkPoint[i] = 1;
			nombre_punto = matrizPuntos[i][0];
			diferenciaTiempo[i] = (new Date(matrizPuntos[i][4]) - new Date(resultadoGps[3]))/1000;
			if(diferenciaTiempo[i] < 0){
				numero_negativo = true;
				diferenciaTiempo[i] *= -1; // Convierte el numero a positivo
			}
			hora = parseInt(diferenciaTiempo[i]/3600);
			minutos = parseInt(((diferenciaTiempo[i]/3600)-hora)*60);
			segundos = parseInt(diferenciaTiempo[i]-(hora*3600)-(minutos*60));
			h = (hora < 10) ? ("0" + hora) : hora;
			m = (minutos < 10) ? ("0" + minutos) : minutos;
			s = (segundos < 10) ? ("0" + segundos) : segundos ;
			nombrePunto.innerHTML = "Punto detectado: "+nombre_punto;
			if(!numero_negativo){ 
				if(diferenciaTiempo[i] < (matrizPuntos[i][6]*60)){
					cronometro.innerHTML = "<div style='color:black; font-weight: bold;'>"+h+":"+m+":"+s+"</div><h3 style='color:green; padding: 5px;'>A tiempo</h3>";
				} 
				else cronometro.innerHTML = "<div style='color:black; font-weight: bold;'>"+h+":"+m+":"+s+"</div><h3 style='color:red; padding: 5px;'>Adelantado</h3>";
			}else {
				if(diferenciaTiempo[i] < (matrizPuntos[i][6]*60)){
					cronometro.innerHTML = "<div style='color:black; font-weight: bold;'>-"+h+":"+m+":"+s+"</div><h3 style='color:green; padding: 5px;'>A tiempo</h3>";
				} 
				else{
					cronometro.innerHTML = "<div style='color:black; font-weight: bold;'>-"+h+":"+m+":"+s+"</div><h3 style='color:red; padding: 5px;'>Atrasado</h3>";
				} 
			}
			return;
		}else if(matrizPuntos[i][5] == 3 && checkPoint[i] == 1){
			checkPoint[i] = 2; // Marca el punto indicando que salido de la base de inicio de vuelta 
		}else if(matrizPuntos[i][5] != 3 && checkPoint[i] == 1) checkPoint[i] = 3;
	}
	//Esta por fuera de los puntos de control
	numero_negativo = false;
	for(i=0; i<matrizPuntos.length; i++){
		indicePunto = (matrizPuntos.length-1)-i;
		if(checkPoint[indicePunto] != 0){
			puntoEncontrado = true;
			break;
		}else puntoEncontrado = false; 
	}
	i = indicePunto+1;
	if(!puntoEncontrado){
		nombrePunto.innerHTML = "Esperando punto de control...";
		cronometro.innerHTML = "--:--:--";
		return;	
	} 
	nombre_punto = matrizPuntos[i][0];
	diferenciaTiempo[i] = (new Date(matrizPuntos[i][4]) - new Date(resultadoGps[3]))/1000;
	if(diferenciaTiempo[i] < 0){
		numero_negativo = true;
		diferenciaTiempo[i] *= -1; // Convierte el numero a positivo

	}
	hora = parseInt(diferenciaTiempo[i]/3600);
	minutos = parseInt(((diferenciaTiempo[i]/3600)-hora)*60);
	segundos = parseInt(diferenciaTiempo[i]-(hora*3600)-(minutos*60));
	h = (hora < 10) ? ("0" + hora) : hora;
	h = (hora < 10) ? ("0" + hora) : hora;
	m = (minutos < 10) ? ("0" + minutos) : minutos;
	s = (segundos < 10) ? ("0" + segundos) : segundos ;
	nombrePunto.innerHTML = "Próximo punto: "+nombre_punto;
	if(!numero_negativo) cronometro.innerHTML = "<div style='color:black; font-weight: bold;'>"+h+":"+m+":"+s+"</div><h3 style='color:blue; padding: 5px;'>Para llegar al próximo punto</h3>";
	else cronometro.innerHTML = "<div style='color:red; font-weight: bold;'>-"+h+":"+m+":"+s+"</div><h3 style='color:red; padding: 5px;'>De atraso al próximo punto</h3>";	
}

function crearTablaRutaActual(){
	var difTiempo = 0;
	var baseSalida = false;

	//resultadoGps[3] = "2018-03-14 15:05:09";
	console.log(resultadoGps[3]);
	for(var i=0; i<matrizPuntosRutas.length; i++){
		difTiempo = (new Date(matrizPuntosRutas[i][4]) - new Date(resultadoGps[3]))/1000;
		//console.log("DHora matriz = "+new Date(matrizPuntosRutas[i][4]));
		
		if(difTiempo > -600 && matrizPuntosRutas[i][5] == 3){ // Busca en un rango de 10 minutos bases de salida para poder crear la tabla de ruta a controlar 
			baseSalida = true; // Da autorización para crear la tabla de ruta
			console.log("Encontro base en:"+i);
			break;
		} 
	}
	if(baseSalida){ // Encontró una base de salida
		var j = 0;
		for( ;i<matrizPuntosRutas.length;i++){ // Construye la matriz de puntos de la  tabla de ruta a controlar
			matrizPuntos.push([]);
			matrizPuntos[j][0] = matrizPuntosRutas[i][0];
			matrizPuntos[j][1] = matrizPuntosRutas[i][1];
			matrizPuntos[j][2] = matrizPuntosRutas[i][2];
			matrizPuntos[j][3] = matrizPuntosRutas[i][3];
			matrizPuntos[j][4] = matrizPuntosRutas[i][4];
			matrizPuntos[j][5] = matrizPuntosRutas[i][5];
			matrizPuntos[j][6] = matrizPuntosRutas[i][6];
			matrizPuntos[j][7] = matrizPuntosRutas[i][7];
			difTiempo = (new Date(matrizPuntosRutas[i][4]) - new Date(resultadoGps[3]))/1000;
			console.log("Diferencia de tiempo = "+difTiempo);
			
			if(difTiempo < 0){
				if(matrizPuntosRutas[i][5] == 3) checkPoint[j] = 1; // Marca el punto base como chequeado
				else  checkPoint[j] = 1; // Marca punto como chequeado
			}else	checkPoint[j] = 0; // inicializa los check points
			if(matrizPuntosRutas[i][5] == 4) {
				if(timerRuta != null) clearInterval(timerRuta);
				return true; //Proceso de creación exitoso al encontrar la base de salida
			}
			j++;
		}
	}
	return false; // No hay tablas creadas
}

function enviarMensaje(){
	//alert("Enviar mensaje");
	var win = window.open('/Conductor/MensajesControlador.php', '_blank');
  	win.focus();
}

function ejecutarAJAX(datos){
	ajax = objetoAJAX();
	ajax.onreadystatechange=enviarDatos; //Detecta los cambios de estado, existen varios
	ajax.open("POST","controlador_c.php");
	ajax.setRequestHeader("Content-Type","application/x-www-form-urlencoded");
	ajax.send(datos);
}

function enviarDatos(){
	//precarga.style.display = "block";
	//precarga.innerHTML = "<img src='img/loader.gif' />";
	//console.log(ajax.status);
	//console.log("status");
	//console.log(READY_STATE_COMPLETE);
	if(ajax.readyState == READY_STATE_COMPLETE){

		if(ajax.status == STATUS_OK){ // Respuesta para peticiones correctas
			console.log("reiniciarPagina: "+reiniciarPagina);
			if(reiniciarPagina > 60) location.reload();
			reiniciarPagina = 0;
			//precarga.innerHTML = null;
			//precarga.style.display = "none";
			respuesta.style.display = "block";
			if(ajax.responseText.indexOf("datosGps") >-1){ // Obtiene la velocidad de base de datos
				
				var indice = ajax.responseText.indexOf("=");
				indice++;
				var datosGps = ajax.responseText.substring(indice,ajax.responseText.length);
				resultadoGps = datosGps.split("+");
				//resultadoGps[0] = vel_test++;
				velGauge.value = resultadoGps[0];
				if(audio_velocidad == 0 && parseInt(resultadoGps[0]) > parseInt(resultadoGps[4])){ // Reviza si hay sobrepaso del limite de velocidad
					console.log("Velocidad = "+resultadoGps[0]+" Limite_velocidad = ",resultadoGps[4]);
					var audio =document.createElement("audio");
    				audio.src = "audio/Limite_velocidad.wav";
    				audio.play();
    				audio_velocidad = 5; // Cada 5 segundos se repite el mensaje
				}
				if(audio_velocidad > 0) audio_velocidad --;

				if(cargaInicial == 0) cargarTablaRuta();	
				else {
					calcularDistancias();
					imprimirTablaRuta();
				}
				cargaInicial++;
			}else if(ajax.responseText.indexOf("datosRuta") >-1){

			}else respuesta.innerHTML = ajax.responseText;
			
		}else{
			location.reload();
			//alert("El servidor no contestó\nError "+ajax.status+":"+ajax.statusText);
		}
		//console.log(ajax);
	}else if(ajax.status == 0 && ajaxStatus == 0){
		hora.innerHTML = "<div style='color:red; font-weight: bold;'>"+"NO HAY CONEXION CON REGISBUS"+"</div>";
		nombrePunto.innerHTML = "ESPERANDO SISTEMA.....";
		reiniciarPagina++;
	}
	ajaxStatus = ajax.status;
}
 
function imprimirTablaRuta(){
	
	if(!hora_texto.includes(resultadoGps[3])){
		hora.innerHTML = "<div style='color:black; font-weight: bold;'>"+resultadoGps[3]+"</div>";
		hora_texto = resultadoGps[3];	
		hora_control = 0;
	}else{
		if(hora_control++ > 60){
			hora.innerHTML = "<div style='color:black; font-weight: bold;'>"+"NO HAY CONEXION CON EL GPS"+"</div>";
		}
	}
	
	
	//Imprime la tabla de la ruta a controlar
	var tablaRuta = "<table id='alarmas' class = 'tabla'>";
	tablaRuta += "<thead><h2 id='tituloTabla'>Tabla puntos de control ruta a controlar</h2>";
	tablaRuta += "<tr>";
	tablaRuta += "<th>Codigo</th>";
	tablaRuta += "<th>Latitud</th>";
	tablaRuta += "<th>Longitud</th>";
	tablaRuta += "<th>Radio</th>";
	tablaRuta += "<th>Tiempo programado</th>";
	tablaRuta += "<th>Distancia desde vehículo</th>";
	tablaRuta += "<th>Diferencia de tiempo</th>";
	tablaRuta += "<th>Dirección del punto</th>";
	tablaRuta += "<th>checkPoint</th>";
	tablaRuta += "</tr>";
	tablaRuta += "</thead>";
	tablaRuta += "<tbody>";
	for (var i = 0; i < matrizPuntos.length; i++) {
		tablaRuta += "<tr>";
		tablaRuta +="<td>"+matrizPuntos[i][0]+"</td>";
		tablaRuta +="<td>"+matrizPuntos[i][1]+"</td>";
		tablaRuta +="<td>"+matrizPuntos[i][2]+"</td>";
		tablaRuta +="<td>"+matrizPuntos[i][3]+"</td>";
		tablaRuta +="<td>"+matrizPuntos[i][4]+"</td>";
		tablaRuta +="<td>"+distancia[i]+"</td>";
		tablaRuta +="<td>"+diferenciaTiempo[i]+"</td>";
		tablaRuta +="<td>"+matrizPuntos[i][5]+"</td>";
		tablaRuta +="<td>"+checkPoint[i]+"</td>";
		tablaRuta +="</tr>";
	}
	tablaRuta += "</tbody>";		
	tablaRuta += "</table>";
	//Imprime toda la programación de rutas
	tablaRuta += "<table id='alarmas' class = 'tabla'>";
	tablaRuta += "<thead><h2 id='tituloTabla'>Tabla puntos de control</h2>";
	tablaRuta += "<tr>";
	tablaRuta += "<th>Codigo</th>";
	tablaRuta += "<th>Latitud</th>";
	tablaRuta += "<th>Longitud</th>";
	tablaRuta += "<th>Radio</th>";
	tablaRuta += "<th>Tiempo programado</th>";
	tablaRuta += "<th>Dirección del punto</th>";
	tablaRuta += "<th>Holgura del punto</th>";
	tablaRuta += "<th>Ruta</th>";
	tablaRuta += "</tr>";
	tablaRuta += "</thead>";
	tablaRuta += "<tbody>";
	for (var i = 0; i < matrizPuntosRutas.length; i++) {
		tablaRuta += "<tr>";
		tablaRuta +="<td>"+matrizPuntosRutas[i][0]+"</td>";
		tablaRuta +="<td>"+matrizPuntosRutas[i][1]+"</td>";
		tablaRuta +="<td>"+matrizPuntosRutas[i][2]+"</td>";
		tablaRuta +="<td>"+matrizPuntosRutas[i][3]+"</td>";
		tablaRuta +="<td>"+matrizPuntosRutas[i][4]+"</td>";
		tablaRuta +="<td>"+matrizPuntosRutas[i][5]+"</td>";
		tablaRuta +="<td>"+matrizPuntosRutas[i][6]+"</td>";
		tablaRuta +="<td>"+matrizPuntosRutas[i][7]+"</td>";
		tablaRuta +="</tr>";
	}
	tablaRuta += "</tbody>";		
	tablaRuta += "</table>";
	
	respuesta.innerHTML = tablaRuta;
}

function mensajeLeido(){
	$.ajax({
	    url: "controlador_c.php",
	    type: 'POST',
	    data: {transaccion:"mensajeLeido"},
	    dataType:"json",
	    success: function(data) {
	        
	        console.log(data);
	   	}
	});
}

function mensages(){
	//console.log("mensages");
	$.ajax({
	    url: "controlador_c.php",
	    type: 'POST',
	    data: {transaccion:"datosMensajes"},
	    dataType:"json",
	    success: function(data) {
	    	var resul = data;
	    	console.log("Numero mensajes: "+resul.length);
	    	console.log(resul);
	    	if(resul.length>=2){
	    		document.getElementById('id01').style.display='block';
		        var tablaMsg = "<table id='mensajes' class = 'tabla'>";
				tablaMsg += "<thead><h2 id='tituloTabla'>Mensajes entrantes</h2>";
				tablaMsg += "<tr>";
				tablaMsg += "<th>Fecha</th>";
				tablaMsg += "<th>Mensaje</th>";
				tablaMsg += "</tr>";
				tablaMsg += "</thead>";
				tablaMsg += "<tbody>";
		        for(i=0;i<resul.length;i++){
		        	partes = resul[i].split(";");
		        	if(partes.length ==3){
			        	//console.log(partes);
						tablaMsg += "<tr>";
						tablaMsg +="<td>"+partes[1]+" "+partes[0]+"</td>";
						tablaMsg +="<td>"+partes[2]+"</td>";
						tablaMsg +="</tr>";
					}
		    	}
		    	tablaMsg += "</tbody>";		
				tablaMsg += "</table>";
				$("#msg").html(tablaMsg);
				
		        //console.log(partes);
		        return;
	    	}
	   	}
	});
}

function objetoAJAX(){ // Obtiene el objeto AJAX del navegador
	if(window.XMLHttpRequest){ // Si es Chrome
		return new XMLHttpRequest();
	}else if(window.ActiveXObject){ // Si es IE
		return new ActiveXObject("Microsoft.XMLHTTP");
	}
}

function velocidad(){
	var datos = "transaccion=getVelocidad";
	ejecutarAJAX(datos);
}



//Eventos
window.addEventListener("load",alCargarDocumento);