<?php 

require_once "conexionLocal.php";
  
  
function aplicarCambiosWifi(){
	exec("sudo echo '1,0,0' > /var/www/html/RegislogWeb/variables/cambioWifi.txt",$return);
	return printf("WIFI-OK");
}

function aplicarCambiosAudios(){
	exec("sudo echo '1' > /var/www/html/RegislogWeb/variables/cambioAudio.txt",$return);
	return printf("AUDIOS-OK ".$return);
}

function grabarRecorrido(){
	exec("sudo echo '1' > /var/www/html/RegislogWeb/variables/grabarRecorrido.txt",$return);
	return printf("GRECORRIDO-OK ".$return);
}

function ejecutarSimulacion(){
	exec("sudo echo '1' > /var/www/html/RegislogWeb/variables/ejecutarSimulacion.txt",$return);
	return printf("SIMULACION-OK ".$return);
}
 
function ejecutarRecuperacion(){
	exec("sudo echo '1' > /var/www/html/RegislogWeb/variables/recuperacion.txt",$return);
	unlink("sudo /var/www/html/RegislogWeb/variables/RecuInfo.txt");
	while(!file_exists("/var/www/html/RegislogWeb/variables/RecuInfo.txt"));
	$fin = false;
	
	while($fin === false){
		sleep(1);
		$resultado = "";
		if ($file = fopen("/var/www/html/RegislogWeb/variables/RecuInfo.txt", "r")) {
			while(!feof($file)){
				$line = fgets($file);
				$resultado .= "<div>".$line."</div>";
				if(strpos($line,"terminado") !== false){
					$fin = true;
					break;
				}
			}
			fclose($file);
		} 
	} 
	printf($resultado);
}

function borrarAlarmas(){
 	try{
		$sql = "DELETE FROM tablaAlarmas";
		$midb = conexionLocalSQLite3();
		$midb->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
		$results = $midb->prepare($sql);
		$results->execute();
		if($results){
			$respuesta = "<div class='exito' data-recargar>Se eliminó la tabla correctamente</div>";
		}else{
			$respuesta = "<div class='error' data-recargar>Ocurrio un error. No se eliminó la tabla</div>";
		}
		$results = null;
		$midb = null;
		return printf($respuesta);
	}catch(PDOException $e) {
    	echo "Lo siento hay un error.  ". $e->getMessage() ;// Remove or modify after testing 
    	file_put_contents('PDOErrors.txt',date('[Y-m-d H:i:s]').", modelo.php, ". $e->getMessage()."\r\n", FILE_APPEND);  
 	}
}

function borrarProgramacionAudios(){
 	try{
		$sql = "DELETE FROM mensajesAudio";
		$midb = conexionLocalSQLite3();
		$midb->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
		$results = $midb->prepare($sql);
		$results->execute();
		if($results){
			$respuesta = "AUDIOS-OK";
		}else{
			$respuesta = "AUDIOS-ERROR";
		}
		$results = null;
		$midb = null;
		return printf($respuesta);
	}catch(PDOException $e) {
    	echo "Lo siento hay un error.  ". $e->getMessage() ;// Remove or modify after testing 
    	file_put_contents('PDOErrors.txt',date('[Y-m-d H:i:s]').", modelo.php, ". $e->getMessage()."\r\n", FILE_APPEND);  
 	}
}

function borrarHistoricos(){
 	try{
		$sql = "DELETE FROM tablaHistoricos";
		$midb = conexionLocalSQLite3();
		$midb->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
		$results = $midb->prepare($sql);
		$results->execute();
		if($results){
			$respuesta = "<div class='exito' data-recargar>Se eliminó la tabla correctamente</div>";
		}else{
			$respuesta = "<div class='error' data-recargar>Ocurrio un error. No se eliminó la tabla</div>";
		}
		$results = null;
		$midb = null;
		return printf($respuesta);
	}catch(PDOException $e) {
    	echo "Lo siento hay un error.  ". $e->getMessage() ;// Remove or modify after testing 
    	file_put_contents('PDOErrors.txt',date('[Y-m-d H:i:s]').", modelo.php, ". $e->getMessage()."\r\n", FILE_APPEND);  
 	}
}

function borrarRedWifi($red){
 	//print_r("Borrando red wifi");
	if(strcmp("sun8i", $so_board) !== false){
		exec('sudo nmcli connection delete id '.$red,$result);
		print_r('borrarRedWifi-OK&'.$result[0]);
	}
}

function borrarLogs($red){
 	
	exec('sudo rm /var/www/html/RegislogWeb/Logs/*',$result);
	print_r('borrarLogs-OK&'.$result[0]);
	
}
  
function conectarRedWifi($idRedWifi){
	exec("echo '2,".$idRedWifi.",0' > /var/www/html/RegislogWeb/variables/cambioWifi.txt",$return);
}

function datosConteo($fechaInicial,$horaInicial,$fechaFinal,$horaFinal){
	try{
		$midb = conexionLocalSQLite3();
		$midb->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
		$results = $midb->prepare("SELECT * FROM tablaLogGps WHERE fecha >= '".$fechaInicial." ".$horaInicial."' AND fecha <= '".$fechaFinal." ".$horaFinal."' ORDER BY fecha"); 
		$results->setFetchMode(PDO::FETCH_ASSOC);
		$results->execute();
		$file = 0;
		if($results){
			while($fila = $results->fetch()){
				$matriz[$file][0] = $fila['latitud'];
				$matriz[$file][1] = $fila['longitud'];
				$matriz[$file][2] = $fila['velocidad'];
				$matriz[$file][3] = $fila['fecha'];
				$matriz[$file][4] = $fila['numeracion'];
				$matriz[$file][5] = $fila['total_dia'];
				$matriz[$file][6] = $fila['entradas'];
				$matriz[$file][7] = $fila['salidas'];
				$matriz[$file][8] = $fila['bufferSalidaGPS'];
				$file++;
			}
		}
		//Cierra la conexión con la base de datos
		$results = null;
		$midb = null;
		//echo json_encode($matriz);
	    print json_encode($matriz);
	}catch(PDOException $e) {
    	echo "Lo siento hay un error en BD..  ". $e->getMessage() ;// Remove or modify after testing 
    	file_put_contents('PDOErrors.txt',date('[Y-m-d H:i:s]').", myfile.php, ". $e->getMessage()."\r\n", FILE_APPEND);  
 	}
}

function editarContadoresExe($numeracion,$totalDia,$entradas,$salidas){
	try{
		$midb = conexionLocalSQLite3();
		
		$sql = "UPDATE REGISTROS_CONTEO SET NUMERACION = :numeracion, TOTAL_DIA = :totalDia, ENTRADAS = :entradas, SALIDAS = :salidas WHERE ID = 0";
		$midb->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
		$results = $midb->prepare($sql);
		$results->bindParam(':numeracion',$numeracion, PDO::PARAM_INT);
		$results->bindParam(':totalDia',$totalDia, PDO::PARAM_INT);
		$results->bindParam(':entradas',$entradas, PDO::PARAM_INT);
		$results->bindParam(':salidas',$salidas, PDO::PARAM_INT);

		$results->execute();

		if($results){
			$respuesta .= "<div class='exito' data-recargar>Se insertó con exito los nuevos datos del los contadores</div>";
		}else{
			$respuesta .= "<div class='error' data-recargar>Ocurrio un error. No se insertó el registro</div>";
			$results = null;
			$midb = null;
			return printf($respuesta);
		}

		
	
		$sql = "UPDATE tablaConfiguracion SET borrar_contadores = 2";
		//$midb->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
		$results = $midb->prepare($sql);
		//$results->bindParam(':borrar_contadores',2, PDO::PARAM_INT);
		$results->execute();
		if($results){
			$respuesta .= "<div class='exito' data-recargar>Se insertó con exito editar contadores </div>";
		}else{
			$respuesta .= "<div class='error' data-recargar>Ocurrio un error. No se insertó el registro editar contadores</div>";
			$results = null;
			$midb = null;
			return printf($respuesta);
		}

		$sql = "UPDATE tablaConfiguracion SET estado = 1";
		//$midb->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
		$results = $midb->prepare($sql);
		//$results->bindParam(':estado','1', PDO::PARAM_STR);
		$results->execute();
		if($results){
			$respuesta .= "<div class='exito' data-recargar>Se insertó con exito el estado </div>";
		}else{
			$respuesta .= "<div class='error' data-recargar>Ocurrio un error. No se insertó el registro estado</div>";
			$results = null;
			$midb = null;
			return printf($respuesta);
		}
		

	}catch(PDOException $e) {
    	echo "Lo siento hay un error.  ". $e->getMessage() ;// Remove or modify after testing 
    	file_put_contents('PDOErrors.txt',date('[Y-m-d H:i:s]').", modelo.php, ". $e->getMessage().$sql."\r\n", FILE_APPEND);  
 	}

 	exec('sudo pkill -9 -f OrangeWifi.jar');
	exec('sudo pkill -9 -f RV60.jar');
	exec('sudo java -jar /home/root/NetBeansProjects/OrangeWifi/dist/OrangeWifi.jar > /dev/null 2>/dev/null &');
	exec('sudo java -jar /home/root/NetBeansProjects/RV60_OrangePi/dist/RV60.jar > /dev/null 2>/dev/null &');
 	
 	return printf($respuesta);
 	$results = null;
	$midb = null;
}

function editarDatosUsuario($usuario,$clave){
	
	try{
		$midb = conexionLocalSQLite3();
		$nRows = $midb->query("SELECT COUNT(*) FROM usuarios WHERE tipo='1'")->fetchColumn(); 
		if($nRows >0){
			
			$sql = "UPDATE usuarios SET nombre = :nombre, clave = :clave WHERE tipo='1'";
			$midb->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
			$results = $midb->prepare($sql);
			$results->bindParam(':nombre',$usuario, PDO::PARAM_STR);
			$results->bindParam(':clave',$clave, PDO::PARAM_STR);
			$results->execute();
			if($results){
				$respuesta .= "OK";
			}else{
				$respuesta .= "ERROR";
				$results = null;
				$midb = null;
				//return printf($respuesta);
			}
		}else{
			
			$sql = "INSERT INTO usuarios (nombre, clave, tipo) VALUES (:nombre,:clave,'1')";
			$midb = conexionLocalSQLite3();
			$midb->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
			$results = $midb->prepare($sql);
			$results->bindParam(':nombre',$usuario, PDO::PARAM_STR);
			$results->bindParam(':clave',$clave, PDO::PARAM_STR);
			$results->execute();
			if($results){
				$respuesta .= "OK";
			}else{
				$respuesta .= "ERROR";
				$results = null;
				$midb = null;
				//return printf($respuesta);
			}
			$results = null;
			$midb = null;
			//return printf($respuesta);
		}
		
		
	}catch(PDOException $e) {
    	echo "Lo siento hay un error.  ". $e->getMessage() ;// Remove or modify after testing 
    	file_put_contents('PDOErrors.txt',date('[Y-m-d H:i:s]').", modelo.php, ". $e->getMessage().$sql."\r\n", FILE_APPEND);  
 	}
 	
 	return printf($respuesta);
 	$results = null;
	$midb = null;
}

function editarPermisosUsuario($permisos){
	//echo "Editando permisos";
	try{
		$midb = conexionLocalSQLite3();
		$nRows = $midb->query("SELECT COUNT(*) FROM usuarios  WHERE tipo='1'")->fetchColumn(); 
		if($nRows >0){
			$sql = "UPDATE usuarios SET permisos = :permisos WHERE tipo='1'";
			$midb->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
			$results = $midb->prepare($sql);
			$results->bindParam(':permisos',$permisos, PDO::PARAM_STR);
			$results->execute();
			if($results){
				$respuesta .= "OK";
			}else{
				$respuesta .= "ERROR";
				$results = null;
				$midb = null;
				return printf($respuesta);
			}
		}else{
			$sql = "INSERT INTO usuarios (permisos) VALUES (:permisos)";
			$midb = conexionLocalSQLite3();
			$midb->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
			$results = $midb->prepare($sql);
			$results->bindParam(':permisos',$permisos, PDO::PARAM_STR);
			$results->execute();
			if($results){
				$respuesta .= "OK";
			}else{
				$respuesta .= "ERROR";
				$results = null;
				$midb = null;
				return printf($respuesta);
			}
			$results = null;
			$midb = null;
			return printf($respuesta);
		}
		
		
	}catch(PDOException $e) {
    	echo "Lo siento hay un error.  ". $e->getMessage() ;// Remove or modify after testing 
    	file_put_contents('PDOErrors.txt',date('[Y-m-d H:i:s]').", modelo.php, ". $e->getMessage().$sql."\r\n", FILE_APPEND);  
 	}
 	
 	return printf($respuesta);
 	$results = null;
	$midb = null;
}

function enviarTrama($trama){
	//print_r("SELECT * FROM tablaLogGps WHERE fecha >= '".$fechaInicial." ".$horaInicial."' AND fecha <= '".$fechaFinal." ".$horaFinal."' ORDER BY fecha");
    try{
		//Carga las redes almacenadas en base de datos
		$midb = conexionLocalSQLite3();
		$midb->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
		$results = $midb->prepare("SELECT * FROM tablaConfiguracion"); 
		$results->setFetchMode(PDO::FETCH_ASSOC);
		$results->execute();
		if($results){
			while($response = $results->fetch()){
				$ip = $response['ip_servidor'];
				$puerto = $response['puerto_servidor'];
			}		
		}
	}catch(PDOException $e) {
    	echo "Lo siento hay un error en BD..  ". $e->getMessage() ;// Remove or modify after testing 
    	file_put_contents('PDOErrors.txt',date('[Y-m-d H:i:s]').", myfile.php, ". $e->getMessage()."\r\n", FILE_APPEND);  
 	}
 	$respuesta ="";
 	/* Crear un socket TCP/IP. */
	$socket = socket_create(AF_INET, SOCK_STREAM, SOL_TCP);
	if ($socket === false) {
	    $respuesta =  "ERROR-SOCKET socket_create() falló: razón: ".socket_strerror(socket_last_error());
	    return printf($respuesta);
	} else {
	    $respuesta = "OK-SOCKET";
	}

	
	$result = socket_connect($socket, $ip, $puerto);
	if ($result === false) {
	    $respuesta = "ERROR-SOCKET socket_connect razon:".socket_strerror(socket_last_error($socket));
	    return printf($respuesta);
	} else {
	    $respuesta = "OK-SOCKET";
	}
	$trama1 = $trama."\n";
	socket_write($socket, $trama1, strlen($trama1));

	$out = socket_read($socket,2048, PHP_NORMAL_READ);
	return printf($respuesta."&".$out);
}
//Función que envia los datos del usuario
function datosUsuario(){
	//echo "permisosUsuario";
	try{
		$midb = conexionLocalSQLite3();
		$midb->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
		$results = $midb->prepare("SELECT * FROM usuarios WHERE tipo='1'"); 
		$results->setFetchMode(PDO::FETCH_ASSOC);
		$results->execute();
		
		if($results){
			while($fila = $results->fetch()){
				$nombre = $fila['nombre'];
				$clave = $fila['clave'];
			}
		}
		//Cierra la conexión con la base de datos
		$results = null;
		$midb = null;
		//echo json_encode($matriz);
	    printf("OK,".$nombre.",".$clave);
	    return;
	}catch(PDOException $e) {
    	echo "Lo siento hay un error en BD..  ". $e->getMessage() ;// Remove or modify after testing 
    	file_put_contents('PDOErrors.txt',date('[Y-m-d H:i:s]').", modelo.php, ". $e->getMessage()."\r\n", FILE_APPEND);  
 	}
 	printf("ERROR");
}

function insertarHistorico($fecha,$totalDia){
	try{
		$sql = "INSERT INTO tablaHistoricos (fecha, total_dia, fecha_ingreso) VALUES (:fecha,:totalDia,:fecha_act)";
		$midb = conexionLocalSQLite3();
		$midb->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
		$results = $midb->prepare($sql);
		$results->bindParam(':fecha',$fecha, PDO::PARAM_STR);
		$results->bindParam(':totalDia',$totalDia, PDO::PARAM_INT);
		$results->bindParam(':fecha_act',$fecha, PDO::PARAM_STR);
		$results->execute();
		if($results){
			$respuesta = "<div class='exito' data-recargar>Se insertó con exito el nuevo historico </div>";
		}else{
			$respuesta = "<div class='error' data-recargar>Ocurrio un error. No se insertó el registro</div>";
		}
		$results = null;
		$midb = null;
		return printf($respuesta);
	}catch(PDOException $e) {
    	echo "Lo siento hay un error.  ". $e->getMessage() ;// Remove or modify after testing 
    	file_put_contents('PDOErrors.txt',date('[Y-m-d H:i:s]').", modelo.php, ". $e->getMessage()."\r\n", FILE_APPEND);  
 	}
 }

function insertarConfiguracion($numero_puertas,$ip_servidor,$puerto_servidor,$firmware,$sentido,$placa,$utc,$regisdata,$estado,$borrarContadores,$trama_gps,
			$descuento,$volumen,$limiteVelocidad,$horaHibernacion,$duracionHibernacion,$display,$alarmaPuerta,$velAlarmaPuerta,$msgAlarmaPuerta,
			$permisosAlarmas,$CambioPermisosAlarmas,$activarHibernacion,$retardoDesactivacionSensores){
	
	try{
		$midb = conexionLocalSQLite3();
		$sql = "UPDATE tablaConfiguracion SET numero_puertas = :numero_puertas";
		$midb->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
		$results = $midb->prepare($sql);
		$results->bindParam(':numero_puertas',$numero_puertas, PDO::PARAM_STR);
		$results->execute();
		$respuesta = "<div>result_config</div>";
		if($results){
			$respuesta .= "<div class='exito' data-recargar>Se insertó con exito el numero de puertas </div>";
		}else{
			$respuesta .= "<div class='error' data-recargar>Ocurrio un error. No se insertó el registro numero de puertas</div>";
			$results = null;
			$midb = null;
			return printf($respuesta);
		}
		$sql = "UPDATE tablaConfiguracion SET ip_servidor = :ip_servidor";
		$midb->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
		$results = $midb->prepare($sql);
		$results->bindParam(':ip_servidor',$ip_servidor, PDO::PARAM_STR);
		$results->execute();
		if($results){
			$respuesta .= "<div class='exito' data-recargar>Se insertó con exito la ip del servidor </div>";
		}else{
			$respuesta .= "<div class='error' data-recargar>Ocurrio un error. No se insertó el registro ip servidor</div>";
			$results = null;
			$midb = null;
			return printf($respuesta);
		}
		$sql = "UPDATE tablaConfiguracion SET puerto_servidor = :puerto_servidor";
		$midb->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
		$results = $midb->prepare($sql);
		$results->bindParam(':puerto_servidor',$puerto_servidor, PDO::PARAM_STR);
		$results->execute();
		if($results){
			$respuesta .= "<div class='exito' data-recargar>Se insertó con exito el puerto del servidor </div>";
		}else{
			$respuesta .= "<div class='error' data-recargar>Ocurrio un error. No se insertó el registro puerto servidor</div>";
			$results = null;
			$midb = null;
			return printf($respuesta);
		}
		$sql = "UPDATE tablaConfiguracion SET sentido = :sentido";
		$midb->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
		$results = $midb->prepare($sql);
		$results->bindParam(':sentido',$sentido, PDO::PARAM_STR);
		$results->execute();
		if($results){
			$respuesta .= "<div class='exito' data-recargar>Se insertó con exito el sentido </div>";
		}else{
			$respuesta .= "<div class='error' data-recargar>Ocurrio un error. No se insertó el registro sentido</div>";
			$results = null;
			$midb = null;
			return printf($respuesta);
		}
		$sql = "UPDATE tablaConfiguracion SET placa = :placa";
		$midb->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
		$results = $midb->prepare($sql);
		$results->bindParam(':placa',$placa, PDO::PARAM_STR);
		$results->execute();
		if($results){
			$respuesta .= "<div class='exito' data-recargar>Se insertó con exito el placa </div>";
		}else{
			$respuesta .= "<div class='error' data-recargar>Ocurrio un error. No se insertó el registro placa</div>";
			$results = null;
			$midb = null;
			return printf($respuesta);
		}
		$sql = "UPDATE tablaConfiguracion SET utc = :utc";
		$midb->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
		$results = $midb->prepare($sql);
		$results->bindParam(':utc',$utc, PDO::PARAM_STR);
		$results->execute();
		if($results){
			$respuesta .= "<div class='exito' data-recargar>Se insertó con exito el utc </div>";
		}else{
			$respuesta .= "<div class='error' data-recargar>Ocurrio un error. No se insertó el registro utc</div>";
			$results = null;
			$midb = null;
			return printf($respuesta);
		}
		$sql = "UPDATE tablaConfiguracion SET regisdata = :regisdata";
		$midb->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
		$results = $midb->prepare($sql);
		$results->bindParam(':regisdata',$regisdata, PDO::PARAM_STR);
		$results->execute();
		if($results){
			$respuesta .= "<div class='exito' data-recargar>Se insertó con exito el regisdata </div>";
		}else{
			$respuesta .= "<div class='error' data-recargar>Ocurrio un error. No se insertó el registro regisdata</div>";
			$results = null;
			$midb = null;
			return printf($respuesta);
		}
		$sql = "UPDATE tablaConfiguracion SET estado = :estado";
		$midb->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
		$results = $midb->prepare($sql);
		$results->bindParam(':estado',$estado, PDO::PARAM_STR);
		$results->execute();
		if($results){
			$respuesta .= "<div class='exito' data-recargar>Se insertó con exito el estado </div>";
		}else{
			$respuesta .= "<div class='error' data-recargar>Ocurrio un error. No se insertó el registro estado</div>";
			$results = null;
			$midb = null;
			return printf($respuesta);
		}
		$sql = "UPDATE tablaConfiguracion SET borrar_contadores = :borrarContadores";
		$midb->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
		$results = $midb->prepare($sql);
		$results->bindParam(':borrarContadores',$borrarContadores, PDO::PARAM_STR);
		$results->execute();
		if($results){
			$respuesta .= "<div class='exito' data-recargar>Se insertó con exito el borrado de los contadores </div>";
		}else{
			$respuesta .= "<div class='error' data-recargar>Ocurrio un error. No se insertó el borrado de los contadores</div>";
			$results = null;
			$midb = null;
			return printf($respuesta);
		}
		$sql = "UPDATE tablaConfiguracion SET trama_gps = :tramaGps";
		$midb->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
		$results = $midb->prepare($sql);
		if($trama_gps == null) $trama_gps = '0';
		$results->bindParam(':tramaGps',$trama_gps, PDO::PARAM_STR);
		$results->execute();
		if($results){
			$respuesta .= "<div class='exito' data-recargar>Se insertó con exito la trama Gps </div>";
		}else{
			$respuesta .= "<div class='error' data-recargar>Ocurrio un error. No se insertó la trama GPS</div>";
			$results = null;
			$midb = null;
			return printf($respuesta);
		}
		switch ($descuento) {
			case '25':
				$descuento = '1';
				break;
			case '50':
				$descuento = '2';
				break;
			case '100':
				$descuento = '3';
				break;	
			default:
			 	$descuento = '1';	
			
		}
		$sql = "UPDATE tablaConfiguracion SET descuento = :descuento";
		$midb->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
		$results = $midb->prepare($sql);
		$results->bindParam(':descuento',$descuento, PDO::PARAM_STR);
		$results->execute();
		if($results){
			$respuesta .= "<div class='exito' data-recargar>Se insertó con exito el descuento </div>";
		}else{
			$respuesta .= "<div class='error' data-recargar>Ocurrio un error. No se insertó el descuento</div>";
			$results = null;
			$midb = null;
			return printf($respuesta);
		}
		$sql = "UPDATE tablaConfiguracion SET volumen = :volumen";
		$midb->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
		$results = $midb->prepare($sql);
		if($volumen == null) $volumen = '100';
		$results->bindParam(':volumen',$volumen, PDO::PARAM_STR);
		$results->execute();
		if($results){
			$respuesta .= "<div class='exito' data-recargar>Se insertó con exito el volumen </div>";
		}else{
			$respuesta .= "<div class='error' data-recargar>Ocurrio un error. No se insertó el volumen</div>";
			$results = null;
			$midb = null;
			return printf($respuesta);
		}
		$sql = "UPDATE tablaConfiguracion SET limiteVelocidad = :limiteVelocidad";
		$midb->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
		$results = $midb->prepare($sql);
		if($limiteVelocidad == null) $limiteVelocidad = '60';
		$results->bindParam(':limiteVelocidad',$limiteVelocidad, PDO::PARAM_STR);
		$results->execute();
		if($results){
			$respuesta .= "<div class='exito' data-recargar>Se insertó con exito el limite de velocidad </div>";
		}else{
			$respuesta .= "<div class='error' data-recargar>Ocurrio un error. No se insertó el limite de velocidad</div>";
			$results = null;
			$midb = null;
			return printf($respuesta);
		}
		
		if($horaHibernacion != null){
			$sql = "UPDATE tablaConfiguracion SET horaHibernacion = :horaHibernacion";
			$midb->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
			$results = $midb->prepare($sql);
			$results->bindParam(':horaHibernacion',$horaHibernacion, PDO::PARAM_STR);
			$results->execute();
			if($results){
				$respuesta .= "<div class='exito' data-recargar>Se insertó con exito la hora de la hibernacion </div>";
			}else{
				$respuesta .= "<div class='error' data-recargar>Ocurrio un error. No se insertó la hora de la hibernacion</div>";
				$results = null;
				$midb = null;
				return printf($respuesta);
			}
		}
		
		if($duracionHibernacion != null){
			$sql = "UPDATE tablaConfiguracion SET duracionHibernacion = :duracionHibernacion";
			$midb->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
			$results = $midb->prepare($sql);
			$results->bindParam(':duracionHibernacion',$duracionHibernacion, PDO::PARAM_STR);
			$results->execute();
			if($results){
				$respuesta .= "<div class='exito' data-recargar>Se insertó con exito la duracion de la hibernacion </div>";
			}else{
				$respuesta .= "<div class='error' data-recargar>Ocurrio un error. No se insertó la duracion de la hibernacion</div>";
				$results = null;
				$midb = null;
				return printf($respuesta);
			}
		}
		
		if($display != null){
			$sql = "UPDATE tablaConfiguracion SET display = :display";
			$midb->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
			$results = $midb->prepare($sql);
			$results->bindParam(':display',$display, PDO::PARAM_STR);
			$results->execute();
			if($results){
				$respuesta .= "<div class='exito' data-recargar>Se insertó con exito la opcion display </div>";
			}else{
				$respuesta .= "<div class='error' data-recargar>Ocurrio un error. No se insertó la opcion display</div>";
				$results = null;
				$midb = null;
				return printf($respuesta);
			}
		}
		
		if($alarmaPuerta != null){
			$sql = "UPDATE tablaConfiguracion SET alarmaPuerta = :alarmaPuerta";
			$midb->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
			$results = $midb->prepare($sql);
			$results->bindParam(':alarmaPuerta',$alarmaPuerta, PDO::PARAM_STR);
			$results->execute();
			if($results){
				$respuesta .= "<div class='exito' data-recargar>Se insertó con exito la opcion alarmaPuerta </div>";
			}else{
				$respuesta .= "<div class='error' data-recargar>Ocurrio un error. No se insertó la opcion alarmaPuerta</div>";
				$results = null;
				$midb = null;
				return printf($respuesta);
			}
		}
		
		if($velAlarmaPuerta != null){
			$sql = "UPDATE tablaConfiguracion SET velAlarmaPuerta = :velAlarmaPuerta";
			$midb->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
			$results = $midb->prepare($sql);
			$results->bindParam(':velAlarmaPuerta',$velAlarmaPuerta, PDO::PARAM_STR);
			$results->execute();
			if($results){
				$respuesta .= "<div class='exito' data-recargar>Se insertó con exito la opcion velAlarmaPuerta </div>";
			}else{
				$respuesta .= "<div class='error' data-recargar>Ocurrio un error. No se insertó la opcion velAlarmaPuerta</div>";
				$results = null;
				$midb = null;
				return printf($respuesta);
			}
		}
		   
		if($msgAlarmaPuerta != null){
			$sql = "UPDATE tablaConfiguracion SET msgAlarmaPuerta = :msgAlarmaPuerta";
			$midb->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
			$results = $midb->prepare($sql);
			$results->bindParam(':msgAlarmaPuerta',$msgAlarmaPuerta, PDO::PARAM_STR);
			$results->execute();
			if($results){
				$respuesta .= "<div class='exito' data-recargar>Se insertó con exito la opcion msgAlarmaPuerta </div>";
			}else{
				$respuesta .= "<div class='error' data-recargar>Ocurrio un error. No se insertó la opcion msgAlarmaPuerta</div>";
				$results = null;
				$midb = null;
				return printf($respuesta);
			}
		}
		 
		if($permisosAlarmas != null && $CambioPermisosAlarmas == null){
			$CambioPermisosAlarmas = '1';
			/*
			$sql = "UPDATE tablaConfiguracion SET permisosAlarmas = :permisosAlarmas";
			$midb->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
			$results = $midb->prepare($sql);
			$results->bindParam(':permisosAlarmas',$permisosAlarmas, PDO::PARAM_STR);
			$results->execute();
			if($results){
				$respuesta .= "<div class='exito' data-recargar>Se insertó con exito la opcion permisosAlarmas = $permisosAlarmas</div>";
			}else{
				$respuesta .= "<div class='error' data-recargar>Ocurrio un error. No se insertó la opcion permisosAlarmas</div>";
				$results = null;
				$midb = null;
				return printf($respuesta);
			}
			*/
		}
		 
		if($CambioPermisosAlarmas != null){
			$sql = "UPDATE tablaConfiguracion SET cambioPermisosAlarmas = :cambioPermisosAlarmas";
			$midb->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
			$results = $midb->prepare($sql);
			$results->bindParam(':cambioPermisosAlarmas',$CambioPermisosAlarmas, PDO::PARAM_STR);
			$results->execute();
			if($results){
				$respuesta .= "<div class='exito' data-recargar>Se insertó con exito la opcion cambioPermisosAlarmas </div>";
			}else{
				$respuesta .= "<div class='error' data-recargar>Ocurrio un error. No se insertó la opcion cambioPermisosAlarmas</div>";
				$results = null;
				$midb = null;
				return printf($respuesta);
			}
			if($permisosAlarmas != null){
				$sql = "UPDATE tablaConfiguracion SET permisosAlarmas = :permisosAlarmas";
				$midb->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
				$results = $midb->prepare($sql);
				$results->bindParam(':permisosAlarmas',$permisosAlarmas, PDO::PARAM_STR);
				$results->execute();
				if($results){
					$respuesta .= "<div class='exito' data-recargar>Se insertó con exito la opcion permisosAlarmas </div>";
				}else{
					$respuesta .= "<div class='error' data-recargar>Ocurrio un error. No se insertó la opcion permisosAlarmas</div>";
					$results = null;
					$midb = null;
					return printf($respuesta);
				}
			}
		}
		
		if($activarHibernacion != null){
			$sql = "UPDATE tablaConfiguracion SET activarHibernacion = :activarHibernacion";
			$midb->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
			$results = $midb->prepare($sql);
			$results->bindParam(':activarHibernacion',$activarHibernacion, PDO::PARAM_STR);
			$results->execute();
			if($results){
				$respuesta .= "<div class='exito' data-recargar>Se insertó con exito la opcion activarHibernacion </div>";
			}else{
				$respuesta .= "<div class='error' data-recargar>Ocurrio un error. No se insertó la opcion activarHibernacion</div>";
				$results = null;
				$midb = null;
				return printf($respuesta);
			}
		}
		
		if($retardoDesactivacionSensores != null){
			$sql = "UPDATE tablaConfiguracion SET retardoDesactSensor = :retardoDesactSensor";
			$midb->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
			$results = $midb->prepare($sql);
			$results->bindParam(':retardoDesactSensor',$retardoDesactivacionSensores, PDO::PARAM_STR);
			$results->execute();
			if($results){
				$respuesta .= "<div class='exito' data-recargar>Se insertó con exito la opcion retardoDesactSensor </div>";
			}else{
				$respuesta .= "<div class='error' data-recargar>Ocurrio un error. No se insertó la opcion retardoDesactSensor</div>";
				$results = null;
				$midb = null;
				return printf($respuesta);
			}
		}
		$results = null;
		$midb = null;
		//Modifica el nombre del host con los datos de la placa
		//modificarHostName($placa);
		$resultado = modificarHostName($placa);
		//echo $resultado;
		if($resultado == 'ERROR'){
                    return printf("No se insertó");
		}
                if($utc >= 0) $comando = "sudo timedatectl set-timezone Etc/GMT-".$utc;
                else{
                    $utc *= -1;
                    $comando = "sudo timedatectl set-timezone Etc/GMT+".$utc;
                } 
                exec($comando);
		return printf($respuesta);
	}catch(PDOException $e) 
        {
    	echo "Lo siento hay un error.  ". $e->getMessage() ;// Remove or modify after testing 
    	file_put_contents('PDOErrors.txt',date('[Y-m-d H:i:s]').", modelo.php, ". $e->getMessage()."\r\n", FILE_APPEND);  
 	}
 	
 	
 	$results = null;
	$midb = null;
 }


function eliminarHistorico($idHistorico){
 	try{
		$sql = "DELETE FROM tablaHistoricos WHERE id=$idHistorico";
		$midb = conexionLocalSQLite3();
		$midb->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
		$results = $midb->prepare($sql);
		$results->execute();
		if($results){
			$respuesta = "<div class='exito' data-recargar>Se eliminó el registro correctamente</div>";
		}else{
			$respuesta = "<div class='error' data-recargar>Ocurrio un error. No se eliminó el registro</div>";
		}
		$results = null;
		$midb = null;
		return printf($respuesta);
	}catch(PDOException $e) {
    	echo "Lo siento hay un error.  ". $e->getMessage() ;// Remove or modify after testing 
    	file_put_contents('PDOErrors.txt',date('[Y-m-d H:i:s]').", modelo.php, ". $e->getMessage()."\r\n", FILE_APPEND);  
 	}
}

function eliminarAlarma($idAlarma){
 	try{
		$sql = "DELETE FROM tablaAlarmas WHERE Primary_Key=$idAlarma";
		$midb = conexionLocalSQLite3();
		$midb->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
		$results = $midb->prepare($sql);
		$results->execute();
		if($results){
			$respuesta = "<div class='exito' data-recargar>Se eliminó el registro correctamente</div>";
		}else{
			$respuesta = "<div class='error' data-recargar>Ocurrio un error. No se eliminó el registro</div>";
		}
		$results = null;
		$midb = null;
		return printf($respuesta);
	}catch(PDOException $e) {
    	echo "Lo siento hay un error.  ". $e->getMessage() ;// Remove or modify after testing 
    	file_put_contents('PDOErrors.txt',date('[Y-m-d H:i:s]').", modelo.php, ". $e->getMessage()."\r\n", FILE_APPEND);  
 	}
}

function eliminarCamara($idCamara){
 	try{
		$sql = "DELETE FROM camarasIp WHERE Primary_Key=$idCamara";
		$midb = conexionLocalSQLite3();
		$midb->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
		$results = $midb->prepare($sql);
		$results->execute();
		if($results){
			$respuesta = "<div class='exito' data-recargar>Se eliminó el registro correctamente</div>";
		}else{
			$respuesta = "<div class='error' data-recargar>Ocurrio un error. No se eliminó el registro</div>";
		}
		$results = null;
		$midb = null;
		return printf($respuesta);
	}catch(PDOException $e) {
    	echo "Lo siento hay un error.  ". $e->getMessage() ;// Remove or modify after testing 
    	file_put_contents('PDOErrors.txt',date('[Y-m-d H:i:s]').", modelo.php, ". $e->getMessage()."\r\n", FILE_APPEND);  
 	}
}

function eliminarVideo($idVideo){
 	try{
		$midb = conexionLocalSQLite3();
		$midb->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
		$results = $midb->prepare("SELECT * FROM listadoVideos WHERE Primary_Key=".$idVideo); 
		$results->setFetchMode(PDO::FETCH_ASSOC);
		$results->execute();
		if($results){
			while($fila = $results->fetch()){
				$ruta = $fila['ruta'];
			}
		}
		exec("sudo rm ".$ruta); //Elimina el video en el disco
		$sql = "DELETE FROM listadoVideos WHERE Primary_Key=".$idVideo;
		$results = $midb->prepare($sql);
		$results->execute();
		if($results){
			$respuesta = "<div class='exito' data-recargar>Se eliminó el video - $ruta</div>";
		}else{
			$respuesta = "<div class='error' data-recargar>Ocurrio un error. No se eliminó el video</div>";
		}
		$results = null;
		$midb = null;
		return printf($respuesta);
	}catch(PDOException $e) {
    	echo "Lo siento hay un error.  ". $e->getMessage() .$sql;// Remove or modify after testing 
    	file_put_contents('PDOErrors.txt',date('[Y-m-d H:i:s]').", modelo.php, ". $e->getMessage()."\r\n", FILE_APPEND);  
 	}
}


function eliminarProgramacionAudio($idProgramacionAudio){
 	try{
		$sql = "DELETE FROM mensajesAudio WHERE Primary_Key=$idProgramacionAudio";
		$midb = conexionLocalSQLite3();
		$midb->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
		$results = $midb->prepare($sql);
		$results->execute();
		if($results){
			$respuesta = "<div class='exito' data-recargar>Se eliminó el registro correctamente</div>";
		}else{
			$respuesta = "<div class='error' data-recargar>Ocurrio un error. No se eliminó el registro</div>";
		}
		$results = null;
		$midb = null;
		return printf($respuesta);
	}catch(PDOException $e) {
    	echo "Lo siento hay un error.  ". $e->getMessage() ;// Remove or modify after testing 
    	file_put_contents('PDOErrors.txt',date('[Y-m-d H:i:s]').", modelo.php, ". $e->getMessage()."\r\n", FILE_APPEND);  
 	}
}

function eliminarRedWifi($idRedWifi){
 	try{
		$sql = "DELETE FROM conexionesWifi WHERE Primary_Key=$idRedWifi";
		print_r($sql);
		$midb = conexionLocalSQLite3();
		$midb->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
		$results = $midb->prepare($sql);
		$results->execute();
		if($results){
			$respuesta = "<div class='exito' data-recargar>Se eliminó el registro correctamente</div>";
		}else{
			$respuesta = "<div class='error' data-recargar>Ocurrio un error. No se eliminó el registro</div>";
		}
		$results = null;
		$midb = null;
		return printf($respuesta);
	}catch(PDOException $e) {
    	echo "Lo siento hay un error.  ". $e->getMessage() ;// Remove or modify after testing 
    	file_put_contents('PDOErrors.txt',date('[Y-m-d H:i:s]').", modelo.php, ". $e->getMessage()."\r\n", FILE_APPEND);  
 	}
}

function actualizarRedWifi($idRedWifi,$ssid,$clave,$metodo,$tipo,$ip,$mask,$gateway,$dns){
 	try{
		$sql = "UPDATE conexionesWifi SET ssid='".$ssid."', clave='".$clave."', metodo='".$metodo."', tipo='".$tipo."', ip='".$ip."', mask='".$mask."', gateway='".$gateway."', dns='".$dns."'  WHERE Primary_Key=$idRedWifi";
		print_r($sql);
		$midb = conexionLocalSQLite3();
		$midb->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
		$results = $midb->prepare($sql);
		$results->execute();
		if($results){
			$respuesta = "OK";
		}else{
			$respuesta = "ERROR";
		}
		$results = null;
		$midb = null;
		return printf($respuesta);
	}catch(PDOException $e) {
    	echo "ERROR....Lo siento hay un error.  ". $e->getMessage() ;// Remove or modify after testing 
    	file_put_contents('PDOErrors.txt',date('[Y-m-d H:i:s]').", modelo.php, ". $e->getMessage()."\r\n", FILE_APPEND);		
		return printf("ERROR....Lo siento hay un error.  ". $e->getMessage());
	}
	
}

function guardarIpConfig($ipConfig,$direccion,$mascara,$gateway){
	if($ipConfig=="DINAMICA"){
		$config = "source-directory /etc/network/interfaces.d"."\n";
		$config .= "auto wlan0"."\n";
		$config .= "allow-hotplug wlan0"."\n";
		$config .= "iface wlan0 inet manual"."\n";
		$config .= "wpa-roam /etc/wpa_supplicant/wpa_supplicant.conf"."\n";
		$config .= "iface default inet dhcp"."\n";
	}else{
		$config = "source-directory /etc/network/interfaces.d"."\n";
		$config .= "allow-hotplug wlan0"."\n";
		$config .= "iface wlan0 inet static"."\n";
		$config .= "address ".$direccion."\n";
		$config .= "netmask ".$mascara."\n";
		$config .= "gateway ".$gateway."\n";
		$config .= "wpa-conf /etc/wpa_supplicant/wpa_supplicant.conf"."\n";
	}
	exec("echo '$config' > /tmp/ipconfig",$return);
	system('sudo cp /tmp/ipconfig /etc/network/interfaces',$returnval);
	if($returnval == 0) {
		exec("sudo chmod 777 /etc/network/interfaces",$returnval);
		printf("CONFIGIP-OK");
	} else {
		printf("CONFIGIP-ERROR");
	}
}

function guardarAudio($audio,$intervalo,$fechaInicial,$fechaFinal,$volumen){
	try{
		$midb = conexionLocalSQLite3();
		$nRows = $midb->query("SELECT COUNT(*) FROM mensajesAudio WHERE nombre = '".$audio."'")->fetchColumn(); 
		if($nRows >0){
			$sql = "UPDATE mensajesAudio SET intervalo = :intervalo, fecha_inicial = :fecha_inicial, fecha_final = :fecha_final, volumen = :volumen WHERE nombre = :audio";
			$midb->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
			$results = $midb->prepare($sql);
			$results->bindParam(':audio',$audio, PDO::PARAM_STR);
			$results->bindParam(':intervalo',$intervalo, PDO::PARAM_STR);
			$results->bindParam(':fecha_inicial',$fechaInicial, PDO::PARAM_STR);
			$results->bindParam(':fecha_final',$fechaFinal, PDO::PARAM_STR);
			$results->bindParam(':volumen',$volumen, PDO::PARAM_STR);
			$results->execute();
	
			if($results){
				$respuesta .= "<div class='exito' data-recargar>Se insertó con exito la configuración del audio</div>";
			}else{
				$respuesta .= "<div class='error' data-recargar>Ocurrio un error. No se insertó el registro</div>";
				$results = null;
				$midb = null;
				return printf($respuesta);
			}
		}else{
			$sql = "INSERT INTO mensajesAudio (nombre, intervalo, fecha_inicial, fecha_final, volumen) VALUES (:audio,:intervalo,:fecha_inicial,:fecha_final,:volumen)";
			$midb = conexionLocalSQLite3();
			$midb->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
			$results = $midb->prepare($sql);
			$results->bindParam(':audio',$audio, PDO::PARAM_STR);
			$results->bindParam(':intervalo',$intervalo, PDO::PARAM_STR);
			$results->bindParam(':fecha_inicial',$fechaInicial, PDO::PARAM_STR);
			$results->bindParam(':fecha_final',$fechaFinal, PDO::PARAM_STR);
			$results->bindParam(':volumen',$volumen, PDO::PARAM_STR);
			$results->execute();
			if($results){
				$respuesta .= "<div class='exito' data-recargar>Se insertó con exito la configuración del audio</div>";
			}else{
				$respuesta .= "<div class='error' data-recargar>Ocurrio un error. No se insertó el registro</div>";
				$results = null;
				$midb = null;
				return printf($respuesta);
			}
			$results = null;
			$midb = null;
			return printf($respuesta);
		}
		
		
	}catch(PDOException $e) {
    	echo "Lo siento hay un error.  ". $e->getMessage() ;// Remove or modify after testing 
    	file_put_contents('PDOErrors.txt',date('[Y-m-d H:i:s]').", modelo.php, ". $e->getMessage().$sql."\r\n", FILE_APPEND);  
 	}
 	
 	return printf($respuesta);
 	$results = null;
	$midb = null;
 }

function guardarIpConfigBD($ssid,$clave,$tipo,$ipConfig,$ip,$mascara,$gateway,$dns){
	if($ipconfig == "DINAMICA"){
		$ip = "";
		$mascara = "";
		$gateway = "";
		$dns = "";
	}
	try{
		$sql = "INSERT INTO conexionesWifi (ssid, clave, metodo, tipo, ip, mask, gateway, dns) VALUES (:ssid,:clave,:metodo,:tipo,:ip,:mask,:gateway,:dns)";
		$midb = conexionLocalSQLite3();
		$midb->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
		$results = $midb->prepare($sql);
		$results->bindParam(':ssid',$ssid, PDO::PARAM_STR);
		$results->bindParam(':clave',$clave, PDO::PARAM_STR);
		$results->bindParam(':metodo',$ipConfig, PDO::PARAM_STR);
		$results->bindParam(':tipo',$tipo, PDO::PARAM_STR);
		$results->bindParam(':ip',$ip, PDO::PARAM_STR);
		$results->bindParam(':mask',$mascara, PDO::PARAM_STR);
		$results->bindParam(':gateway',$gateway, PDO::PARAM_STR);
		$results->bindParam(':dns',$dns, PDO::PARAM_STR);
		$results->execute();
		if($results){
			$respuesta = "<div class='exito' data-recargar>Se insertó con exito la nueva red wifi </div>"."WIFI-OK";
		}else{
			$respuesta = "<div class='error' data-recargar>Ocurrio un error. No se insertó la nueva red wifi</div>"."WIFI-ERROR";
		}
		$results = null;
		$midb = null;
		return printf($respuesta);
	}catch(PDOException $e) {
    	echo "Lo siento hay un error.  ". $e->getMessage() ;// Remove or modify after testing 
    	file_put_contents('PDOErrors.txt',date('[Y-m-d H:i:s]').", modelo.php, ". $e->getMessage()."\r\n", FILE_APPEND);  
 	}
}
//Función que prueba la camara
function probarCamara(){
    //$hoy = date('Y-m-d-G-i-s');
    $hoy = exec("date +'%Y-%m-%d-%H-%M-%S'");
    printf("<div>Probando la camara</div>");
    exec("sudo python /var/www/html/RegislogWeb/Python/grabarVideo.py 5 Video1de1prueba-".$hoy,$output);
    foreach($output as $a){
		if($a == 0){
			printf("<div style='color:red'>No se detecto camara de video</div>");
			return;
		}
		if($a == 2){
			printf("<div style='color:red'>Error al leer los datos de la camara</div>");
			return;
		}
	}
	printf("<div>Video generado</div>");
    exec("sudo ffmpeg -i /var/www/html/RegislogWeb/videos/Video1de1prueba-".$hoy.".avi /var/www/html/RegislogWeb/videos/Video1de1prueba-".$hoy.".mp4");
    printf("<div>Video en conversión</div>");  
    exec("rm /var/www/html/RegislogWeb/videos/Video1de1prueba-".$hoy.".avi");
    printf("<div>Video listo...!</div>");
    
}
//Función que almacena la configuracion de los videos
function confgVideos($activado,$aConteo,$tipoConteo,$tConteo,$aBloqueo,$tBloqueo,$aTapa,$tTapa,$aObstruido,$tObstruido,$limiteVideos){
    try{
            $midb = conexionLocalSQLite3();
            $nRows = $midb->query("SELECT COUNT(*) FROM configVideo")->fetchColumn(); 
            if($nRows >0){
                    $sql = "UPDATE configVideo SET activado = :activado, aConteo=:aConteo, tipoConteo=:tipoConteo, tConteo=:tConteo, aBloqueo=:aBloqueo, tBloqueo=:tBloqueo, aTapa=:aTapa, tTapa=:tTapa, aObstruido=:aObstruido, tObstruido=:tObstruido, limiteVideos=:limiteVideos";
                    $midb->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
                    $results = $midb->prepare($sql);
                    $results->bindParam(':activado',$activado, PDO::PARAM_STR);
                    $results->bindParam(':aConteo',$aConteo, PDO::PARAM_STR);
                    $results->bindParam(':tipoConteo',$tipoConteo, PDO::PARAM_STR);
                    $results->bindParam(':tConteo',$tConteo, PDO::PARAM_STR);
                    $results->bindParam(':aBloqueo',$aBloqueo, PDO::PARAM_STR);
                    $results->bindParam(':tBloqueo',$tBloqueo, PDO::PARAM_STR);
                    $results->bindParam(':aTapa',$aTapa, PDO::PARAM_STR);
                    $results->bindParam(':tTapa',$tTapa, PDO::PARAM_STR);
                    $results->bindParam(':aObstruido',$aObstruido, PDO::PARAM_STR);
                    $results->bindParam(':tObstruido',$tObstruido, PDO::PARAM_STR);
                    $results->bindParam(':limiteVideos',$limiteVideos, PDO::PARAM_STR);
                    $results->execute();

                    if($results){
                            $respuesta .= "OK";
                            exec("sudo echo '1' > /var/www/html/RegislogWeb/variables/cambioVideos.txt",$return);
                    }else{
                            $respuesta .= "ERROR";
                            $results = null;
                            $midb = null;
                            return printf($respuesta);
                    }
            }else{
                    $sql = "INSERT INTO configVideo (activado, aConteo, tipoConteo, tConteo, aBloqueo, tBloqueo, aTapa, tTapa, aObstruido, tObstruido, limiteVideos) VALUES (:activado,:aConteo,:tipoConteo,:tConteo,:aBloqueo,:tBloqueo,:aTapa,:tTapa,:aObstruido,:tObstruido,:limiteVideos)";
                    $midb = conexionLocalSQLite3();
                    $midb->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
                    $results = $midb->prepare($sql);
                    $results->bindParam(':activado',$activado, PDO::PARAM_STR);
                    $results->bindParam(':aConteo',$aConteo, PDO::PARAM_STR);
                    $results->bindParam(':tipoConteo',$tipoConteo, PDO::PARAM_STR);
                    $results->bindParam(':tConteo',$tConteo, PDO::PARAM_STR);
                    $results->bindParam(':aBloqueo',$aBloqueo, PDO::PARAM_STR);
                    $results->bindParam(':tBloqueo',$tBloqueo, PDO::PARAM_STR);
                    $results->bindParam(':aTapa',$aTapa, PDO::PARAM_STR);
                    $results->bindParam(':tTapa',$tTapa, PDO::PARAM_STR);
                    $results->bindParam(':aObstruido',$aObstruido, PDO::PARAM_STR);
                    $results->bindParam(':tObstruido',$tObstruido, PDO::PARAM_STR);
                    $results->bindParam(':limiteVideos',$limiteVideos, PDO::PARAM_STR);
                    $results->execute();
                    if($results){
                            $respuesta .= "OK";
                            exec("sudo echo '1' > /var/www/html/RegislogWeb/variables/cambioVideos.txt",$return);
                    }else{
                            $respuesta .= "ERROR";
                            $results = null;
                            $midb = null;
                            return printf($respuesta);
                    }
                    $results = null;
                    $midb = null;
                    
                    
                    return printf($respuesta);
            }
		
		
	}catch(PDOException $e) {
    	echo "Lo siento hay un error.  ". $e->getMessage() ;// Remove or modify after testing 
    	file_put_contents('PDOErrors.txt',date('[Y-m-d H:i:s]').", modelo.php, ". $e->getMessage().$sql."\r\n", FILE_APPEND);  
 	}
 	
 	return printf($respuesta);
 	$results = null;
	$midb = null;
}
function modificarHostName($hostname){
	
	$config = "127.0.0.1"."\t"."localhost\n";
	$config .= "::1"."\t\t"."localhost ip6-localhost ip6-loopback\n";
	$config .= "ff02::1"."\t\t"."ip6-allnodes\n";
	$config .= "ff02::2"."\t\t"."ip6-allrouters\n";
	$config .= "\n";
	$config .= "127.0.1.1"."\t".$hostname."\n";
	exec("echo '$config' > /tmp/hostname",$return);
	system('sudo cp /tmp/hostname /etc/hosts',$returnval);
	if($returnval == 0) {
		exec("sudo chmod 777 /etc/hosts",$returnval);
	} else {
		return "ERROR";
	}
	
	$config = $hostname;
	$comando = "sudo hostnamectl set-hostname ". $config;
	
	exec($comando,$returnval);
	/*
	exec("echo '$config' > /tmp/hostname1",$return);
	system('sudo cp /tmp/hostname1 /etc/hostname',$returnval);
	if($returnval == 0) {
		exec("sudo chmod 777 /etc/hostname",$returnval);
	} else {
		return "ERROR";
	}*/

	return "OK";
}
//Función que envia los permisos del usuario
function permisosUsuario(){
	//echo "permisosUsuario";
	try{
		$midb = conexionLocalSQLite3();
		$midb->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
		$results = $midb->prepare("SELECT * FROM usuarios"); 
		$results->setFetchMode(PDO::FETCH_ASSOC);
		$results->execute();
		
		if($results){
			while($fila = $results->fetch()){
				$permisos = $fila['permisos'];
			}
		}
		//Cierra la conexión con la base de datos
		$results = null;
		$midb = null;
		//echo json_encode($matriz);
	    print json_encode("OK,".$permisos);
	    return;
	}catch(PDOException $e) {
    	echo "Lo siento hay un error en BD..  ". $e->getMessage() ;// Remove or modify after testing 
    	file_put_contents('PDOErrors.txt',date('[Y-m-d H:i:s]').", modelo.php, ". $e->getMessage()."\r\n", FILE_APPEND);  
 	}
 	print json_encode("ERROR",$permisos);
}
//Reinicia el equipo a valores de fabrica
function reiniciarFabrica(){
	
	try{
		$salida = array();
		$midb = conexionLocalSQLite3();
		$midb->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
		$results = $midb->prepare("SELECT name FROM sqlite_master WHERE type ='table' AND name NOT LIKE 'sqlite_%';"); 
		$results->execute();
		if($results){
			while($fila = $results->fetch()){
				$salida[] = $fila['name'];
			}
		}
		
		foreach($salida as $a){
			$results = $midb->prepare("DROP TABLE ".$a); 
			$results->execute();
		}
		
		/*$results = $midb->prepare("DROP TABLE usuarios"); 
		$results->execute();
		$results = $midb->prepare("DROP TABLE mensajesAudio"); 
		$results->execute();
		$results = $midb->prepare("DROP TABLE conexionesWifi"); 
		$results->execute();
		$results = $midb->prepare("DROP TABLE tablaValidaciones"); 
		$results->execute();
		$results = $midb->prepare("DROP TABLE tablaGps"); 
		$results->execute();
		$results = $midb->prepare("DROP TABLE tablaLogGps"); 
		$results->execute();
		$results = $midb->prepare("DROP TABLE tablaRuta"); 
		$results->execute();
		$results = $midb->prepare("DROP TABLE tablaConfiguracion"); 
		$results->execute();
		$results = $midb->prepare("DROP TABLE tablaHistoricos"); 
		$results->execute();
		$results = $midb->prepare("DROP TABLE tablaAlarmas"); 
		$results->execute();
		$results = $midb->prepare("DROP TABLE REGISTROS_CONTEO"); 
		$results->execute();
        $results = $midb->prepare("DROP TABLE configVideo"); 
		$results->execute();
		//Cierra la conexión con la base de datos
		$results = null;
		$midb = null;
	*/	
	}catch(PDOException $e) {
    	echo "Lo siento hay un error en BD..  ". $e->getMessage() ;// Remove or modify after testing 
    	file_put_contents('PDOErrors.txt',date('[Y-m-d H:i:s]').", modelo.php, ". $e->getMessage()."\r\n", FILE_APPEND);  
 	}
	  
 	borrarLogs(null);
	borrarVideos(null);
	
 	exec('sudo nmcli c',$output);
 	$i = 0;
 	foreach($output as $a){
		if(preg_match('/wireless/i',$a)){
			$c = preg_split('/\s+/', $a);
			$result[$i++] = $c[0];
			exec('sudo nmcli connection delete id '.$c[0]);
		}
	}

	$salida = null;
	exec('ifconfig -a | grep wl',$salida);
	$adp = sizeof($salida);
	$adaptador = 'wlan0';
	if($adp == 2){
		$adaptadores = preg_split('/:/',$salida[1]);
		//print_r($adaptadores[0]);
		$adaptador = $adaptadores[0];
	}
	if($adp == 1){
		$adaptadores = preg_split('/:/',$salida[0]);
		//print_r($adaptadores[0]);
		$adaptador = $adaptadores[0];
	}  

	exec('sudo nmcli con add type wifi con-name registeltest ifname '.$adaptador.' ssid registeltest');
	exec('sudo nmcli c modify registeltest wifi-sec.key-mgmt wpa-psk wifi-sec.psk registel4321');
	exec('sudo nmcli con up registeltest');
	
	exec('sudo pkill -9 -f OrangeWifi.jar');
	exec('sudo pkill -9 -f RV60.jar');
	exec('sudo java -jar /home/root/NetBeansProjects/OrangeWifi/dist/OrangeWifi.jar > /dev/null 2>/dev/null &');
	exec('sudo java -jar /home/root/NetBeansProjects/RV60_OrangePi/dist/RV60.jar > /dev/null 2>/dev/null &');
	//print_r($salida);
	//print_r($result);
	printf('FABRICA-OK');
}
//Función que consulta la configuraci�n de los videos
function consultarConfigVideos(){
	//echo "permisosUsuario";
	try{
		$midb = conexionLocalSQLite3();
		$midb->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
		$results = $midb->prepare("SELECT * FROM configVideo"); 
		$results->setFetchMode(PDO::FETCH_ASSOC);
		$results->execute();
		$resultado = "NO_CONFIG";
		if($results){
			while($fila = $results->fetch()){
				$activado = $fila['activado'];
				$aConteo = $fila['aConteo'];
                                $tipoConteo = $fila['tipoConteo'];
                                $tConteo = $fila['tConteo'];
                                $aBloqueo = $fila['aBloqueo'];
                                $tBloqueo = $fila['tBloqueo'];
                                $aTapa = $fila['aTapa'];
                                $tTapa = $fila['tTapa'];
                                $aObstruido = $fila['aObstruido'];
                                $tObstruido = $fila['tObstruido'];
                                $limiteVideos = $fila['limiteVideos'];
                                $resultado = "CONFIG";
			}
		}
		//Cierra la conexión con la base de datos
		$results = null;
		$midb = null;
		
	    printf($resultado.",".$activado.",".$aConteo.",".$tipoConteo.",".$tConteo.",".$aBloqueo.",".$tBloqueo.",".$aTapa.",".$tTapa.",".$aObstruido.",".$tObstruido.",".$limiteVideos);
	    return;
	}catch(PDOException $e) {
    	echo "Lo siento hay un error en BD..  ". $e->getMessage() ;// Remove or modify after testing 
    	file_put_contents('PDOErrors.txt',date('[Y-m-d H:i:s]').", modelo.php, ". $e->getMessage()."\r\n", FILE_APPEND);  
 	}
 	printf("ERROR");
}  
//Funcion que borra todos los videos
function borrarVideos(){
	exec("sudo chmod -R 777 /root/",$returnval);
    exec('sudo rm /var/www/html/RegislogWeb/videos/*',$result);
	exec('sudo rm -r /root/*',$result);
	try{
		$salida = array();
		$midb = conexionLocalSQLite3();
		$midb->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
		$results = $midb->prepare("DELETE FROM listadoVideos;"); 
		$results->execute();
	}catch(PDOException $e) {
    	echo "Lo siento hay un error en BD..  ". $e->getMessage() ;// Remove or modify after testing 
    	file_put_contents('PDOErrors.txt',date('[Y-m-d H:i:s]').", modelo.php, ". $e->getMessage()."\r\n", FILE_APPEND);  
 	}
	print_r('borrarVideos-OK&'.$result[0]);
}
  
//Función que consulta el firmware JAVA
function firmwareJava(){
    //echo "permisosUsuario";
    try{
            $midb = conexionLocalSQLite3();
            $midb->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
            $results = $midb->prepare("SELECT * FROM tablaConfiguracion"); 
            $results->setFetchMode(PDO::FETCH_ASSOC);
            $results->execute();

            if($results){
                while($fila = $results->fetch()){
                    $resultado = $fila['firmware'];

                }
            }
            //Cierra la conexión con la base de datos
            $results = null;
            $midb = null;

        printf("OK,".$resultado);
        return;
    }catch(PDOException $e) {
    echo "Lo siento hay un error en BD..  ". $e->getMessage() ;// Remove or modify after testing 
    file_put_contents('PDOErrors.txt',date('[Y-m-d H:i:s]').", modelo.php, ". $e->getMessage()."\r\n", FILE_APPEND);  
    }
    printf("ERROR");
}

//Función que reproduce un audio
function escucharAudio($audio,$volumen){
    switch($volumen){
		case 0: $valor_vol = -80; break;
		case 25: $valor_vol = -10; break;
		case 50: $valor_vol = 0; break;
		case 75: $valor_vol = 3; break;
		case 100: $valor_vol = 15; break;
	}
    $comando = "sudo mplayer -af volume=".$valor_vol.":0 "."/var/www/html/RegislogWeb/uploads/".$audio;
    
    exec($comando,$result);
    echo $comando;
}

//Función que limpia la carpeta que contiene el codigo Hmtl
function limpiarHtml(){
	if(file_exists("/var/www/html/UsuarioRfid/vistas_c.php")){
		printf("El archivo /var/www/html/UsuarioRfid/vistas_c.php existe.... se procede a borrarlo\n");
		unlink("/var/www/html/UsuarioRfid/vistas_c.php");
	}else printf("El archivo /var/www/html/UsuarioRfid/vistas_c.php NO existe\n");
	if(file_exists("/var/www/html/UsuarioRfid/modelo_c.php")){
		printf("El archivo /var/www/html/UsuarioRfid/modelo_c.php existe.... se procede a borrarlo\n");
		unlink("/var/www/html/UsuarioRfid/modelo_c.php");
	}else printf("El archivo /var/www/html/UsuarioRfid/modelo_c.php NO existe\n");
	if(file_exists("/var/www/html/UsuarioRfid/MensajesControlador.php")){
		printf("El archivo /var/www/html/UsuarioRfid/MensajesControlador.php existe.... se procede a borrarlo\n");
		unlink("/var/www/html/UsuarioRfid/MensajesControlador.php");
	}else printf("El archivo /var/www/html/UsuarioRfid/MensajesControlador.php NO existe\n");
	if(file_exists("/var/www/html/UsuarioRfid/controlador_c.php")){
		printf("El archivo /var/www/html/UsuarioRfid/controlador_c.php existe.... se procede a borrarlo\n");
		unlink("/var/www/html/UsuarioRfid/controlador_c.php");
	}else printf("El archivo /var/www/html/UsuarioRfid/controlador_c.php NO existe\n");
	if(file_exists("/var/www/html/UsuarioRfid/conexionLocal.php")){
		printf("El archivo /var/www/html/UsuarioRfid/conexionLocal.php existe.... se procede a borrarlo\n");
		unlink("/var/www/html/UsuarioRfid/conexionLocal.php");
	}else printf("El archivo /var/www/html/UsuarioRfid/conexionLocal.php NO existe\n");	
	if(file_exists("/var/www/html/UsuarioRfid/mensajes.php")){
		printf("El archivo /var/www/html/UsuarioRfid/mensajes.php existe.... se procede a borrarlo\n");
		unlink("/var/www/html/UsuarioRfid/mensajes.php");
	}else printf("El archivo /var/www/html/UsuarioRfid/mensajes.php NO existe\n");
	if(file_exists("/var/www/html/UsuarioRfid/js/gauge.min.js")){
		printf("El archivo /var/www/html/UsuarioRfid/js/gauge.min.js existe.... se procede a borrarlo\n");
		unlink("/var/www/html/UsuarioRfid/js/gauge.min.js");
	}else printf("El archivo /var/www/html/UsuarioRfid/js/gauge.min.js NO existe\n");
	if(file_exists("/var/www/html/UsuarioRfid/js/enviarMensajes.js")){
		printf("El archivo /var/www/html/UsuarioRfid/js/enviarMensajes.js existe.... se procede a borrarlo\n");
		unlink("/var/www/html/UsuarioRfid/js/enviarMensajes.js");
	}else printf("El archivo /var/www/html/UsuarioRfid/js/enviarMensajes.js NO existe\n");
	if(file_exists("/var/www/html/UsuarioRfid/js/conductor.js")){
		printf("El archivo /var/www/html/UsuarioRfid/js/conductor.js existe.... se procede a borrarlo\n");
		unlink("/var/www/html/UsuarioRfid/js/conductor.js");
	}else printf("El archivo /var/www/html/UsuarioRfid/js/conductor.js NO existe\n");
	
	//Limpieza de videos de 0K y de prueba
	exec(" ls -sh /var/www/html/RegislogWeb/videos/",$output);
      
	foreach($output as $a){
		$resul = preg_split("/[\s,]+/",$a);
		if(count($resul) >= 2 && $resul[count($resul)-2] == '0'){
			printf("Se borra /var/www/html/RegislogWeb/videos/".$resul[count($resul)-1]);
			unlink("/var/www/html/RegislogWeb/videos/".$resul[count($resul)-1]);
			
		}
		/*if(strpos($resul[count($resul)-1], 'avi') !== false) {
			printf("Se borra /var/www/html/RegislogWeb/videos/".$resul[count($resul)-1]);
			unlink("/var/www/html/RegislogWeb/videos/".$resul[count($resul)-1]);
		}*/
		if(strpos($resul[count($resul)-1], 'prueba') !== false) {
			printf("Se borra /var/www/html/RegislogWeb/videos/".$resul[count($resul)-1]);
			unlink("/var/www/html/RegislogWeb/videos/".$resul[count($resul)-1]);
		}
	}
	printf("OK-LIMPIEZA HMTL\n");
}

  

 ?>