import sys
import cv2
import time
import datetime

resultado = 0
cap = cv2.VideoCapture(0)
if cap.isOpened()==False:
  print(resultado)
  sys.exit(1)
#print("Tiempo de grabado:"+sys.argv[1])
# Define the codec and create VideoWriter object
fourcc = cv2.cv.CV_FOURCC(*'XVID')
out = cv2.VideoWriter('/var/www/html/RegislogWeb/videos/'+str(sys.argv[2])+'.avi',fourcc, 10.0, (640,480))

retardo = 100.0 / 1000.0

numero_fotogramas = 0

frameWidth = int(cap.get(cv2.cv.CV_CAP_PROP_FRAME_WIDTH))
frameHeight = int(cap.get(cv2.cv.CV_CAP_PROP_FRAME_HEIGHT))

while(cap.isOpened()):
  ret, frame = cap.read()
  if ret==True:
    frame = cv2.flip(frame,1)
    d_date = datetime.datetime.now()
    reg_format_date = d_date.strftime("%Y-%m-%d %I:%M:%S %p")
    cv2.putText(frame,reg_format_date, (0,frameHeight/7), cv2.FONT_HERSHEY_SIMPLEX,0.5,(255, 255, 255))
    # write the flipped frame
    out.write(frame)
    numero_fotogramas += 1
  else: 
    resultado = 2 
		
  #print("Fotogramas: "+str(numero_fotogramas))
  if numero_fotogramas >= (int(sys.argv[1])/retardo):
    resultado = 1

  if resultado == 2 or resultado == 1:
    break
  time.sleep (retardo);
  
# Release everything if job is finished
#print("Finalizando aplicacion")
cap.release()
out.release()
print(resultado)
cv2.destroyAllWindows()